#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ProcessHelp {} {
    global argc
    global argv

    if {$argc > 0 && ([lindex $argv 0] == "-?")} {
	DumpHelp
	exit
    }
}

proc BadVisualError {} {
    global ds9

    tk_messageBox -parent $ds9(top) -icon info -type ok -message \
	"Sorry, DS9 requires a Pseudocolor8, Truecolor8, Truecolor16, Truecolor24 visual be available."
    exit
}

proc ProcessModeCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global ds9
    set ds9(mode) [string tolower [lindex $var $i]]
    ChangeMode
}

proc ProcessCommandLineFirst {} {
    global argc
    global argv
    global colorbar
    global ds9

    set i 0
    while {$i < $argc} {
	set item [lindex $argv $i]
	switch -- $item {
	    -debug {incr i; ProcessDebugTclCmd argv i}
	    -private {set colorbar(private) true}
	    -title {
		incr i
		set ds9(title) [lindex $argv $i]
		set t "SAOImage $ds9(title)"
		wm title $ds9(top) "$t"
		wm iconname $ds9(top) "$t"
	    }
	}
	incr i
    }
}

proc ProcessCommandLineXPA {} {
    global argc
    global argv
    global xpa

    set i 0
    while {$i < $argc} {
	set item [lindex $argv $i]
	switch -- $item {
	    -vo {incr i; ProcessVOCmd argv i}
	}
	incr i
    }
}

proc ProcessCommandLine {} {
    global argc
    global argv

    global ds9
    global help
    global current
    global contour
    global colorbar
    global debug
    global wcs
    global view
    global grid
    global bin
    global scale
    global iis
    global minmax
    global tcl_platform
    global http

    set frameCount 0
    set load 0
    set file(mode) fits
    set file(mode,mosaic) iraf
    set i 0

    # Note: help is processed previously
    while {$i < $argc} {
	set item [lindex $argv $i]

	switch -- $item {
	    -2mass {incr i; Process2MASSCmd argv i 1 frameCount}
	    -about {
		if {$tcl_platform(platform)!= "windows"} {
		    puts "$help(about)"
		}
	    }
	    -align {
		# backward compatibility
		LogEval {set wcs(align) 1; AlignWCSFrame}
	    }
	    -analysis -
	    -analysismenu {
		incr i
		set item [lindex $argv $i]
		ProcessAnalysisFile $item
		FileLastFull analysisfbox $item
		LayoutFrames
	    }
	    -array {set file(mode) array}
	    -bin {incr i; ProcessBinCmd argv i}
	    -blink {incr i; ProcessBlinkCmd argv i}
	    -blue {set current(rgb) blue; RGBChannel}
	    -cat -
	    -catalog {incr i; ProcessCatalogCmd argv i}
	    -cmap {incr i; ProcessCmapCmd argv i}
	    -colorbar {
		# backward compatibility
		set view(colorbar,next) 1
		UpdateView
	    }
	    -nocolorbar {
		# backward compatibility
		set view(colorbar,next) 0
		UpdateView
	    }
	    -contour {incr i; ProcessContourCmd argv i}
	    -nocontour {set contour(view) 0; ContourUpdate}
	    -crosshair {incr i; ProcessCrosshairCmd arv i}
	    -datacube {incr i; ProcessDataCubeCmd argv i}
	    -debug {incr i; ProcessDebugCmd argv i}
	    -dss {incr i; ProcessDSSCmd argv i 1 frameCount}
	    -exit {QuitDS9}
	    -quit {QuitDS9}
	    -frame {incr i; ProcessFrameCmd argv i}
	    -fifo {
		incr i
		set fifo [lindex $argv $i]
		if {$fifo!="none"} {
		    set iis(ififo) ${fifo}i
		    set iis(ofifo) ${fifo}o
		} else {
		    set iis(ififo) none
		    set iis(ofifo) none
		}
	    }
	    -fifo_only {set iis(port) 0; set iis(unix) none}
	    -file -
	    -fits {set file(mode) fits}
	    -sfits {set file(mode) sfits}
	    -geometry {
		# already processed
	    }
	    -green {set current(rgb) green; RGBChannel}
	    -grid {incr i; ProcessGridCmd argv i}
	    -nogrid {set grid(view) 0; GridUpdate}
	    -help {
		if {$tcl_platform(platform)!= "windows"} {
		    DumpHelp
		    exit
		}
	    }
	    -height {incr i; ProcessHeightCmd argv i}
	    -histequ {set scale(type) histequ; ChangeScale}
	    -horzgraph {
		# backward compatibility
		set view(graph,horz) 1
		UpdateView
	    }
	    -nohorzgraph {
		# backward compatibility
		set view(graph,horz) 0
		UpdateView
	    }
	    -info {
		# backward compatibility
		set view(info) 1
		UpdateView
	    }
	    -noinfo {
		# backward compatibility
		set view(info) 0
		UpdateView
	    }
	    -iconify {incr i; ProcessIconifyCmd argv i}
	    -invert {set colorbar(invert) 1; InvertColorbar}
	    -lock {incr i; ProcessLockCmd argv i}
	    -linear {set scale(type) linear; ChangeScale}
	    -log {set scale(type) log; ChangeScale}
	    -lower {ProcessLowerCmd argv i}
	    -magnifier {
		# backward compatibility
		set view(magnifier) 1
		UpdateView
	    }
	    -nomagnifier {
		# backward compatibility
		set view(magnifier) 0
		UpdateView
	    }
	    -match {incr i; ProcessMatchCmd argv i}
	    -medatacube {set file(mode) medatacube}
	    -minmax {incr i; ProcessMinMaxCmd argv i}
	    -minmaxmode {
		# backward compatibility
		incr i
		set minmax(mode) [lindex $argv $i]
	    }
	    -minmaxsample {
		# backward compatibility
		incr i
		set minmax(sample) [lindex $argv $i]
	    }
	    -mode {incr i; ProcessModeCmd argv i}

	    -mosaicimage {
		set file(mode) mosaicimage
		set aa [lindex $argv [expr $i+1]]
		switch -- $aa {
		    iraf {incr i; set file(mode,mosaic) iraf}
		    wfpc2 {incr i; set file(mode,mosaic) wfpc2}
		    wcs {incr i; set file(mode,mosaic) wcs}
		    wcsa {incr i; set file(mode,mosaic) wcsa}
		    wcsb {incr i; set file(mode,mosaic) wcsb}
		    wcsc {incr i; set file(mode,mosaic) wcsc}
		    wcsd {incr i; set file(mode,mosaic) wcsd}
		    wcse {incr i; set file(mode,mosaic) wcse}
		    wcsf {incr i; set file(mode,mosaic) wcsf}
		    wcsg {incr i; set file(mode,mosaic) wcsg}
		    wcsh {incr i; set file(mode,mosaic) wcsh}
		    wcsi {incr i; set file(mode,mosaic) wcsi}
		    wcsj {incr i; set file(mode,mosaic) wcsj}
		    wcsk {incr i; set file(mode,mosaic) wcsk}
		    wcsl {incr i; set file(mode,mosaic) wcsl}
		    wcsm {incr i; set file(mode,mosaic) wcsm}
		    wcsn {incr i; set file(mode,mosaic) wcsn}
		    wcso {incr i; set file(mode,mosaic) wcso}
		    wcsp {incr i; set file(mode,mosaic) wcsp}
		    wcsq {incr i; set file(mode,mosaic) wcsq}
		    wcsr {incr i; set file(mode,mosaic) wcsr}
		    wcss {incr i; set file(mode,mosaic) wcss}
		    wcst {incr i; set file(mode,mosaic) wcst}
		    wcsu {incr i; set file(mode,mosaic) wcsu}
		    wcsv {incr i; set file(mode,mosaic) wcsv}
		    wcsw {incr i; set file(mode,mosaic) wcsw}
		    wcsx {incr i; set file(mode,mosaic) wcsx}
		    wcsy {incr i; set file(mode,mosaic) wcsy}
		    wcsz {incr i; set file(mode,mosaic) wcsz}
		    default {set file(mode,mosaic) iraf}
		}
	    }
	    -mosaicimagenext {
		set file(mode) mosaicimagenext
		set aa [lindex $argv [expr $i+1]]
		switch -- $aa {
		    wcs {incr i; set file(mode,mosaic) wcs}
		    wcsa {incr i; set file(mode,mosaic) wcsa}
		    wcsb {incr i; set file(mode,mosaic) wcsb}
		    wcsc {incr i; set file(mode,mosaic) wcsc}
		    wcsd {incr i; set file(mode,mosaic) wcsd}
		    wcse {incr i; set file(mode,mosaic) wcse}
		    wcsf {incr i; set file(mode,mosaic) wcsf}
		    wcsg {incr i; set file(mode,mosaic) wcsg}
		    wcsh {incr i; set file(mode,mosaic) wcsh}
		    wcsi {incr i; set file(mode,mosaic) wcsi}
		    wcsj {incr i; set file(mode,mosaic) wcsj}
		    wcsk {incr i; set file(mode,mosaic) wcsk}
		    wcsl {incr i; set file(mode,mosaic) wcsl}
		    wcsm {incr i; set file(mode,mosaic) wcsm}
		    wcsn {incr i; set file(mode,mosaic) wcsn}
		    wcso {incr i; set file(mode,mosaic) wcso}
		    wcsp {incr i; set file(mode,mosaic) wcsp}
		    wcsq {incr i; set file(mode,mosaic) wcsq}
		    wcsr {incr i; set file(mode,mosaic) wcsr}
		    wcss {incr i; set file(mode,mosaic) wcss}
		    wcst {incr i; set file(mode,mosaic) wcst}
		    wcsu {incr i; set file(mode,mosaic) wcsu}
		    wcsv {incr i; set file(mode,mosaic) wcsv}
		    wcsw {incr i; set file(mode,mosaic) wcsw}
		    wcsx {incr i; set file(mode,mosaic) wcsx}
		    wcsy {incr i; set file(mode,mosaic) wcsy}
		    wcsz {incr i; set file(mode,mosaic) wcsz}
		    default {set file(mode,mosaic) wcs}
		}
	    }
	    -mosaic {
		set file(mode) mosaic
		set aa [lindex $argv [expr $i+1]]
		switch -- $aa {
		    iraf {incr i; set file(mode,mosaic) iraf}
		    wcs {incr i; set file(mode,mosaic) wcs}
		    wcsa {incr i; set file(mode,mosaic) wcsa}
		    wcsb {incr i; set file(mode,mosaic) wcsb}
		    wcsc {incr i; set file(mode,mosaic) wcsc}
		    wcsd {incr i; set file(mode,mosaic) wcsd}
		    wcse {incr i; set file(mode,mosaic) wcse}
		    wcsf {incr i; set file(mode,mosaic) wcsf}
		    wcsg {incr i; set file(mode,mosaic) wcsg}
		    wcsh {incr i; set file(mode,mosaic) wcsh}
		    wcsi {incr i; set file(mode,mosaic) wcsi}
		    wcsj {incr i; set file(mode,mosaic) wcsj}
		    wcsk {incr i; set file(mode,mosaic) wcsk}
		    wcsl {incr i; set file(mode,mosaic) wcsl}
		    wcsm {incr i; set file(mode,mosaic) wcsm}
		    wcsn {incr i; set file(mode,mosaic) wcsn}
		    wcso {incr i; set file(mode,mosaic) wcso}
		    wcsp {incr i; set file(mode,mosaic) wcsp}
		    wcsq {incr i; set file(mode,mosaic) wcsq}
		    wcsr {incr i; set file(mode,mosaic) wcsr}
		    wcss {incr i; set file(mode,mosaic) wcss}
		    wcst {incr i; set file(mode,mosaic) wcst}
		    wcsu {incr i; set file(mode,mosaic) wcsu}
		    wcsv {incr i; set file(mode,mosaic) wcsv}
		    wcsw {incr i; set file(mode,mosaic) wcsw}
		    wcsx {incr i; set file(mode,mosaic) wcsx}
		    wcsy {incr i; set file(mode,mosaic) wcsy}
		    wcsz {incr i; set file(mode,mosaic) wcsz}
		    default {set file(mode,mosaic) iraf}
		}
	    }
	    -smosaic {
		set file(mode) smosaic
		set aa [lindex $argv [expr $i+1]]
		switch -- $aa {
		    iraf {incr i; set file(mode,mosaic) iraf}
		    wcs {incr i; set file(mode,mosaic) wcs}
		    wcsa {incr i; set file(mode,mosaic) wcsa}
		    wcsb {incr i; set file(mode,mosaic) wcsb}
		    wcsc {incr i; set file(mode,mosaic) wcsc}
		    wcsd {incr i; set file(mode,mosaic) wcsd}
		    wcse {incr i; set file(mode,mosaic) wcse}
		    wcsf {incr i; set file(mode,mosaic) wcsf}
		    wcsg {incr i; set file(mode,mosaic) wcsg}
		    wcsh {incr i; set file(mode,mosaic) wcsh}
		    wcsi {incr i; set file(mode,mosaic) wcsi}
		    wcsj {incr i; set file(mode,mosaic) wcsj}
		    wcsk {incr i; set file(mode,mosaic) wcsk}
		    wcsl {incr i; set file(mode,mosaic) wcsl}
		    wcsm {incr i; set file(mode,mosaic) wcsm}
		    wcsn {incr i; set file(mode,mosaic) wcsn}
		    wcso {incr i; set file(mode,mosaic) wcso}
		    wcsp {incr i; set file(mode,mosaic) wcsp}
		    wcsq {incr i; set file(mode,mosaic) wcsq}
		    wcsr {incr i; set file(mode,mosaic) wcsr}
		    wcss {incr i; set file(mode,mosaic) wcss}
		    wcst {incr i; set file(mode,mosaic) wcst}
		    wcsu {incr i; set file(mode,mosaic) wcsu}
		    wcsv {incr i; set file(mode,mosaic) wcsv}
		    wcsw {incr i; set file(mode,mosaic) wcsw}
		    wcsx {incr i; set file(mode,mosaic) wcsx}
		    wcsy {incr i; set file(mode,mosaic) wcsy}
		    wcsz {incr i; set file(mode,mosaic) wcsz}
		    default {set file(mode,mosaic) iraf}
		}
	    }

	    -mosaicimageiraf {
		# backward compatibility
		set file(mode) mosaicimage
		set file(mode,mosaic) iraf
	    }
	    -mosaicimagewcs {
		# backward compatibility
		set file(mode) mosaicimage
		set file(mode,mosaic) wcs
	    }
	    -mosaicimagewfpc2 {
		# backward compatibility
		set file(mode) mosaicimage
		set file(mode,mosaic) wfpc2
	    }

	    -mosaicimagenextwcs {
		# backward compatibility
		set file(mode) mosaicimagenext
		set file(mode,mosaic) wcs
	    }

	    -mosaiciraf {
		# backward compatibility
		set file(mode) mosaic
		set file(mode,mosaic) iraf
	    }
	    -mosaicwcs {
		# backward compatibility
		set file(mode) mosaic
		set file(mode,mosaic) wcs
	    }

	    -nameserver {incr i; ProcessNRESCmd argv i}
	    -orient {incr i; ProcessOrientCmd argv i}
	    -pagesetup {incr i; ProcessPageSetupCmd argv i}
	    -pan {RealizeDS9; incr i; ProcessPanCmd argv i}
	    -panner {
		# backward compatibility
		set view(panner) 1
		UpdateView
	    }
	    -nopanner {
		# backward compatibility
		set view(panner) 0
		UpdateView
	    }
	    -pixeltable {incr i; ProcessPixelTableCmd argv i}
	    -nopixeltable {PixelTableDestroyDialog}
	    -plot {incr i; set buf {}; ProcessPlotCmd argv i buf}
	    -port {incr i; set iis(port) [lindex $argv $i]}
	    -inet_only -
	    -port_only {
		set iis(ififo) none
		set iis(ofifo) none
		set iis(unix) none
	    }
	    -prefs {incr i; ProcessPrefsCmd argv i}
	    -preserve {incr i; ProcessPreserveCmd argv i}
	    -print {incr i; ProcessPrintCmd argv i}
	    -private {
		#already processed
	    }
	    -raise {ProcessRaiseCmd argv i}
	    -red {set current(rgb) red; RGBChannel}
	    -region -
	    -regions -
	    -regionfile {RealizeDS9; incr i; ProcessMarkerCmd argv i}
	    -rgb {incr i; ProcessRGBCmd argv i}
	    -rgbcube {set file(mode) rgbcube}
	    -srgbcube {set file(mode) srgbcube}
	    -rgbimage {set file(mode) rgbimage}
	    -rgbarray {set file(mode) rgbarray}
	    -rotate {incr i; ProcessRotateCmd argv i}
	    -saveas -
	    -saveimage {incr i; ProcessSaveImageCmd argv i}
	    -savefits {incr i; ProcessSaveFitsCmd argv i}
	    -savempeg {incr i; ProcessSaveMPEGCmd argv i}
	    -scale -
	    -ztrans {incr i; ProcessScaleCmd argv i}
	    -scalelims -
	    -scalelimits {
		#backward compatibility
		incr i
		set scale(usermin) [lindex $argv $i]
		incr i
		set scale(usermax) [lindex $argv $i]
		ChangeScaleLimit
	    }
	    -scalemode {
		#backward compatibility
		incr i
		set scale(mode) [string tolower [lindex $argv $i]]
		ChangeScaleMode
	    }
	    -scalescope {
		#backward compatibility
		incr i
		set scale(scope) [string tolower [lindex $argv $i]]
		ChangeScaleScope
	    }
	    -shm {incr i; ProcessShmCmd argv i 1 frameCount}
	    -single {incr i; ProcessSingleCmd argv i}
	    -smooth {incr i; ProcessSmoothCmd argv i}
	    -squared {set scale(type) squared; ChangeScale}
	    -sqrt {set scale(type) sqrt; ChangeScale}
	    -source {incr i; ProcessSourceCmd argv i}
	    -tile {incr i; ProcessTileCmd argv i}
	    -title {
		#already processed
		incr i
	    }
	    -unix {incr i; set iis(unix) [lindex $argv $i]}
	    -unix_only {
		set iis(ififo) none
		set iis(ofifo) none
		set iis(port) 0
	    }
	    -url {set file(mode) url}
	    -version {
		if {$tcl_platform(platform)!= "windows"} {
		    puts "$ds9(version)"
		}
	    }
	    -vertgraph {
		#backward compatibility
		set view(graph,vert) 1
		UpdateView
	    }
	    -novertgraph {
		#backward compatibility
		set view(graph,vert) 0
		UpdateView
	    }
	    -coords -
	    -view {incr i; ProcessViewCmd argv i}
	    -visual {
		#already processed
	    }
	    -vo {
		#will process later
		incr i
	    }
	    -wcs {incr i; ProcessWCSCmd argv i}
	    -wcsformat {
		#backward compatibility
		incr i
		set wcs(format,) [lindex $argv $i]
	    }
	    -web {incr i; ProcessWebCmd argv i}
	    -width {incr i; ProcessWidthCmd argv i}
	    -xpa {incr i; ProcessXPACmd argv i}
	    -z1 {
		#backward compatibility
		incr i
		set scale(usermin) [lindex $argv $i]
		ChangeScaleLimit
	    }
	    -z2 {
		#backward compatibility
		incr i
		set scale(usermax) [lindex $argv $i]
		ChangeScaleLimit
	    }
	    -zmax {set scale(mode) zmax; ChangeScaleMode}
	    -zscale {set scale(mode) zscale; ChangeScaleMode}
	    -zoom {incr i; ProcessZoomCmd argv i}

	    default {
		if {([string length $item] == 1) || \
		        ([string range $item 0 1] == {-[}) || \
			([string range $item 0 0] != "-")} {

		    if {$load == 0} {
		        StartLoad
		        incr load
		    }

		    # normalize to native path format
		    if {[string range $item 0 0] != "-" && 
			$file(mode) != "url"} {
			set item [file normalize $item]
		    }

		    switch -- [$current(frame) get type] {
			base {
			    switch -- $file(mode) {
				array {
				    MultiLoad frameCount
				    LoadArray $item
				    FileLastFull arrayfbox $item
				}
				fits {
				    MultiLoad frameCount
				    LoadFits $item
				    FileLastFull fitsfbox $item
				}
				sfits {
				    MultiLoad frameCount
				    incr i
				    LoadSFits $item [lindex $argv $i]
				    FileLastFull fitsfbox $item
				}
				medatacube {
				    MultiLoad frameCount
				    LoadDataCubeFits $item
				    FileLastFull fitsfbox $item
				}

				mosaicimage {
				    MultiLoad frameCount
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicImageIRAFFits $item}
					wfpc2 {LoadMosaicImageWFPC2Fits $item}
					default {LoadMosaicImageWCSFits \
						$file(mode,mosaic) $item}
				    }
				    FileLastFull fitsfbox $item
				}
				mosaicimagenext {
				    LoadMosaicImageWCSFits \
					$file(mode,mosaic) $item
				    FileLastFull fitsfbox $item
				}
				mosaic {
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicIRAFFits $item}
					default {LoadMosaicWCSFits \
						$file(mode,mosaic) $item}
				    }
				    FileLastFull fitsfbox $item
				}
				smosaic {
				    incr i
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicIRAFSFits $item \
						  [lindex $argv $i]}
					default {LoadMosaicWCSSFits \
						     $file(mode,mosaic) $item \
						     [lindex $argv $i]}
				    }
				    FileLastFull fitsfbox $item
				}

				rgbcube {
				    MultiRGBLoad frameCount
				    LoadRGBCubeFits $item
				    FileLastFull fitsfbox $item
				}
				srgbcube {
				    MultiRGBLoad frameCount
				    incr i
				    LoadRGBCubeSFits $item [lindex $argv $i]
				    FileLastFull fitsfbox $item
				}
				rgbimage {
				    MultiRGBLoad frameCount
				    LoadRGBImageFits $item
				    FileLastFull fitsfbox $item
				}
				rgbarray {
				    MultiRGBLoad frameCount
				    LoadRGBArray $item
				    FileLastFull arrayfbox $item
				}
				url {
				    MultiLoad frameCount
				    LoadURL $item
				    set http(last) $item
				}
			    }
			}
			rgb {
			    switch -- $file(mode) {
				array {
				    LoadArray $item
				    FileLastFull arrayfbox $item
				}
				fits {
				    LoadFits $item
				    FileLastFull fitsfbox $item
				}
				sfits {
				    incr i
				    LoadSFits $item [lindex $argv $i]
				    FileLastFull fitsfbox $item
				}
				medatacube {
				    LoadDataCubeFits $item
				    FileLastFull fitsfbox $item
				}

				mosaicimage {
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicImageIRAFFits $item}
					wfpc2 {LoadMosaicImageWFPC2Fits $item}
					default {LoadMosaicImageWCSFits \
						$file(mode,mosaic) $item}
				    }
				    FileLastFull fitsfbox $item
				}
				mosaicimagenext {
				    LoadMosaicImageWCSFits \
					$file(mode,mosaic) $item
				    FileLastFull fitsfbox $item
				}
				mosaic {
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicIRAFFits $item}
					default {LoadMosaicWCSFits \
						$file(mode,mosaic) $item}
				    }
				    FileLastFull fitsfbox $item
				}
				smosaic {
				    incr i
				    switch -- $file(mode,mosaic) {
					iraf {LoadMosaicIRAFSFits $item \
						  [lindex $argv $i]}
					default {LoadMosaicWCSSFits \
						$file(mode,mosaic) $item \
						     [lindex $argv $i]}
				    }
				    FileLastFull fitsfbox $item
				}

				rgbcube {
				    MultiRGBLoad frameCount
				    LoadRGBCubeFits $item
				    FileLastFull fitsfbox $item
				}
				srgbcube {
				    MultiRGBLoad frameCount
				    incr i
				    LoadRGBCubeSFits $item [lindex $argv $i]
				    FileLastFull fitsfbox $item
				}
				rgbimage {
				    MultiRGBLoad frameCount
				    LoadRGBImageFits $item
				    FileLastFull fitsfbox $item
				}
				rgbarray {
				    MultiRGBLoad frameCount
				    LoadRGBArray $item
				    FileLastFull arrayfbox $item
				}
				url {
				    LoadURL $item
				    set http(last) $item
				}
			    }
			}
		    }
		    GridUpdate
		    ContourUpdate
		    
		} else {
		    if {$tcl_platform(platform) != "windows"} {
			puts "Unknown command line option: $item"
			DumpHelp
			exit
		    }
		}
	    }
	}
	incr i
    }

    if {$load != 0} {
        FinishLoad
    }
}

