// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __panner_h__
#define __panner_h__

#include "widget.h"

class Panner : public Widget {
private:
  Pixmap thumbnail;          // current frame thumbnail pixmap
  BBox bbox;                 // current view
  int highLite;              // flag to highlite bbox
  int panning;               // flag for panning status
  Vector panStart;           // initial location of panning operation
  Rotate imageCompass;       // compass orientation matrix
  Vector wcsNorth;           // wcs north unit vector
  Vector wcsEast;            // wcs east unit vector
  int useBBox;               // flag to use BBox
  int useImageCompass;       // flag to use image compass
  int useWCSCompass;         // flag to use wcs compass
  int validWCSCompass;       // flag to indicate wcs data is valid
  int useFont;               // flag to use fonts
  int needsUpdate;           // flag to indicate refresh needed

  Tk_Font font;              // Tk font
  Tk_FontMetrics metric;     // Tk font metric
				  
  GC bboxGC;                 // bbox gc
  GC compassGC;              // compass gc

  void update();             // use existing pixmap, just update
  void invalidPixmap();      // new pixmap, then update

protected:
  virtual void clearPixmap() =0;  // clear pixmap

private:
  int updatePixmap(const BBox&); // renders image/graphics into pixmap
  void renderBBox();
  void renderImageCompass();
  void renderWCSCompass();
  void renderArm(int, Vector&, Rotate&, char*, int);
  void updateGCs();

public:
  Panner(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~Panner();

#if __GNUC__ >= 3
  int parse(istringstream&);            // parse subcommands
#else
  int parse(istrstream&);            // parse subcommands
#endif

  // SubCommandFunctions

  void getBBoxCmd();
  void getSizeCmd();
  void highLiteCmd(int);
  void highLiteCmd(Vector);
  void panToCmd(Vector);
  void panBeginCmd(Vector);
  void panMotionCmd(Vector);
  void panEndCmd(Vector);
  void setImageCompassCmd(int);
  void setWCSCompassCmd(int);
  void setBBoxCmd(int);
  void updateCmd(Pixmap);
  void updateBBoxCmd(BBox);
  void updateImageCompassCmd(Rotate);
  void updateWCSCompassCmd();
  void updateWCSCompassCmd(Vector,Vector);
  void warpCmd(Vector);
};

#endif

