// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%{
#define YYPARSE_PARAM mg
#define MG ((Magnifier*)mg)
#define YYDEBUG 1

#include <stdlib.h>
#include "magnifier.h"

extern int mglex(void);
extern void mgerror(const char*);

%}

%union {
  float real;
  int integer;
  char str[256];
}

%type <real> numeric
%type <integer> yesno

%token <integer> INT
%token <real> REAL
%token <str> STRING

%token BBOX_
%token CLEAR_
%token DEBUG_
%token FALSE_
%token GET_
%token HEIGHT_
%token HIDE_
%token OFF_
%token ON_
%token N_
%token NO_
%token RESET_
%token SHOW_
%token TRUE_
%token UPDATE_
%token VERSION_
%token WIDTH_
%token Y_
%token YES_

%%

command : DEBUG_ yesno {yydebug=$2;}

	| CLEAR_ {MG->updateCmd(0);}
	| GET_ get
	| HIDE_ {MG->hideCmd();}
	| RESET_ {MG->resetCmd();}
	| SHOW_ {MG->showCmd();}
	| UPDATE_ INT {MG->updateCmd($2);}
	| VERSION_ {MG->msg("Magnifier 1.0");}
	;

numeric	: REAL {$$=$1;}
	| INT {$$=$1;}
	;

yesno	: INT {$$=($1 ? 1 : 0);}

	| YES_ {$$=1;}
	| Y_ {$$=1;}
	| ON_ {$$=1;}
	| TRUE_ {$$=1;}

	| NO_ {$$=0;}
	| N_ {$$=0;}
	| OFF_ {$$=0;}
	| FALSE_ {$$=0;}
	;

get	: BBOX_ {MG->getBBoxCmd();}
	| HEIGHT_ {MG->getHeightCmd();}
	| WIDTH_ {MG->getWidthCmd();}
	;

%%




