/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse saoparse
#define yylex   saolex
#define yyerror saoerror
#define yylval  saolval
#define yychar  saochar
#define yydebug saodebug
#define yynerrs saonerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     INT = 258,
     REAL = 259,
     STRING = 260,
     ANNULUS_ = 261,
     BOX_ = 262,
     CIRCLE_ = 263,
     DEBUG_ = 264,
     ELLIPSE_ = 265,
     N_ = 266,
     OFF_ = 267,
     ON_ = 268,
     POINT_ = 269,
     POLYGON_ = 270,
     ROTBOX_ = 271,
     VERSION_ = 272
   };
#endif
#define INT 258
#define REAL 259
#define STRING 260
#define ANNULUS_ 261
#define BOX_ 262
#define CIRCLE_ 263
#define DEBUG_ 264
#define ELLIPSE_ 265
#define N_ 266
#define OFF_ 267
#define ON_ 268
#define POINT_ 269
#define POLYGON_ 270
#define ROTBOX_ 271
#define VERSION_ 272




/* Copy the first part of user declarations.  */
#line 5 "saoparser.Y"

#define YYPARSE_PARAM fr
#define YYDEBUG 1

#define FR ((FrameBase*)fr)
#define FITSPTR (FR->findFits(1))

#define DISCARD_(x) {yyclearin; saoDiscard(x);}

#include <math.h>
#include <string.h>
#include <iostream.h>

#include "framebase.h"
#include "fitsimage.h"
#include "util.h"
#include "vector.h"
#include "list.h"
#include "basemarker.h"
#include "coord.h"

extern int saolex(void);
extern void saoerror(const char*);
extern void saoDiscard(int);

static unsigned short globalProps;
static unsigned short localProps;

static char *color = "green";
static char *font = "helvetica 10 normal";
static char *text = "";

static char localComment[80];

static List<Vertex> polylist;
static List<Tag> taglist;

static double aAnnuli[MAXANNULI];
static Vector aVector[MAXANNULI];
static int aNum;
static int aStatus;
static Vector aCenter;
static double aAngle;
static unsigned short aProps;
static char aComment[80];

static void setProps(unsigned short* props, unsigned short prop, int value);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 55 "saoparser.Y"
typedef union YYSTYPE {
  double real;
  int integer;
  char str[256];
  double vector[3];
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 175 "saoparser.C"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 187 "saoparser.C"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   155

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  29
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  31
/* YYNRULES -- Number of rules. */
#define YYNRULES  58
/* YYNRULES -- Number of states. */
#define YYNSTATES  138

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   272

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      18,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    27,     2,    28,     2,     2,    26,     2,
      21,    22,     2,    24,    20,    25,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    19,
       2,    23,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     7,    11,    14,    15,    18,    20,    24,
      26,    28,    30,    32,    34,    36,    38,    39,    41,    42,
      44,    45,    47,    48,    50,    52,    54,    58,    62,    66,
      67,    68,    69,    71,    73,    81,    91,   101,   111,   112,
     119,   125,   135,   136,   149,   161,   180,   199,   203,   205,
     207,   211,   213,   215,   216,   217,   221,   223,   224
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      30,     0,    -1,    45,    31,    55,    -1,    31,    32,    33,
      -1,    32,    33,    -1,    -1,     9,    35,    -1,    17,    -1,
      46,    47,    48,    -1,    56,    -1,    18,    -1,    19,    -1,
       4,    -1,     3,    -1,    13,    -1,    12,    -1,    -1,    20,
      -1,    -1,    21,    -1,    -1,    22,    -1,    -1,    40,    -1,
      34,    -1,    34,    -1,    34,    36,    34,    -1,    11,    23,
       3,    -1,    34,    36,    34,    -1,    -1,    -1,    -1,    24,
      -1,    25,    -1,     8,    37,    44,    36,    41,    38,    58,
      -1,    10,    37,    44,    36,    42,    36,    39,    38,    58,
      -1,     7,    37,    44,    36,    42,    36,    39,    38,    58,
      -1,    16,    37,    44,    36,    42,    36,    39,    38,    58,
      -1,    -1,    15,    49,    37,    51,    38,    58,    -1,    14,
      37,    44,    38,    58,    -1,     6,    37,    44,    36,    41,
      36,    41,    38,    58,    -1,    -1,     6,    37,    44,    36,
      41,    36,    41,    36,    50,    53,    38,    58,    -1,     6,
      37,    44,    36,    41,    36,    41,    36,    43,    38,    58,
      -1,    10,    37,    44,    36,    42,    36,    39,    38,    26,
      27,    10,    37,    44,    36,    42,    36,    39,    38,    -1,
       7,    37,    44,    36,    42,    36,    39,    38,    26,    27,
       7,    37,    44,    36,    42,    36,    39,    38,    -1,    51,
      36,    52,    -1,    52,    -1,    44,    -1,    53,    36,    54,
      -1,    54,    -1,    41,    -1,    -1,    -1,    28,    57,     5,
      -1,    55,    -1,    -1,    28,    59,     5,    55,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,    90,    90,    93,    94,    97,    98,    99,   100,   101,
     104,   105,   108,   109,   112,   113,   116,   117,   120,   121,
     124,   125,   128,   129,   132,   135,   138,   147,   150,   159,
     167,   170,   171,   172,   175,   179,   194,   208,   212,   212,
     216,   220,   223,   223,   231,   235,   242,   250,   251,   254,
     257,   258,   261,   265,   288,   288,   291,   292,   292
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INT", "REAL", "STRING", "ANNULUS_", 
  "BOX_", "CIRCLE_", "DEBUG_", "ELLIPSE_", "N_", "OFF_", "ON_", "POINT_", 
  "POLYGON_", "ROTBOX_", "VERSION_", "'\\n'", "';'", "','", "'('", "')'", 
  "'='", "'+'", "'-'", "'&'", "'!'", "'#'", "$accept", "start", 
  "commands", "command", "terminator", "numeric", "debug", "sp", "bp", 
  "ep", "optangle", "angle", "value", "vvalue", "numberof", "coord", 
  "initGlobal", "initLocal", "include", "shape", "@1", "@2", "polyNodes", 
  "polyNode", "aRads", "aRad", "processAnnulus", "generalComment", "@3", 
  "shapeComment", "@4", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,    10,    59,
      44,    40,    41,    61,    43,    45,    38,    33,    35
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    29,    30,    31,    31,    32,    32,    32,    32,    32,
      33,    33,    34,    34,    35,    35,    36,    36,    37,    37,
      38,    38,    39,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    47,    47,    48,    48,    48,    48,    49,    48,
      48,    48,    50,    48,    48,    48,    48,    51,    51,    52,
      53,    53,    54,    55,    57,    56,    58,    59,    58
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     3,     3,     2,     0,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     1,     1,     3,     3,     3,     0,
       0,     0,     1,     1,     7,     9,     9,     9,     0,     6,
       5,     9,     0,    12,    11,    18,    18,     3,     1,     1,
       3,     1,     1,     0,     0,     3,     1,     0,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
      29,     0,    30,     1,     0,     7,    54,    30,     0,    31,
       9,    15,    14,     6,     0,     0,     2,    10,    11,     4,
      32,    33,     0,    55,     3,    18,    18,    18,    18,    18,
      38,    18,     8,    19,     0,     0,     0,     0,     0,    18,
       0,    13,    12,    16,    16,    16,    16,    16,    20,     0,
      16,    17,     0,     0,     0,     0,     0,    21,    53,    49,
      20,    48,     0,    28,    25,    16,    16,    16,    20,    16,
      57,    56,    40,     0,    53,    16,     0,     0,    22,    53,
      22,     0,    47,    39,    22,    16,    26,    24,    20,    23,
      34,    20,    53,    20,    42,    53,    53,    53,    58,    53,
       0,    20,     0,    41,     0,    36,     0,    35,    37,     0,
      53,    52,    20,    51,     0,     0,    27,    44,     0,    53,
      18,    18,    50,    43,     0,     0,    16,    16,     0,     0,
      16,    16,    22,    22,    20,    20,    46,    45
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     1,     7,     8,    19,    43,    13,    52,    34,    58,
      88,    89,   111,    67,   101,    59,     2,     9,    22,    32,
      39,   102,    60,    61,   112,   113,    71,    10,    14,    72,
      81
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -70
static const short yypact[] =
{
     -70,    21,    13,   -70,    60,   -70,   -70,   116,    17,    66,
     -70,   -70,   -70,   -70,    45,    17,   -70,   -70,   -70,   -70,
     -70,   -70,   131,   -70,   -70,    31,    31,    31,    31,    31,
     -70,    31,   -70,   -70,    83,    83,    83,    83,    83,    31,
      83,   -70,   -70,    35,    35,    35,    35,    35,    37,    83,
      35,   -70,    83,    83,    83,    83,    83,   -70,    29,   -70,
      62,   -70,    83,   -70,   -70,    35,    35,    35,    37,    35,
     -70,   -70,   -70,    83,    29,    35,    83,    83,    83,    29,
      83,    57,   -70,   -70,    83,     6,   -70,   -70,    37,   -70,
     -70,    37,   -70,    37,    59,    29,     1,    23,   -70,    29,
      51,    37,    83,   -70,    49,   -70,    56,   -70,   -70,    95,
      29,   -70,    62,   -70,    99,    92,   -70,   -70,    83,    29,
      31,    31,   -70,   -70,    83,    83,    35,    35,    83,    83,
      35,    35,    83,    83,    37,    37,   -70,   -70
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -70,   -70,   -70,   100,    97,    -9,   -70,   -27,   -26,    20,
     -69,   -70,   -39,    -2,   -70,   -28,   -70,   -70,   -70,   -70,
     -70,   -70,   -70,    41,   -70,    -8,    -3,   -70,   -70,   -18,
     -70
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -54
static const short yytable[] =
{
      35,    36,    37,    38,    16,    40,    44,    45,    46,    47,
      48,    91,    50,    49,    65,    93,    68,    53,    54,    55,
      56,     3,     4,    62,   -20,   -20,    51,   104,    57,    70,
       5,    -5,    -5,    73,   -20,    17,    18,    85,    76,    77,
      78,     6,    80,    63,    64,    66,    64,    66,    84,   106,
      23,    70,    33,    66,    69,    51,    83,    70,    94,    57,
      75,    90,    92,   134,   135,   -16,   -16,    64,    86,    87,
     100,    87,    11,    12,   109,    87,   114,   103,   105,   107,
      74,   108,    51,   115,    57,   118,    41,    42,    79,    98,
      20,    21,   117,    64,   124,   125,   126,   127,   116,   128,
     129,   123,   121,   132,   133,    95,   120,    15,    96,    64,
     122,    97,    24,    99,    82,     0,   -53,     0,     0,    66,
      66,   110,     0,    87,    87,     4,   130,   131,     0,     0,
       0,     0,   119,     5,    -5,    -5,     0,    25,    26,    27,
       0,    28,     0,     0,     6,    29,    30,    31,     0,     0,
       0,     0,     0,     0,   136,   137
};

static const short yycheck[] =
{
      26,    27,    28,    29,     7,    31,    34,    35,    36,    37,
      38,    80,    40,    39,    53,    84,    55,    44,    45,    46,
      47,     0,     9,    50,    18,    19,    20,    26,    22,    28,
      17,    18,    19,    60,    28,    18,    19,    76,    65,    66,
      67,    28,    69,    52,    53,    54,    55,    56,    75,    26,
       5,    28,    21,    62,    56,    20,    74,    28,    85,    22,
      62,    79,     5,   132,   133,     3,     4,    76,    77,    78,
      11,    80,    12,    13,    23,    84,    27,    95,    96,    97,
      60,    99,    20,    27,    22,   112,     3,     4,    68,    92,
      24,    25,   110,   102,   120,   121,   124,   125,     3,   126,
     127,   119,    10,   130,   131,    85,     7,     7,    88,   118,
     118,    91,    15,    93,    73,    -1,     0,    -1,    -1,   128,
     129,   101,    -1,   132,   133,     9,   128,   129,    -1,    -1,
      -1,    -1,   112,    17,    18,    19,    -1,     6,     7,     8,
      -1,    10,    -1,    -1,    28,    14,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,   134,   135
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    30,    45,     0,     9,    17,    28,    31,    32,    46,
      56,    12,    13,    35,    57,    32,    55,    18,    19,    33,
      24,    25,    47,     5,    33,     6,     7,     8,    10,    14,
      15,    16,    48,    21,    37,    37,    37,    37,    37,    49,
      37,     3,     4,    34,    44,    44,    44,    44,    44,    37,
      44,    20,    36,    36,    36,    36,    36,    22,    38,    44,
      51,    52,    36,    34,    34,    41,    34,    42,    41,    42,
      28,    55,    58,    36,    38,    42,    36,    36,    36,    38,
      36,    59,    52,    58,    36,    41,    34,    34,    39,    40,
      58,    39,     5,    39,    36,    38,    38,    38,    55,    38,
      11,    43,    50,    58,    26,    58,    26,    58,    58,    23,
      38,    41,    53,    54,    27,    27,     3,    58,    36,    38,
       7,    10,    54,    58,    37,    37,    44,    44,    36,    36,
      42,    42,    36,    36,    39,    39,    38,    38
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
#line 99 "saoparser.Y"
    {cerr << "SAOimage" << endl;;}
    break;

  case 12:
#line 108 "saoparser.Y"
    {yyval.real=yyvsp[0].real;;}
    break;

  case 13:
#line 109 "saoparser.Y"
    {yyval.real=yyvsp[0].integer;;}
    break;

  case 14:
#line 112 "saoparser.Y"
    {yydebug=1;;}
    break;

  case 15:
#line 113 "saoparser.Y"
    {yydebug=0;;}
    break;

  case 22:
#line 128 "saoparser.Y"
    {yyval.real = 0;;}
    break;

  case 23:
#line 129 "saoparser.Y"
    {yyval.real = yyvsp[0].real;;}
    break;

  case 24:
#line 132 "saoparser.Y"
    {yyval.real = degToRad(yyvsp[0].real);;}
    break;

  case 25:
#line 135 "saoparser.Y"
    {yyval.real = FITSPTR->mapLenToRef(yyvsp[0].real, IMAGE);;}
    break;

  case 26:
#line 139 "saoparser.Y"
    {
	  Vector r = FITSPTR->mapLenToRef(Vector(yyvsp[-2].real,yyvsp[0].real), IMAGE);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 27:
#line 147 "saoparser.Y"
    {yyval.integer = yyvsp[0].integer;;}
    break;

  case 28:
#line 151 "saoparser.Y"
    {
	  Vector r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real), IMAGE);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 29:
#line 159 "saoparser.Y"
    {
	  globalProps =
	    Marker::SELECT | Marker::EDIT | Marker::MOVE |
	    Marker::ROTATE | Marker::DELETE | Marker::HIGHLITE |
	    Marker::INCLUDE | Marker::SOURCE;
	;}
    break;

  case 30:
#line 167 "saoparser.Y"
    {localProps = globalProps;;}
    break;

  case 31:
#line 170 "saoparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 32:
#line 171 "saoparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 33:
#line 172 "saoparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 0);;}
    break;

  case 34:
#line 176 "saoparser.Y"
    {FR->createCircleCmd(Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    color,1,font,text,localProps,localComment,taglist);;}
    break;

  case 35:
#line 180 "saoparser.Y"
    {
	  // for ellipse annulus
	  aStatus = 1;
	  aCenter = Vector(yyvsp[-6].vector);
	  aAngle = yyvsp[-2].real;
	  aVector[0] = Vector(yyvsp[-4].vector);
	  aNum = 1;
	  strncpy(aComment,localComment,80);
	  aProps = localProps;

	  FR->createEllipseCmd(Vector(yyvsp[-6].vector),Vector(yyvsp[-4].vector),yyvsp[-2].real,
	  color,1,font,text,localProps,localComment,taglist);
	;}
    break;

  case 36:
#line 195 "saoparser.Y"
    {
	  // for box annulus
	  aStatus = 3;
	  aCenter = Vector(yyvsp[-6].vector);
	  aAngle = yyvsp[-2].real;
	  aVector[0] = Vector(yyvsp[-4].vector);
	  aNum = 1;
	  strncpy(aComment,localComment,80);
	  aProps = localProps;

	  FR->createBoxCmd(Vector(yyvsp[-6].vector),Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    color,1,font,text,localProps,localComment,taglist);
	;}
    break;

  case 37:
#line 209 "saoparser.Y"
    {FR->createBoxCmd(Vector(yyvsp[-6].vector),Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    color,1,font,text,localProps,localComment,taglist);;}
    break;

  case 38:
#line 212 "saoparser.Y"
    {polylist.deleteAll();;}
    break;

  case 39:
#line 213 "saoparser.Y"
    {FR->createPolygonCmd(polylist,color,1,font,
	      text,localProps,localComment,taglist);;}
    break;

  case 40:
#line 217 "saoparser.Y"
    {FR->createBoxCirclePointCmd(Vector(yyvsp[-2].vector),
	    color,1,font,text,localProps,localComment,taglist);;}
    break;

  case 41:
#line 221 "saoparser.Y"
    {FR->createAnnulusCmd(Vector(yyvsp[-6].vector),yyvsp[-4].real,yyvsp[-2].real,1,
	    color,1,font,text,localProps,localComment,taglist);;}
    break;

  case 42:
#line 223 "saoparser.Y"
    {aNum=2;;}
    break;

  case 43:
#line 225 "saoparser.Y"
    {
	  aAnnuli[0] = yyvsp[-7].real;
	  aAnnuli[1] = yyvsp[-5].real;
	  FR->createAnnulusCmd(Vector(yyvsp[-9].vector),aAnnuli,aNum,
	  color,1,font,text,localProps,localComment,taglist);
	;}
    break;

  case 44:
#line 232 "saoparser.Y"
    {FR->createAnnulusCmd(Vector(yyvsp[-8].vector),yyvsp[-6].real,yyvsp[-4].real,yyvsp[-2].integer,
	    color,1,font,text,localProps,localComment,taglist);;}
    break;

  case 45:
#line 237 "saoparser.Y"
    {	
	  aStatus = 2;
	  aVector[aNum++] = Vector(yyvsp[-13].vector);
	;}
    break;

  case 46:
#line 244 "saoparser.Y"
    {	
	  aStatus = 4;
	  aVector[aNum++] = Vector(yyvsp[-13].vector);
	;}
    break;

  case 49:
#line 254 "saoparser.Y"
    {polylist.append(new Vertex(yyvsp[0].vector));;}
    break;

  case 52:
#line 261 "saoparser.Y"
    {aAnnuli[aNum++] = yyvsp[0].real;;}
    break;

  case 53:
#line 265 "saoparser.Y"
    {
	  switch (aStatus) {
	  case 0: // do nothing
	    break;
	  case 1: // we found just an ellipse, do nothing
	    break;
	  case 2: // ok we have an ellipse annulus
	    FR->markerDeleteLastCmd(); // delete the previous ellipse
	    FR->createEllipseAnnulusCmd(aCenter,aAngle,aNum,aVector,
	      color,1,font,text,aProps,aComment,taglist);
	    break;
	  case 3: // we found just a box, do nothing
	    break;
	  case 4: // ok, we have a box annulus
	    FR->markerDeleteLastCmd(); // delete the previous box
	    FR->createBoxAnnulusCmd(aCenter,aAngle,aNum,aVector,
	      color,1,font,text,aProps,aComment,taglist);
	    break;
	  }
	  aStatus = 0;
	;}
    break;

  case 54:
#line 288 "saoparser.Y"
    {DISCARD_(1);}
    break;

  case 57:
#line 292 "saoparser.Y"
    {DISCARD_(0);}
    break;

  case 58:
#line 293 "saoparser.Y"
    {strncpy(localComment,yyvsp[-1].str,80);;}
    break;


    }

/* Line 999 of yacc.c.  */
#line 1432 "saoparser.C"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 296 "saoparser.Y"


static void setProps(unsigned short* props, unsigned short prop, int value)
{
  if (value)
    *props |= prop;
  else
    *props &= ~prop;
}

