#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CircleDialog {frame id} {
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuCircleDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordCircleCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyCircleDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseCircleDialog $frame $id"

    # other circle menu items

    set marker($frame,$id,rcoord) $marker(dialog,dist,system)
    set marker($frame,$id,rlabel) $marker(dialog,dist,system)
    set marker($frame,$id,rformat) $marker(dialog,dist,format)

    DistMenuMarkerDialog $frame $mb $id DistCircleCB radius rcoord rformat
    $mb add cascade -label Radius -menu $mb.radius
    DistCircleCB $frame $id

    # Init circle variables

    EditCircleCB $frame $id

    # circle specific callbacks

    $frame marker $id callback edit EditCircleCB $frame
    $frame marker $id callback delete DeleteCircleDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "CloseCircleDialog $frame $id"

    # Radius

    label $w.ref.f.radiusTitle -text "Radius"
    entry $w.ref.f.radius -textvariable marker($frame,$id,radius) -width 13 
    label $w.ref.f.radiusformat -textvariable marker($frame,$id,rlabel) \
	-relief groove -width 9 -padx 4

    grid $w.ref.f.radiusTitle $w.ref.f.radius x $w.ref.f.radiusformat \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyCircleDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseCircleDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyCircleDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuCircleDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
    $mb.properties add checkbutton -label "Fixed in Size" \
	-variable marker($frame,$id,fixed) \
	-command "PropertyMarkerDialog $frame $id fixed"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "PropertyMarkerDialog $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "PropertyMarkerDialog $frame $id source"
}

proc ApplyCircleDialog {frame id} {
    EditCircleDialog $frame $id
    ApplyMarkerDialog $frame $id
}

proc CloseCircleDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditCircleCB
    $frame marker $id delete callback delete DeleteCircleDialog
    DeleteMarkerCBs $frame $id

    DeleteCircleDialog $frame $id
}

proc DeleteCircleDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,rcoord)
    unset marker($frame,$id,rformat)
    unset marker($frame,$id,rlabel)
}

proc EditCircleDialog {frame id} {
    global marker

    $frame marker $id circle radius $marker($frame,$id,radius) \
	$marker($frame,$id,rcoord) $marker($frame,$id,rformat)
}

proc EditCircleCB {frame id} {
    global marker

    set marker($frame,$id,radius) \
	[$frame get marker $id circle radius \
	     $marker($frame,$id,rcoord) $marker($frame,$id,rformat)]
}

proc CoordCircleCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
    EditCircleCB $frame $id
}

proc DistCircleCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,rcoord)

    set marker($frame,$id,rlabel) $marker($frame,$id,rcoord)
    switch -- $marker($frame,$id,rcoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,rcoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,rcoord)] {
		    set marker($frame,$id,rlabel) $marker($frame,$id,rformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,rcoord)]
		    if {$name != ""} {
			set marker($frame,$id,rlabel) $name
		    }
		}
	    }
	}
    }

    MoveMarkerCB $frame $id
    EditCircleCB $frame $id
}

proc CircleDefaultDialog {} {
    global marker
    global ed

    set w ".circle"

    set ed(ok) 0
    set ed(radius) $marker(circle,radius)

    DialogCreate $w "Default Circle" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "Radius"
    entry $w.ed.radius -textvariable ed(radius) -width 10
    label $w.ed.unit -text "image" -relief groove -width 8
    
    grid $w.ed.title $w.ed.radius $w.ed.unit -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius select range 0 end
    DialogWait $w ed(ok) $w.ed.radius
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(circle,radius) $ed(radius)
    }

    unset ed
}
