#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

   - Selection of default file names based on mime-types.
   - Filename truncation (should be truncated from the right)
   - Simple application of the drop, save, mangle, defang and accept
     policies.  The exclamation-policies are also tested.
   - Cleanup of standards-violating mime type definitions.

tac

rm -f ./.tmp.*
$ANOMY/bin/sanitizer.pl $SAN_CONF \
    'feat_testing = 1' 'file_name_tpl = /tmp/att-$$$-$F' 'header_rev = 0' \
    <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: =?ISO-8859-1?Q?this_is_a_very_very_very_very_very_very_very_very_very_very_very_very_this_is_a_very_very_very_very_very_very_very_very_very_very_very_very_this_is_a_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_very_long_subject_which_looks_a_bit_like_a_file_name.txt_with_more_than_one_extension.exe?=
To: fake@example.com
Content-Type: multipart/mixed;

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/ms-tnef; charset="evil"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

this is a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: application/x-snort-snort garbage; charset="iso-8859-1"
Content-Disposition: attachment
Content-Transfer-Encoding: 8bit

this is an unnamed file, which should be left alone

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment;
  filename="aaaaaaaaa0aaaaaaaaa1aaaaaaaaa2aaaaaaaaa3aaaaaaaaa4aaaaaaaaa5aaaaaaaaa6aaaaaaaaa7aaaaaaaa5aaaaaaaaa6aaaaaaaaa7aaaaaaaa5aaaaaaaaa6aaaaaaaaa7.vbs.txt"
Content-Transfer-Encoding: 8bit

this is also a very evil file.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="wtc.exe"
Content-Transfer-Encoding: 8bit

Blacklisted by policy 1.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="one.jpeg.exe"
Content-Transfer-Encoding: 8bit

Blacklisted by policy 1.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="seven.scr"
Content-Transfer-Encoding: 8bit

Blacklisted by policy 7.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/something quite invalid
Content-Disposition: attachment; filename="nine.txt"
Content-Transfer-Encoding: 8bit

Whitelisted by policy 9.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="eleven.zip"
Content-Transfer-Encoding: 8bit

Whitelisted by policy 11.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="thirteen.ppt"
Content-Transfer-Encoding: 8bit

Whitelisted by policy 13.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="fifteen.3ds"
Content-Transfer-Encoding: 8bit

Whitelisted by policy 15.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: audio/x-wav; charset="iso-8859-1"
Content-Disposition: attachment; filename="mismatch.3ds"
Content-Transfer-Encoding: 8bit

MIME-type/filename mismatch, blocked by generic rule.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: audio/x-wav; charset="iso-8859-1"
Content-Disposition: attachment; filename*="iso-8859-1''wtc%2eexe"
Content-Transfer-Encoding: 8bit

RFC2231 i18n-encoded blacklisted attachment name.

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF

echo "*** Exit code was $? ***" >>test.out

rm ./.tmp.*  >>test.out 2>&1
exit 0
