#!/bin/sh
#    Copyright (c) 2005-2007 Romain BONDUE
#    This file is part of RutilT.
#
#    RutilT is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    RutilT is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with RutilT; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#
# Variables :
prefix=/usr/local
launcher=
helper_mode=4755
makefile_target='$(RUTILT_NAME) $(HELPER_NAME)'
kernel_sources_path='/lib/modules/'`uname -r`'/build/include/'
cflags_base='-pipe -Wall'
cflags=
# Generated variables :
rutilt_name=rutilt
rutilt_prefix=bin/
helper_name=rutilt_helper
helper_prefix=bin/
ip_script_name=set_ip.sh
data_prefix=share/apps/rutilt/
ip_script_prefix=$data_prefix
helper_launcher_name=helper_launcher.sh
helper_launcher_prefix=$data_prefix
user_config_name=rutilt/
user_config_prefix=/.config/
# There's a distinction between menu icons and the other arts.
tray_icon_disconnected_name=disconnected_tray.png
tray_icon_low_name=low_tray.png
tray_icon_medium_name=medium_tray.png
tray_icon_high_name=high_tray.png
icons_prefix=share/icons/hicolor
icons_suffix=apps
icon_final_name=rutilt.png
icon_16x16_name=RutilT16x16.png
icon_32x32_name=RutilT32x32.png
icon_48x48_name=RutilT48x48.png
icon_64x64_name=RutilT64x64.png
icon_128x128_name=RutilT128x128.png
icon_16x16_prefix=$icons_prefix/16x16/$icons_suffix/
icon_32x32_prefix=$icons_prefix/32x32/$icons_suffix/
icon_48x48_prefix=$icons_prefix/48x48/$icons_suffix/
icon_64x64_prefix=$icons_prefix/64x64/$icons_suffix/
icon_128x128_prefix=$icons_prefix/128x128/$icons_suffix/
options_name=RutilT_options.xml
desktop_launcher_name=rutilt.desktop
desktop_launcher_prefix=share/applications/
man_name=rutilt.1
man_helper_name=rutilt_helper.1
man_prefix=share/man/man1
version=v0.16
#
#
# Parse options :
for arg_iter in $@; do
    arg=`echo $arg_iter | cut -f1 -d=`
    arg_value=`echo $arg_iter | cut -f2 -d=`
    case $arg in
        --help)
echo "This script generates RutilT's configuration and build files. It also
checks if all dependencies are fulfilled.
Used without arguments, default settings are applied. Arguments are :
    --help : Display this message and exit.
    --force : If the kernel sources are not found, use the installed headers
              even if they do not match the running kernel.
    --prefix=PATH : Set PATH as file-system root for installation.
    --kernel_sources=PATH : Use the kernel sources located into PATH.
    --debug : Compile the program with debugging output enabled, and turn off
              optimizations (unless --cflags is used).
    --cflags=PARAMETERS : Pass PARAMETERS to the compiler.
    --version=LABEL : Use LABEL as version label.
    --launcher=built-in | disabled | nopasswd | external : Set how the helper is
    launched as root and therefore how users' identity is checked :
        built-in : The default setting, use the built-in launcher, it implies
                   that the helper will be installed setuid.
        disabled : No helper, RutilT will have to be launched as root to
                   change wireless settings.
        nopasswd : Like \"built-in\", but will not ask for the root password.
        external : A script will be run when root privileges are needed. This
                   script must launch the helper as root, by default, gksu or
                   kdesu are used (helper not installed setuid)."
            exit 0;;

        --prefix)
            prefix=$arg_value;;

        --launcher)
            case $arg_value in
                built-in)
                    echo "Using built-in launcher.";;
                disabled)
                    launcher="#define NHELPER"
                    makefile_target='$(RUTILT_NAME)'
                    echo "No launcher : helper disabled.";;
                nopasswd)
                    launcher="#define NOROOTPASSCHECK"
                    echo "Password check disabled when launching the helper.";;
                external)
                    launcher="#define EXTERNALLAUNCHER
#define NOROOTPASSCHECK"
                    helper_mode=755
                    echo "Using $helper_launcher_name as launcher proxy, you may need or want to tune this script.";;
                *) 
                    echo "Invalid value for --launcher, expected \"built-in\", \"disabled\", \"nopasswd\", or \"external\"."
                    exit 1;;
            esac;;

        --kernel_sources)
            kernel_sources_path=$arg_value'/include/'
            if [ -e $kernel_sources_path ]; then
                echo "Kernel sources path set to : $arg_value"
            else
                echo "No kernel sources found in : $arg_value"
                exit 1
            fi;;

         --force)
            force=1;;

         --debug)
            echo 'Enabling debugging output, turning optimizations off.'
            if [ -z "$cflags" ]; then
                cflags="$cflags_base -g"
            fi
            if [ -e ./Makefile_cst ]; then
                make clean_rutilt_secure_target_name
            fi;;

          --cflags)
            echo "Using : \"$arg_value\" as compilation options."
            cflags="$arg_value ";;

          --version)
            echo "Labelling RutilT : \"$arg_value\""
            version=$arg_value;;

        *)
            echo "Invalid argument : $arg
Use \"./configure.sh --help\" for help."
            exit 1;;
    esac
done
if [ -z "$cflags" ]; then
    cflags="$cflags_base -s -O3 -DNDEBUG"
fi
#
#
# Dependencies check :
# Gtk+ :
if ! pkg-config  --print-errors --exists 'gtk+-2.0 >= 2.6.0'; then
    echo 'Please install (or upgrade to) GTK+ 2.6.0, at least.'
    exit 1
fi
# Kernel sources :
if [ -e $kernel_sources_path/linux/wireless.h ]; then
    if [ `grep "#define WIRELESS_EXT" $kernel_sources_path/linux/wireless.h | tr -s '\t' ' ' | cut -d' ' -f3` -lt 16 ]; then
        echo 'According to its sources, this kernel does not have recent enough wireless extensions.'
        exit 1
    fi
else
    echo 'Kernel sources cannot be found.'
# Fallback on headers :
    if [ -e /usr/include/linux/wireless.h ] && [ -e /usr/include/linux/version.h ]; then
        if [ `grep "#define WIRELESS_EXT" /usr/include/linux/wireless.h | tr -s '\t' ' ' | cut -d' ' -f3` -lt 16 ]; then
            echo 'According to your kernel headers, the wireless extensions used in that kernel are too old.'
            exit 1
        else
            echo -n 'Kernel headers found. '
            if [ `grep "#define UTS_RELEASE" /usr/include/linux/version.h | tr -s '\t' ' ' | cut -d' ' -f3 | tr -d '"'` != `uname -r` ]; then
                echo -n 'They do not match your running kernel. '
                if [ $force ]; then
                    echo -n '<Check forced>'
                else
                    echo
                    exit 1
                fi
            fi
            echo
        fi
    else
        echo 'Your kernel headers cannot be found.'
        exit 1
    fi
fi
#
#
# Makefile_cst :
echo -n "Generating Makefile constants... "
echo "# WARNING : Auto-generated file, edit with care.
CFLAGS := $cflags
PREFIX := $prefix
KERNEL_SOURCES_PATH := $kernel_sources_path
RUTILT_NAME := $rutilt_name
RUTILT_PREFIX = \$(PREFIX)/$rutilt_prefix
HELPER_NAME := $helper_name
HELPER_PREFIX = \$(PREFIX)/$helper_prefix
HELPER_MODE := $helper_mode
HELPER_LAUNCHER_PREFIX = \$(PREFIX)/$helper_launcher_prefix
HELPER_LAUNCHER_NAME := $helper_launcher_name
IP_SCRIPT_NAME := $ip_script_name
IP_SCRIPT_PREFIX = \$(PREFIX)/$ip_script_prefix
USER_CONFIG_NAME := $user_config_name
USER_CONFIG_PREFIX := $user_config_prefix
DATA_PREFIX = \$(PREFIX)/$data_prefix
TRAY_ICON_DISCONNECTED_NAME := $tray_icon_disconnected_name
TRAY_ICON_LOW_NAME := $tray_icon_low_name
TRAY_ICON_MEDIUM_NAME := $tray_icon_medium_name
TRAY_ICON_HIGH_NAME := $tray_icon_high_name
ICON_16X16_NAME := $icon_16x16_name
ICON_32X32_NAME := $icon_32x32_name
ICON_48X48_NAME := $icon_48x48_name
ICON_64X64_NAME := $icon_64x64_name
ICON_128X128_NAME := $icon_128x128_name
ICON_FINAL_NAME := $icon_final_name
ICON_16X16_PREFIX = \$(PREFIX)/$icon_16x16_prefix
ICON_32X32_PREFIX = \$(PREFIX)/$icon_32x32_prefix
ICON_48X48_PREFIX = \$(PREFIX)/$icon_48x48_prefix
ICON_64X64_PREFIX = \$(PREFIX)/$icon_64x64_prefix
ICON_128X128_PREFIX = \$(PREFIX)/$icon_128x128_prefix
DESKTOP_LAUNCHER := $desktop_launcher_name
DESKTOP_LAUNCHER_PREFIX = \$(PREFIX)/$desktop_launcher_prefix
RUTILT_MAN := $man_name
HELPER_MAN := $man_helper_name
MAN_PREFIX = \$(PREFIX)/$man_prefix
BUILD := $makefile_target" > Makefile_cst
echo done
#
#
# include/StaticSettings.h
echo -n "Generating program constants... "
echo "/** \file StaticSettings.h
    \author Romain BONDUE
    \date 23/06/2006
    \warning Auto-generated file, edit with care. */
#ifndef __STATICSETTINGS_H__
#define __STATICSETTINGS_H__

#include <string>



namespace nsCore
{
$launcher
    const std::string UserConfigPrefix (\"$user_config_prefix\");
    const std::string UserConfigName (\"$user_config_name\");
    const std::string HelperPrefix (\"$prefix/$helper_prefix\");
    const std::string HelperName (\"$helper_name\");
    const std::string HelperLauncherPath (\"$prefix/$helper_launcher_prefix$helper_launcher_name\");
    const std::string DhcpScriptPrefix (\"$prefix/$ip_script_prefix\");
    const std::string DhcpScriptName (\"$ip_script_name\");
    const std::string TrayIconDisconnectedPath (\"$prefix/$data_prefix$tray_icon_disconnected_name\");
    const std::string TrayIconLowPath (\"$prefix/$data_prefix$tray_icon_low_name\");
    const std::string TrayIconMediumPath (\"$prefix/$data_prefix$tray_icon_medium_name\");
    const std::string TrayIconHighPath (\"$prefix/$data_prefix$tray_icon_high_name\");
    const std::string OptionsFileName (\"$options_name\");
    const std::string Icon16Path (\"$prefix/$icon_16x16_prefix$icon_final_name\");
    const std::string Icon32Path (\"$prefix/$icon_32x32_prefix$icon_final_name\");
    const std::string Icon48Path (\"$prefix/$icon_48x48_prefix$icon_final_name\");
    const std::string Icon64Path (\"$prefix/$icon_64x64_prefix$icon_final_name\");
    const std::string Icon128Path (\"$prefix/$icon_128x128_prefix$icon_final_name\");
    const std::string VersionLabel (\"$version\");

} // namespace nsCore

#endif // __STATICSETTINGS_H__" > include/StaticSettings.h
echo done
#
#
# Icon=$prefix/$icon_prefix$icon_48x48_name
# rutilt.desktop
echo -n "Generating desktop launcher... "
echo "[Desktop Entry]
Name=RutilT WLAN Manager
Name[fr]=Utilitaire de Configuration Wifi RutilT
Name[it]=Strumento di Configurazione WiFi RutilT
GenericName=WLAN Manager
GenericName[fr]=Utilitaire de Configuration Wifi
GenericName[it]=Strumento di Configurazione WiFi
Comment=Manage your wireless network interfaces
Comment[fr]=Configurer vos cartes Wifi
Comment[it]=Configura le tue schede WiFi
Terminal=false
Type=Application
Categories=GTK;System;Settings;Network;
Version=1.0
StartupNotify=false
Icon=$icon_final_name
Exec=$rutilt_name" > $desktop_launcher_name
echo done
#
#
# helper_launcher.sh
if [ $helper_mode -eq 755 ]; then
    echo -n "Generating $helper_launcher_name... "
    echo "#!/bin/sh
#    Copyright (c) 2005-2007 Romain BONDUE
#    This file is part of RutilT.
#
#    RutilT is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    RutilT is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with RutilT; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#
# This script is called by RutilT with 1 argument that MUST be forward to the
# helper, it is the user running the utility UID. This value can be useful
# within this script too to apply different policy for each user. 
# This script is not executed with root privileges.
#
if which gksu > /dev/null; then
    exec gksu \"$prefix/$helper_prefix$helper_name \$1\"
elif which kdesu > /dev/null; then
    exec kdesu \"$prefix/$helper_prefix$helper_name \$1\"
else
    echo "$helper_launcher_name : Cannot find a launcher."
fi" > $helper_launcher_name
    echo done
fi
