// This file is autogenerated. Do not edit it!
// See ./codegen for details.

use std::fmt;

/// List of all SVG elements.
#[derive(Copy,Clone,Eq,PartialEq,Ord,PartialOrd,Hash)]
#[allow(missing_docs)]
pub enum ElementId {
    A,
    AltGlyph,
    AltGlyphDef,
    AltGlyphItem,
    Animate,
    AnimateColor,
    AnimateMotion,
    AnimateTransform,
    Circle,
    ClipPath,
    ColorProfile,
    Cursor,
    Defs,
    Desc,
    Ellipse,
    FeBlend,
    FeColorMatrix,
    FeComponentTransfer,
    FeComposite,
    FeConvolveMatrix,
    FeDiffuseLighting,
    FeDisplacementMap,
    FeDistantLight,
    FeFlood,
    FeFuncA,
    FeFuncB,
    FeFuncG,
    FeFuncR,
    FeGaussianBlur,
    FeImage,
    FeMerge,
    FeMergeNode,
    FeMorphology,
    FeOffset,
    FePointLight,
    FeSpecularLighting,
    FeSpotLight,
    FeTile,
    FeTurbulence,
    Filter,
    Font,
    FontFace,
    FontFaceFormat,
    FontFaceName,
    FontFaceSrc,
    FontFaceUri,
    ForeignObject,
    G,
    Glyph,
    GlyphRef,
    Hkern,
    Image,
    Line,
    LinearGradient,
    Marker,
    Mask,
    Metadata,
    MissingGlyph,
    Mpath,
    Path,
    Pattern,
    Polygon,
    Polyline,
    RadialGradient,
    Rect,
    Script,
    Set,
    Stop,
    Style,
    Svg,
    Switch,
    Symbol,
    Text,
    TextPath,
    Title,
    Tref,
    Tspan,
    Use,
    View,
    Vkern
}

static ELEMENTS: Map<ElementId> = Map {
    key: 732231254413039614,
    disps: &[
        (5, 43),
        (0, 2),
        (0, 41),
        (0, 0),
        (0, 16),
        (11, 5),
        (0, 12),
        (4, 18),
        (22, 32),
        (5, 9),
        (2, 56),
        (6, 13),
        (2, 24),
        (0, 21),
        (9, 52),
        (0, 3),
    ],
    entries: &[
        ("font-face-uri", ElementId::FontFaceUri),
        ("feFuncR", ElementId::FeFuncR),
        ("text", ElementId::Text),
        ("title", ElementId::Title),
        ("feBlend", ElementId::FeBlend),
        ("missing-glyph", ElementId::MissingGlyph),
        ("animateColor", ElementId::AnimateColor),
        ("marker", ElementId::Marker),
        ("feMergeNode", ElementId::FeMergeNode),
        ("filter", ElementId::Filter),
        ("feOffset", ElementId::FeOffset),
        ("feSpecularLighting", ElementId::FeSpecularLighting),
        ("stop", ElementId::Stop),
        ("clipPath", ElementId::ClipPath),
        ("line", ElementId::Line),
        ("ellipse", ElementId::Ellipse),
        ("radialGradient", ElementId::RadialGradient),
        ("feConvolveMatrix", ElementId::FeConvolveMatrix),
        ("feMerge", ElementId::FeMerge),
        ("feDiffuseLighting", ElementId::FeDiffuseLighting),
        ("feFuncG", ElementId::FeFuncG),
        ("feMorphology", ElementId::FeMorphology),
        ("color-profile", ElementId::ColorProfile),
        ("use", ElementId::Use),
        ("animate", ElementId::Animate),
        ("polyline", ElementId::Polyline),
        ("hkern", ElementId::Hkern),
        ("svg", ElementId::Svg),
        ("feComposite", ElementId::FeComposite),
        ("rect", ElementId::Rect),
        ("font-face", ElementId::FontFace),
        ("a", ElementId::A),
        ("path", ElementId::Path),
        ("linearGradient", ElementId::LinearGradient),
        ("feComponentTransfer", ElementId::FeComponentTransfer),
        ("feTile", ElementId::FeTile),
        ("altGlyphDef", ElementId::AltGlyphDef),
        ("feFuncA", ElementId::FeFuncA),
        ("symbol", ElementId::Symbol),
        ("glyphRef", ElementId::GlyphRef),
        ("glyph", ElementId::Glyph),
        ("style", ElementId::Style),
        ("switch", ElementId::Switch),
        ("set", ElementId::Set),
        ("font-face-name", ElementId::FontFaceName),
        ("font-face-src", ElementId::FontFaceSrc),
        ("font-face-format", ElementId::FontFaceFormat),
        ("feFlood", ElementId::FeFlood),
        ("tref", ElementId::Tref),
        ("feFuncB", ElementId::FeFuncB),
        ("mpath", ElementId::Mpath),
        ("animateMotion", ElementId::AnimateMotion),
        ("defs", ElementId::Defs),
        ("feGaussianBlur", ElementId::FeGaussianBlur),
        ("view", ElementId::View),
        ("foreignObject", ElementId::ForeignObject),
        ("tspan", ElementId::Tspan),
        ("altGlyph", ElementId::AltGlyph),
        ("cursor", ElementId::Cursor),
        ("feDisplacementMap", ElementId::FeDisplacementMap),
        ("pattern", ElementId::Pattern),
        ("mask", ElementId::Mask),
        ("font", ElementId::Font),
        ("desc", ElementId::Desc),
        ("feImage", ElementId::FeImage),
        ("feColorMatrix", ElementId::FeColorMatrix),
        ("feTurbulence", ElementId::FeTurbulence),
        ("feDistantLight", ElementId::FeDistantLight),
        ("g", ElementId::G),
        ("fePointLight", ElementId::FePointLight),
        ("feSpotLight", ElementId::FeSpotLight),
        ("script", ElementId::Script),
        ("image", ElementId::Image),
        ("metadata", ElementId::Metadata),
        ("vkern", ElementId::Vkern),
        ("textPath", ElementId::TextPath),
        ("polygon", ElementId::Polygon),
        ("circle", ElementId::Circle),
        ("altGlyphItem", ElementId::AltGlyphItem),
        ("animateTransform", ElementId::AnimateTransform),
    ],
};

impl ElementId {
    /// Parses `ElementId` from a string.
    pub fn from_str(text: &str) -> Option<ElementId> {
        ELEMENTS.get(text).cloned()
    }

    /// Returns an original string.
    pub fn as_str(&self) -> &'static str {
        ELEMENTS.key(self)
    }
}

impl fmt::Debug for ElementId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}

impl fmt::Display for ElementId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}

/// List of all SVG attributes.
#[derive(Copy,Clone,Eq,PartialEq,Ord,PartialOrd,Hash)]
#[allow(missing_docs)]
pub enum AttributeId {
    AccentHeight,
    Accumulate,
    Actuate,
    Additive,
    AlignmentBaseline,
    Alphabetic,
    Amplitude,
    ArabicForm,
    Arcrole,
    Ascent,
    AttributeName,
    AttributeType,
    Azimuth,
    Base,
    BaseFrequency,
    BaselineShift,
    BaseProfile,
    Bbox,
    Begin,
    Bias,
    By,
    CalcMode,
    CapHeight,
    Class,
    Clip,
    ClipPath,
    ClipRule,
    ClipPathUnits,
    Color,
    ColorInterpolation,
    ColorInterpolationFilters,
    ColorProfile,
    ColorRendering,
    ContentScriptType,
    ContentStyleType,
    Cursor,
    Cx,
    Cy,
    D,
    Descent,
    DiffuseConstant,
    Direction,
    Display,
    Divisor,
    DominantBaseline,
    Dur,
    Dx,
    Dy,
    EdgeMode,
    Elevation,
    EnableBackground,
    Encoding,
    End,
    Exponent,
    ExternalResourcesRequired,
    Fill,
    FillOpacity,
    FillRule,
    Filter,
    FilterRes,
    FilterUnits,
    FloodColor,
    FloodOpacity,
    Font,
    FontFamily,
    FontSize,
    FontSizeAdjust,
    FontStretch,
    FontStyle,
    FontVariant,
    FontWeight,
    Format,
    From,
    Fx,
    Fy,
    G1,
    G2,
    GlyphName,
    GlyphOrientationHorizontal,
    GlyphOrientationVertical,
    GlyphRef,
    GradientTransform,
    GradientUnits,
    Hanging,
    Height,
    HorizAdvX,
    HorizOriginX,
    HorizOriginY,
    Href,
    Id,
    Ideographic,
    ImageRendering,
    In,
    In2,
    Intercept,
    K,
    K1,
    K2,
    K3,
    K4,
    KernelMatrix,
    KernelUnitLength,
    Kerning,
    KeyPoints,
    KeySplines,
    KeyTimes,
    Lang,
    LengthAdjust,
    LetterSpacing,
    LightingColor,
    LimitingConeAngle,
    LineHeight,
    Local,
    Marker,
    MarkerEnd,
    MarkerMid,
    MarkerStart,
    MarkerHeight,
    MarkerUnits,
    MarkerWidth,
    Mask,
    MaskContentUnits,
    MaskUnits,
    Mathematical,
    Max,
    Media,
    Method,
    Min,
    Mode,
    Name,
    NumOctaves,
    Offset,
    Onabort,
    Onactivate,
    Onbegin,
    Onclick,
    Onend,
    Onerror,
    Onfocusin,
    Onfocusout,
    Onload,
    Onmousedown,
    Onmousemove,
    Onmouseout,
    Onmouseover,
    Onmouseup,
    Onrepeat,
    Onresize,
    Onscroll,
    Onunload,
    Onzoom,
    Opacity,
    Operator,
    Order,
    Orient,
    Orientation,
    Origin,
    Overflow,
    OverlinePosition,
    OverlineThickness,
    Panose1,
    Path,
    PathLength,
    PatternContentUnits,
    PatternTransform,
    PatternUnits,
    PointerEvents,
    Points,
    PointsAtX,
    PointsAtY,
    PointsAtZ,
    PreserveAlpha,
    PreserveAspectRatio,
    PrimitiveUnits,
    R,
    Radius,
    RefX,
    RefY,
    RenderingIntent,
    RepeatCount,
    RepeatDur,
    RequiredExtensions,
    RequiredFeatures,
    Restart,
    Result,
    Role,
    Rotate,
    Rx,
    Ry,
    Scale,
    Seed,
    ShapeRendering,
    Show,
    Slope,
    Space,
    Spacing,
    SpecularConstant,
    SpecularExponent,
    SpreadMethod,
    Standalone,
    StartOffset,
    StdDeviation,
    Stemh,
    Stemv,
    StitchTiles,
    StopColor,
    StopOpacity,
    StrikethroughPosition,
    StrikethroughThickness,
    String,
    Stroke,
    StrokeDasharray,
    StrokeDashoffset,
    StrokeLinecap,
    StrokeLinejoin,
    StrokeMiterlimit,
    StrokeOpacity,
    StrokeWidth,
    Style,
    SurfaceScale,
    SystemLanguage,
    TableValues,
    Target,
    TargetX,
    TargetY,
    TextAnchor,
    TextDecoration,
    TextRendering,
    TextLength,
    Title,
    To,
    Transform,
    Type,
    U1,
    U2,
    UnderlinePosition,
    UnderlineThickness,
    Unicode,
    UnicodeBidi,
    UnicodeRange,
    UnitsPerEm,
    VAlphabetic,
    VHanging,
    VIdeographic,
    VMathematical,
    Values,
    Version,
    VertAdvY,
    VertOriginX,
    VertOriginY,
    ViewBox,
    ViewTarget,
    Visibility,
    Width,
    Widths,
    WordSpacing,
    WritingMode,
    X,
    XHeight,
    X1,
    X2,
    XChannelSelector,
    Xlink,
    Xmlns,
    Y,
    Y1,
    Y2,
    YChannelSelector,
    Z,
    ZoomAndPan
}

static ATTRIBUTES: Map<AttributeId> = Map {
    key: 732231254413039614,
    disps: &[
        (0, 1),
        (1, 123),
        (0, 115),
        (0, 2),
        (0, 2),
        (0, 16),
        (1, 155),
        (1, 26),
        (1, 211),
        (0, 5),
        (0, 227),
        (1, 96),
        (0, 141),
        (0, 2),
        (0, 211),
        (0, 18),
        (0, 19),
        (0, 17),
        (2, 105),
        (3, 1),
        (0, 28),
        (0, 9),
        (0, 242),
        (0, 27),
        (0, 17),
        (0, 68),
        (6, 41),
        (8, 57),
        (0, 125),
        (20, 219),
        (0, 54),
        (3, 93),
        (0, 29),
        (7, 60),
        (3, 192),
        (2, 96),
        (0, 262),
        (5, 50),
        (0, 3),
        (0, 111),
        (0, 39),
        (0, 17),
        (0, 1),
        (0, 217),
        (0, 0),
        (3, 159),
        (0, 20),
        (3, 57),
        (0, 52),
        (14, 224),
        (0, 0),
        (9, 236),
        (20, 213),
        (4, 265),
    ],
    entries: &[
        ("order", AttributeId::Order),
        ("lengthAdjust", AttributeId::LengthAdjust),
        ("offset", AttributeId::Offset),
        ("cy", AttributeId::Cy),
        ("azimuth", AttributeId::Azimuth),
        ("viewTarget", AttributeId::ViewTarget),
        ("systemLanguage", AttributeId::SystemLanguage),
        ("exponent", AttributeId::Exponent),
        ("targetX", AttributeId::TargetX),
        ("specularConstant", AttributeId::SpecularConstant),
        ("gradientTransform", AttributeId::GradientTransform),
        ("onclick", AttributeId::Onclick),
        ("opacity", AttributeId::Opacity),
        ("string", AttributeId::String),
        ("onbegin", AttributeId::Onbegin),
        ("k4", AttributeId::K4),
        ("clip-path", AttributeId::ClipPath),
        ("bias", AttributeId::Bias),
        ("font", AttributeId::Font),
        ("dx", AttributeId::Dx),
        ("y1", AttributeId::Y1),
        ("keyTimes", AttributeId::KeyTimes),
        ("markerUnits", AttributeId::MarkerUnits),
        ("stdDeviation", AttributeId::StdDeviation),
        ("baseProfile", AttributeId::BaseProfile),
        ("class", AttributeId::Class),
        ("vert-adv-y", AttributeId::VertAdvY),
        ("widths", AttributeId::Widths),
        ("vert-origin-x", AttributeId::VertOriginX),
        ("color-profile", AttributeId::ColorProfile),
        ("k1", AttributeId::K1),
        ("path", AttributeId::Path),
        ("markerWidth", AttributeId::MarkerWidth),
        ("surfaceScale", AttributeId::SurfaceScale),
        ("space", AttributeId::Space),
        ("onmouseup", AttributeId::Onmouseup),
        ("y", AttributeId::Y),
        ("text-decoration", AttributeId::TextDecoration),
        ("patternUnits", AttributeId::PatternUnits),
        ("lighting-color", AttributeId::LightingColor),
        ("color-interpolation-filters", AttributeId::ColorInterpolationFilters),
        ("bbox", AttributeId::Bbox),
        ("startOffset", AttributeId::StartOffset),
        ("to", AttributeId::To),
        ("version", AttributeId::Version),
        ("targetY", AttributeId::TargetY),
        ("style", AttributeId::Style),
        ("method", AttributeId::Method),
        ("stemh", AttributeId::Stemh),
        ("x", AttributeId::X),
        ("externalResourcesRequired", AttributeId::ExternalResourcesRequired),
        ("k", AttributeId::K),
        ("onmousemove", AttributeId::Onmousemove),
        ("format", AttributeId::Format),
        ("role", AttributeId::Role),
        ("specularExponent", AttributeId::SpecularExponent),
        ("patternTransform", AttributeId::PatternTransform),
        ("points", AttributeId::Points),
        ("markerHeight", AttributeId::MarkerHeight),
        ("stitchTiles", AttributeId::StitchTiles),
        ("fill-rule", AttributeId::FillRule),
        ("g1", AttributeId::G1),
        ("unicode", AttributeId::Unicode),
        ("horiz-origin-y", AttributeId::HorizOriginY),
        ("amplitude", AttributeId::Amplitude),
        ("baseFrequency", AttributeId::BaseFrequency),
        ("from", AttributeId::From),
        ("text-anchor", AttributeId::TextAnchor),
        ("kernelMatrix", AttributeId::KernelMatrix),
        ("clipPathUnits", AttributeId::ClipPathUnits),
        ("panose-1", AttributeId::Panose1),
        ("pointer-events", AttributeId::PointerEvents),
        ("radius", AttributeId::Radius),
        ("local", AttributeId::Local),
        ("type", AttributeId::Type),
        ("min", AttributeId::Min),
        ("id", AttributeId::Id),
        ("kernelUnitLength", AttributeId::KernelUnitLength),
        ("descent", AttributeId::Descent),
        ("direction", AttributeId::Direction),
        ("encoding", AttributeId::Encoding),
        ("calcMode", AttributeId::CalcMode),
        ("attributeType", AttributeId::AttributeType),
        ("onfocusin", AttributeId::Onfocusin),
        ("values", AttributeId::Values),
        ("baseline-shift", AttributeId::BaselineShift),
        ("u2", AttributeId::U2),
        ("letter-spacing", AttributeId::LetterSpacing),
        ("fill-opacity", AttributeId::FillOpacity),
        ("image-rendering", AttributeId::ImageRendering),
        ("flood-opacity", AttributeId::FloodOpacity),
        ("xmlns", AttributeId::Xmlns),
        ("spacing", AttributeId::Spacing),
        ("rx", AttributeId::Rx),
        ("repeatCount", AttributeId::RepeatCount),
        ("horiz-origin-x", AttributeId::HorizOriginX),
        ("stroke", AttributeId::Stroke),
        ("ry", AttributeId::Ry),
        ("href", AttributeId::Href),
        ("maskUnits", AttributeId::MaskUnits),
        ("font-family", AttributeId::FontFamily),
        ("onmousedown", AttributeId::Onmousedown),
        ("xChannelSelector", AttributeId::XChannelSelector),
        ("height", AttributeId::Height),
        ("v-hanging", AttributeId::VHanging),
        ("arabic-form", AttributeId::ArabicForm),
        ("max", AttributeId::Max),
        ("target", AttributeId::Target),
        ("filterUnits", AttributeId::FilterUnits),
        ("scale", AttributeId::Scale),
        ("clip", AttributeId::Clip),
        ("onmouseover", AttributeId::Onmouseover),
        ("show", AttributeId::Show),
        ("refX", AttributeId::RefX),
        ("overline-position", AttributeId::OverlinePosition),
        ("origin", AttributeId::Origin),
        ("arcrole", AttributeId::Arcrole),
        ("stroke-opacity", AttributeId::StrokeOpacity),
        ("filterRes", AttributeId::FilterRes),
        ("contentScriptType", AttributeId::ContentScriptType),
        ("seed", AttributeId::Seed),
        ("onactivate", AttributeId::Onactivate),
        ("shape-rendering", AttributeId::ShapeRendering),
        ("v-mathematical", AttributeId::VMathematical),
        ("vert-origin-y", AttributeId::VertOriginY),
        ("pointsAtX", AttributeId::PointsAtX),
        ("stroke-width", AttributeId::StrokeWidth),
        ("dominant-baseline", AttributeId::DominantBaseline),
        ("divisor", AttributeId::Divisor),
        ("in2", AttributeId::In2),
        ("onresize", AttributeId::Onresize),
        ("width", AttributeId::Width),
        ("y2", AttributeId::Y2),
        ("strikethrough-position", AttributeId::StrikethroughPosition),
        ("font-size-adjust", AttributeId::FontSizeAdjust),
        ("glyph-orientation-vertical", AttributeId::GlyphOrientationVertical),
        ("onfocusout", AttributeId::Onfocusout),
        ("pathLength", AttributeId::PathLength),
        ("fill", AttributeId::Fill),
        ("color-interpolation", AttributeId::ColorInterpolation),
        ("yChannelSelector", AttributeId::YChannelSelector),
        ("rendering-intent", AttributeId::RenderingIntent),
        ("contentStyleType", AttributeId::ContentStyleType),
        ("font-style", AttributeId::FontStyle),
        ("base", AttributeId::Base),
        ("writing-mode", AttributeId::WritingMode),
        ("unicode-bidi", AttributeId::UnicodeBidi),
        ("refY", AttributeId::RefY),
        ("title", AttributeId::Title),
        ("result", AttributeId::Result),
        ("cx", AttributeId::Cx),
        ("flood-color", AttributeId::FloodColor),
        ("stroke-dashoffset", AttributeId::StrokeDashoffset),
        ("edgeMode", AttributeId::EdgeMode),
        ("font-weight", AttributeId::FontWeight),
        ("lang", AttributeId::Lang),
        ("requiredExtensions", AttributeId::RequiredExtensions),
        ("orient", AttributeId::Orient),
        ("marker", AttributeId::Marker),
        ("font-size", AttributeId::FontSize),
        ("onmouseout", AttributeId::Onmouseout),
        ("font-variant", AttributeId::FontVariant),
        ("onzoom", AttributeId::Onzoom),
        ("limitingConeAngle", AttributeId::LimitingConeAngle),
        ("onrepeat", AttributeId::Onrepeat),
        ("in", AttributeId::In),
        ("pointsAtZ", AttributeId::PointsAtZ),
        ("zoomAndPan", AttributeId::ZoomAndPan),
        ("mask", AttributeId::Mask),
        ("begin", AttributeId::Begin),
        ("v-alphabetic", AttributeId::VAlphabetic),
        ("keyPoints", AttributeId::KeyPoints),
        ("g2", AttributeId::G2),
        ("glyphRef", AttributeId::GlyphRef),
        ("name", AttributeId::Name),
        ("visibility", AttributeId::Visibility),
        ("ideographic", AttributeId::Ideographic),
        ("font-stretch", AttributeId::FontStretch),
        ("display", AttributeId::Display),
        ("overflow", AttributeId::Overflow),
        ("stroke-linecap", AttributeId::StrokeLinecap),
        ("color-rendering", AttributeId::ColorRendering),
        ("stop-opacity", AttributeId::StopOpacity),
        ("accumulate", AttributeId::Accumulate),
        ("word-spacing", AttributeId::WordSpacing),
        ("glyph-orientation-horizontal", AttributeId::GlyphOrientationHorizontal),
        ("tableValues", AttributeId::TableValues),
        ("line-height", AttributeId::LineHeight),
        ("kerning", AttributeId::Kerning),
        ("enable-background", AttributeId::EnableBackground),
        ("x-height", AttributeId::XHeight),
        ("gradientUnits", AttributeId::GradientUnits),
        ("stemv", AttributeId::Stemv),
        ("viewBox", AttributeId::ViewBox),
        ("glyph-name", AttributeId::GlyphName),
        ("k3", AttributeId::K3),
        ("textLength", AttributeId::TextLength),
        ("preserveAlpha", AttributeId::PreserveAlpha),
        ("onload", AttributeId::Onload),
        ("operator", AttributeId::Operator),
        ("horiz-adv-x", AttributeId::HorizAdvX),
        ("v-ideographic", AttributeId::VIdeographic),
        ("cap-height", AttributeId::CapHeight),
        ("restart", AttributeId::Restart),
        ("fy", AttributeId::Fy),
        ("intercept", AttributeId::Intercept),
        ("fx", AttributeId::Fx),
        ("alphabetic", AttributeId::Alphabetic),
        ("onscroll", AttributeId::Onscroll),
        ("end", AttributeId::End),
        ("color", AttributeId::Color),
        ("accent-height", AttributeId::AccentHeight),
        ("patternContentUnits", AttributeId::PatternContentUnits),
        ("numOctaves", AttributeId::NumOctaves),
        ("x2", AttributeId::X2),
        ("units-per-em", AttributeId::UnitsPerEm),
        ("stroke-linejoin", AttributeId::StrokeLinejoin),
        ("attributeName", AttributeId::AttributeName),
        ("mathematical", AttributeId::Mathematical),
        ("underline-thickness", AttributeId::UnderlineThickness),
        ("ascent", AttributeId::Ascent),
        ("orientation", AttributeId::Orientation),
        ("keySplines", AttributeId::KeySplines),
        ("hanging", AttributeId::Hanging),
        ("z", AttributeId::Z),
        ("primitiveUnits", AttributeId::PrimitiveUnits),
        ("diffuseConstant", AttributeId::DiffuseConstant),
        ("strikethrough-thickness", AttributeId::StrikethroughThickness),
        ("cursor", AttributeId::Cursor),
        ("marker-end", AttributeId::MarkerEnd),
        ("clip-rule", AttributeId::ClipRule),
        ("marker-mid", AttributeId::MarkerMid),
        ("x1", AttributeId::X1),
        ("requiredFeatures", AttributeId::RequiredFeatures),
        ("alignment-baseline", AttributeId::AlignmentBaseline),
        ("unicode-range", AttributeId::UnicodeRange),
        ("stop-color", AttributeId::StopColor),
        ("elevation", AttributeId::Elevation),
        ("k2", AttributeId::K2),
        ("dy", AttributeId::Dy),
        ("mode", AttributeId::Mode),
        ("repeatDur", AttributeId::RepeatDur),
        ("actuate", AttributeId::Actuate),
        ("by", AttributeId::By),
        ("pointsAtY", AttributeId::PointsAtY),
        ("r", AttributeId::R),
        ("additive", AttributeId::Additive),
        ("rotate", AttributeId::Rotate),
        ("slope", AttributeId::Slope),
        ("media", AttributeId::Media),
        ("maskContentUnits", AttributeId::MaskContentUnits),
        ("spreadMethod", AttributeId::SpreadMethod),
        ("filter", AttributeId::Filter),
        ("text-rendering", AttributeId::TextRendering),
        ("underline-position", AttributeId::UnderlinePosition),
        ("onabort", AttributeId::Onabort),
        ("dur", AttributeId::Dur),
        ("xlink", AttributeId::Xlink),
        ("stroke-miterlimit", AttributeId::StrokeMiterlimit),
        ("onerror", AttributeId::Onerror),
        ("onend", AttributeId::Onend),
        ("stroke-dasharray", AttributeId::StrokeDasharray),
        ("d", AttributeId::D),
        ("preserveAspectRatio", AttributeId::PreserveAspectRatio),
        ("standalone", AttributeId::Standalone),
        ("transform", AttributeId::Transform),
        ("marker-start", AttributeId::MarkerStart),
        ("u1", AttributeId::U1),
        ("overline-thickness", AttributeId::OverlineThickness),
        ("onunload", AttributeId::Onunload),
    ],
};

impl AttributeId {
    /// Parses `AttributeId` from a string.
    pub fn from_str(text: &str) -> Option<AttributeId> {
        ATTRIBUTES.get(text).cloned()
    }

    /// Returns an original string.
    pub fn as_str(&self) -> &'static str {
        ATTRIBUTES.key(self)
    }
}

impl fmt::Debug for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}

impl fmt::Display for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.as_str())
    }
}

// A stripped down `phf` crate fork.
//
// https://github.com/sfackler/rust-phf

struct Map<V: 'static> {
    pub key: u64,
    pub disps: &'static [(u32, u32)],
    pub entries: &'static[(&'static str, V)],
}

impl<V: PartialEq> Map<V> {
    fn get(&self, key: &str) -> Option<&V> {
        use std::borrow::Borrow;

        let hash = hash(key, self.key);
        let index = get_index(hash, &*self.disps, self.entries.len());
        let entry = &self.entries[index as usize];
        let b = entry.0.borrow();
        if b == key {
            Some(&entry.1)
        } else {
            None
        }
    }

    fn key(&self, value: &V) -> &'static str {
        self.entries.iter().find(|kv| kv.1 == *value).unwrap().0
    }
}

#[inline]
fn hash(x: &str, key: u64) -> u64 {
    use std::hash::Hasher;

    let mut hasher = siphasher::sip::SipHasher13::new_with_keys(0, key);
    hasher.write(x.as_bytes());
    hasher.finish()
}

#[inline]
fn get_index(hash: u64, disps: &[(u32, u32)], len: usize) -> u32 {
    let (g, f1, f2) = split(hash);
    let (d1, d2) = disps[(g % (disps.len() as u32)) as usize];
    displace(f1, f2, d1, d2) % (len as u32)
}

#[inline]
fn split(hash: u64) -> (u32, u32, u32) {
    const BITS: u32 = 21;
    const MASK: u64 = (1 << BITS) - 1;

    ((hash & MASK) as u32,
     ((hash >> BITS) & MASK) as u32,
     ((hash >> (2 * BITS)) & MASK) as u32)
}

#[inline]
fn displace(f1: u32, f2: u32, d1: u32, d2: u32) -> u32 {
    d2 + f1 * d1 + f2
}
