#ifndef RUMBA_COLORMAP_H
#define RUMBA_COLORMAP_H

#include <qpixmap.h>
#include <qimage.h>
#include <string>

namespace RUMBA
{
class Colormap
{
public:
	Colormap(const char* filename, const char* name = 0);
	Colormap(const char** xpm, const char* name );
	Colormap(const Colormap& cm);
	Colormap& operator=(const Colormap& cm);
	~Colormap();
	size_t size() const;
	void resize(size_t i);
	QRgb operator[] (int i) { 
		//return *(Im.colorTable() + i); 
		return Im.pixel(i,0);
	}
	const QRgb operator[] (int i) const { 
		// return *(Im.colorTable() + i); 
		return Im.pixel(i,0);
	}
	QRgb getColor(int i) const { return Im.pixel(i,0); }
	void setColor(int i, QRgb c) { Im.setColor(Im.pixel(i,0),c); }
	string name() const { return Name; }
	void setName(string s) { Name=s; }

	typedef QRgb* iterator;
	typedef const QRgb* const_iterator;

	iterator begin(){ return Im.colorTable(); }
	iterator end(){ return Im.colorTable() + Im.numColors(); }
	const_iterator begin() const { return Im.colorTable(); }
	const_iterator end() const { return Im.colorTable() + Im.numColors(); }


private:
	void loadImage(const char*);
	QImage Im;
	std::string Name;
};

} // RUMBA

#endif
