#include <colormap.h>
#include <algorithm>
#include <fstream>

#include "colormaplist.h"

using namespace RUMBA;

Colormap::Colormap(const char* filename, const char* s)  
{
	loadImage(filename);

	if (s != 0)
		Name = s; 
	else
	{
		for ( ; *filename != '\0' && *filename != '.'; ++filename )
			Name+= *filename;
	}
	
} 

Colormap::Colormap(const char** xpm, const char* s)
	: Im(xpm), Name(s)
{}

Colormap::Colormap(const Colormap& cm)
{
	resize(cm.size());
	std::copy(cm.begin(),cm.end(),begin());
	setName(cm.name());
	Im=cm.Im;
}

Colormap& Colormap::operator=(const Colormap& cm)
{
	if ( &cm == this ) 
		return *this;
	resize(cm.size());
	std::copy(cm.begin(),cm.end(),begin());
	setName(cm.name());
	Im=cm.Im;
	return *this;
}

Colormap::~Colormap()
{}

size_t Colormap::size() const 
{ 
	return (size_t)Im.numColors(); 
}

void Colormap::resize(size_t i) 
{ 
	Im.setNumColors(i); 
}

void Colormap::loadImage (const char* filename)
{
	string fullname = RUMBA::getPath();
	fullname +=	"/";
	fullname += filename;
	Im.load(fullname.c_str());
}




