#include <algorithm>
#include <vector>
#include <string>
#include <rumba/svd.h>
#include <rumba/matrixio.h>

int COUNT = 0;
int PASS = 0;
int FAIL = 0;

using namespace RUMBA;
void svd_test(const std::string& s)
{
	++COUNT;

	ManifoldMatrix A = RUMBA::readManifoldMatrix ( s.c_str());

	ManifoldMatrix U(makeMatrix(Manifold<double>()));
	ManifoldMatrix V(makeMatrix(Manifold<double>()));
	ManifoldMatrix D(makeMatrix(Manifold<double>()));

	svd(A,U,V,D);
	
	// self test

	ManifoldMatrix test(U*D*V.transpose() - A);

	bool success = true;
	for ( int i = 0; i < test.rows(); ++i )
		for ( int j = 0; j < test.cols(); ++ j )
			if ( test.element(i,j) > 1e-4 )
			{
				success=false;
				break;
			}
	if ( !success)
		++FAIL;
	else
		++PASS;



}

int main(int argc, char** argv)
{
	std::vector<std::string> infile;
	if (argc > 1 )
	{
		std::copy(argv+1, argv+argc, std::back_inserter(infile));
	}

	if ( infile.empty() )
	{
		std::cerr << "No infile" << std::endl;
		exit(1);
	}

	try 
	{
		std::for_each(infile.begin(),infile.end(),svd_test);
	}
	catch (RUMBA::Exception& e)
	{
		std::cerr << e.error() << std::endl;
	}

	std::cout << "SVD: " << COUNT << " tests, passed " << PASS <<
		" failed: " << FAIL << std::endl;

}
