#include "test.h"

#include <rumba/parsecsv.h>
#include <list>
#include <iomanip>
#include <fstream>
#include <rumba/header_request.h>

using std::list;
using RUMBA::header_request;
using std::cout;


void print(const RUMBA::header_request& h)
{
	cout << std::setw(12) << "Name:" << h.name << endl;
	cout << std::setw(12) << "Type:" << h.type << endl;
	cout << std::setw(12) << "Offset:" << h.offset << endl;
	cout << std::setw(12) << "Bytes:" << h.bytes << endl;
	cout << std::setw(12) << "Required:"<< h.required << endl;
	cout << std::setw(12) << "Default:" << h.default_value.asString() << endl;
}

void testParseCsv (std::istream& test)
{
	list<header_request> items;
	parseCsv(items, test);
	list<header_request>::const_iterator it;

	if ( items.empty() ) 
		return;

	for ( it = items.begin(); it != items.end(); ++it )
		print(*it);
		
}

int main()
{
	std::ifstream fin("analyze_header_request.csv");
	if ( !fin)
	{
		cout << "Couldn't open input file" << endl;
		return 1;
	}

	testParseCsv (fin);
	return 0;

}
