#include "rumba/iohandler.h"

int RUMBA::IOHandlerBase::size()
{
	return Size; 
}

RUMBA::IOHandlerBase::IOHandlerBase():log("IOHandlerBase")
{
	hostLE = littleEndianHost();
}

RUMBA::IOHandlerBase
::IOHandlerBase
( 
 const char* filename, 
 int Size,
 std::ios_base::openmode mode 
 ) 
: 
	log("IOHandlerBase"), 
	Stream(filename,mode|std::ios::binary|std::ios::in), 
	Filename(filename),
	Size(Size)
{

#ifdef DEBUG
	log.logName() << "IOHandlerBase created with args:" << filename << ":" << mode << "\n";
#endif
	hostLE = littleEndianHost();	

	if (!Stream)
		throw RUMBA::BadFile(std::string("Couldn't open file ") + filename );
			

	if (!(mode|std::ios::in))
	{
		Stream.close();
		Stream.clear();
		Stream.open(Filename.c_str(),mode|std::ios::in|std::ios::binary); // need this for write-caching
	}


}

void RUMBA::IOHandlerBase::resize(int s)
{
	Size = s;
	grow(s);
}


int RUMBA::filesize ( std::fstream& Stream )
{
	std::streampos savep, p1, p2;
	savep = Stream.tellp();
	Stream.seekp(0,std::ios::beg);
	p1 = Stream.tellp();
	Stream.seekp(0,std::ios::end);
	p2 = Stream.tellp();
	Stream.seekp(savep);
	return p2 - p1;
}

