#include <config.h>
#include <rumba_getenv.h>
#include <rumba/parse.h>

#include <iostream>
#include <sstream>
#include <string>
#include <map>
#include <stdexcept>
#include <fstream>

using RUMBA::rumba_getenv;
using RUMBA::rumba_file_exists;






std::string find_file_modules()
{
	std::string rumba_dir ( rumba_getenv("RUMBA") );
	std::string config_file;
	if ( rumba_dir.empty() )
	{
		// RUMBA is undefined, so we try to find the config file
		config_file = get_rumba_config();
		if ( config_file.empty() )
			rumba_dir = RUMBA_PREFIX;
		else
		{
			std::ifstream conf(config_file.c_str());
			rumba_dir = rcFind ( conf, "RUMBA", rumba_dir );
			if ( rumba_dir.empty() )
				throw domain_error ( "Couldn't find config file and RUMBA env variable is unset!\n" );	
		}
	}
	// now try to find libanalyzeFile.so

	std::string file_modules = rumba_dir + std::string ( "/lib/filetypes" );
	std::string test = file_modules + "/libanalyzeFile.so";
	if ( ! rumba_file_exists(test.c_str())  ) // Check if file exists.
	{
		std::cerr << "Can't find libanalyzeFile.so. Please set RUMBA \n "
			<< "to point to your rumba installation directory" << std::endl;
		return "";
	}
	else
		return file_modules;
}


