#include <analyzeFile.h>
#include <string>
#include <fstream>

/**
  *	Register myFile and create a prototype
  *
  **********************************************/

using RUMBA::myFile;
using RUMBA::ManifoldFile;


// Argument to Exemplar is only used for debug purposes. This creates the prototype.
myFile myFileInstance(Exemplar("myFile"));

myFile::myFile()
{}

// Only the prototype uses this constructor.
myFile::myFile( Exemplar a )
:ManifoldFile(a)
{
	cerr << "Calling myFile(Exemplar)\n";
}

// Identify whether file really is of this type. Return true if it is.
// The code usually relies on the file extension, as shown below.
bool myFile::isMine( std::string filename )
{
	cerr << "Calling myFile::isMine(" << filename << ")\n";
	string ext;
	ext.assign( filename, filename.find_last_of("."), filename.length()); 
	return( ext == ".img" || ext == ".hdr" );
}


// make gets invoked on the prototype object. Its job is to create a new file.

ManifoldFile* 
myFile::make(std::string filename)
{
	myFile* res = new myFile;
	// get header file
	std::string basename;

	basename.assign (filename, 0, filename.find_last_of("."));
	res->HeaderFile = basename + ".hdr";
	res->DataFile = basename + ".img";
	res->loadHeader(res->HeaderFile.c_str());

	// Should move this elsewhere.
	res->initFile ();
	return res;
}

// this function is responsible for setting up the IO handling mechanism. Usually, 
// it's appropriate to use IOHandler, but if ASCII format is used, some other method
// may be more appropriate.

void myFile::initFile()
{
	cerr << "Calling initFile()" << endl;
	switch ( fileDataType )
	{
		case 2: 	
			Data = new IOHandler<char>(DataFile.c_str()); break;
		case 4: 
			Data = new IOHandler<short>(DataFile.c_str()); break;
		case 8: 
			Data = new IOHandler<int>(DataFile.c_str()); break;
		case 16:
			Data = new IOHandler<float>(DataFile.c_str()); break;
		case 64:
			Data = new IOHandler<double>(DataFile.c_str()); break;
		default:
			Data = new IOHandler<double>(DataFile.c_str());
			cerr << "Warning: bad data type" << fileDataType << endl;
			cerr << "myFile::Data is: " << (void*) Data << endl;
	}
}


// These two functions are supposed to "understand" the file format.
void myFile::saveHeader(const char* filename) {	}
void myFile::loadHeader(const char* filename) {	}



