#ifndef RUMBA_ANALYZE_FILE_H
#define RUMBA_ANALYZE_FILE_H

#include <rumba/exemplar.h>
#include <rumba/header_request.h>
#include <rumba/manifoldFile.h>
#include <string>
#include <list>
#include <fstream>


namespace RUMBA
{



class AnalyzeFile : public ManifoldFile 
{

public:
	AnalyzeFile();
	AnalyzeFile(Exemplar);
//	ManifoldFile* make( std::string s, int mode, const BaseManifold*);
	virtual bool isMine(std::string s);
	void saveHeader(const char* filename);
	void loadHeader(const char* filename);
	ManifoldFile* getNew();
	virtual ~AnalyzeFile();
protected:


private:

	void endian_hack(const char* filename, std::ifstream& in);

	void loadCsv();
	void loadRc();
	Factory* getFactoryFromDataType(std::string );
//	std::string normalizeDataType(std::string t);

	void fillRequiredHeaders();


	std::list<RUMBA::header_request> HeaderRequests;

	std::string header_size;

};

	extern AnalyzeFile AnalyzeFileInstance;
	extern AnalyzeFile* AnalyzeFileExemplar;



}//namespace RUMBA


#endif
