#ifndef RUMBA_TIMEVECTOR_H
#define RUMBA_TIMEVECTOR_H

namespace RUMBA
{

struct TimeVector
{
	TimeVector(double* x = 0, int sz = 0, int sk=1)
		: m_begin(x), m_skip(sk), size(sz) {}
	struct iterator 
	{
		double* it;
		int skip;
		inline iterator(double* x, int y):it(x),skip(y){}
		inline iterator& operator++() { it+=skip; return *this; }
		inline iterator& operator--() { it+=skip; return *this; }
		inline bool operator==(const iterator& rhs) const { 
			return it==rhs.it && skip==rhs.skip; 
		}

		inline double& operator*(){return *it;}
	};
	struct const_iterator 
	{
		const double* it;
		int skip;
		inline const_iterator(const double* x, int y):it(x),skip(y){}
		inline const_iterator& operator++() { it+=skip; return *this; }
		inline const_iterator& operator--() { it+=skip; return *this; }
		inline bool operator==(const const_iterator& rhs) const { 
			return it==rhs.it && skip==rhs.skip; 
		}
		inline const_iterator(const iterator& y):it(y.it),skip(y.skip) {}
		inline double operator*() {return *it;}
	};


	iterator begin() { return iterator(m_begin, m_skip); }
	iterator end() { return iterator(m_begin + m_skip*size, m_skip); }
	const_iterator begin() const { return iterator(m_begin, m_skip); }
	const_iterator end() const { return iterator(m_begin + m_skip*size, m_skip); }

	double* m_begin;
	int m_skip;
	int size;

};


inline std::ostream& operator<<(std::ostream& s, const TimeVector& x)
{
	s << "TimeVector at " << (void*) x.m_begin	<< " size: " << x.size << "skip: " <<
		x.m_skip;
	return s;
}

}; /* namespace RUMBA */

#endif
