#ifndef BASE_MANIFOLD_CC
#define BASE_MANIFOLD_CC

#ifndef BASE_MANIFOLD_H
#include <rumba/baseManifold.h>
#endif

#include <rumba/constants.h>


#include <iostream>


#include <rumba/manifoldFile.h>


extern "C++" {

RUMBA::BaseManifold::BaseManifold() :
log("BaseManifold"),
LittleEndian ( true ),
Extent(1,1,1,1),
VoxelSize (1,1,1,1),
// DataFile(""),
// fileDataType (-1),
// StdOrient(""),
Origin(0,0,0,0)
{
}



RUMBA::BaseManifold::~BaseManifold() {}


void RUMBA::BaseManifold
::copyHeader(const BaseManifold& M)
{
#ifdef DEBUG
	log.logName() << "Calling BaseManifold::copyHeader";
#endif
	LittleEndian = M.LittleEndian;

	Extent = M.Extent;

	VoxelSize = M.VoxelSize;

	Origin = M.Origin;

//	StdOrient = M.StdOrient;

	Orient = M.Orient;

	Skip = M.Skip;

//	fileDataType = M.getDataType(); // ManifoldFile needs this
	HeaderData = M.HeaderData;
#ifdef DEBUG
	log.logName() << "Leaving BaseManifold::copyHeader";
#endif
}

/*
int RUMBA::BaseManifold::getFileDataType( )
{
	return ( fileDataType );
}
*/

int RUMBA::BaseManifold::width() const
{	
	return Extent.x();
}

int RUMBA::BaseManifold::height() const
{	
	return Extent.y();
}

int RUMBA::BaseManifold::depth() const
{	
	return Extent.z();
}

int RUMBA::BaseManifold::timepoints() const
{	
	return Extent.t();
}

int RUMBA::BaseManifold::pixels() const
{	
	return Extent.x() * Extent.y() * Extent.z();
}

int RUMBA::BaseManifold::size() const
{	
	return Extent.x() * Extent.y() * Extent.z() * Extent.t();
}

RUMBA::doublePoint RUMBA::BaseManifold::voxelSize() const
{	
	return VoxelSize;
}



void RUMBA::BaseManifold::setVoxelSize(const doublePoint& sz)
{	
	VoxelSize = sz;
	copyHeaderDataFromManifold();
}

RUMBA::intPoint RUMBA::BaseManifold::extent() const
{	
	return Extent;	
}

void RUMBA::BaseManifold::setExtent(const intPoint& p)
{	
	Extent = p;	
	Skip = skip();
	copyHeaderDataFromManifold();
}


/*------------------------------------------------------------------------*/
//
//			Methods for loading files
//
/*------------------------------------------------------------------------*/

void RUMBA::BaseManifold::load( std::string filename, bool loadImage )
{
#ifdef DEBUG
	log.logName() << "Entering BaseManifold::load()" << std::endl;
#endif

	ManifoldFile* f = RUMBA::ManifoldFile::construct(filename);
	copyHeader(*f);

	if (loadImage)
	{
		allocate(Extent);
#ifdef DEBUG
	print(log.logName());
	cerr << size() << std::endl;
#endif
		loadData(f);
	}
	delete f;
#ifdef DEBUG
	log.logName() << "Leaving BaseManifold::load()" << std::endl;
#endif
}

RUMBA::intPoint RUMBA::BaseManifold::skip() const
{
	return intPoint ( 
		1, 
		Extent.x(), 
		Extent.x() * Extent.y(), 
		Extent.x() * Extent.y() * Extent.z() 
		);
}





/*------------------------------------------------------------------------*/
//
//			Methods for saving files
//
/*------------------------------------------------------------------------*/

// This method takes a filename with an extension and deduces the type
// from the filename.
void RUMBA::BaseManifold::save( std::string filename, bool save_image ) const
{
#ifdef DEBUG
	log.logName() << "Calling BaseManifold::save()" << std::endl;
#endif
	ManifoldFile *f = RUMBA::ManifoldFile::construct(filename, std::ios::out, this);
	if (save_image)
	{
#ifdef DEBUG
		log.logName() << "Calling saveData" << std::endl;
		log.logName() << "width/height/depth/tp of new manifold" << std::endl;
		log.logName() << f->width() << " " << f->height() << " " << f->depth() 
			<< " " << f->timepoints() << std::endl;
#endif

		saveData(f);
#ifdef DEBUG
		log.logName() << "Data saved sucessfuly" << std::endl;
#endif
	}
	delete f;
}




void RUMBA::BaseManifold::copyHeaderDataToManifold()
{
	/*------- Should check return values and possibly throw exceptions. 
	  Note that nothing should go wrong here if this code is consistent 
	  with csv specification -----------------*/

	HeaderData["width"].asInt(Extent.x());
	HeaderData["height"].asInt(Extent.y());
	HeaderData["depth"].asInt(Extent.z());
	HeaderData["timepoints"].asInt(Extent.t());
	HeaderData["dimX"].asDouble(VoxelSize.x());
	HeaderData["dimY"].asDouble(VoxelSize.y());
	HeaderData["dimZ"].asDouble(VoxelSize.z());
	HeaderData["dimT"].asDouble(VoxelSize.t());

	if ( Extent.x() == 0 ) Extent.x() = 1;
	if ( Extent.y() == 0 ) Extent.y() = 1;
	if ( Extent.z() == 0 ) Extent.z() = 1;
	if ( Extent.t() == 0 ) Extent.t() = 1;

}

void RUMBA::BaseManifold::copyHeaderDataFromManifold()
{
	HeaderData["width"]=Extent.x();
	HeaderData["height"]=Extent.y();
	HeaderData["depth"]=Extent.z();
	HeaderData["timepoints"]=Extent.t();
	HeaderData["dimX"]=VoxelSize.x();
	HeaderData["dimY"]=VoxelSize.y();
	HeaderData["dimZ"]=VoxelSize.z();
	HeaderData["dimT"]=VoxelSize.t();
	
}

std::map<std::string, RUMBA::Splodge> & 
RUMBA::BaseManifold::headerData()
{
	return HeaderData;
}

const std::map<std::string, RUMBA::Splodge> & 
RUMBA::BaseManifold::headerData() const
{
	return HeaderData;
}



RUMBA::Orientation 
RUMBA::BaseManifold::orientation()  const
{
	return Orient;
}

bool RUMBA::BaseManifold::littleEndian() { return LittleEndian; }
void RUMBA::BaseManifold::setLittleEndian(bool b) { LittleEndian = b; }



} // extern "C++"

#endif
