#include <cstdlib>
#include <iostream>
#include <rumba/manifoldfile.h>

int main()
{
	RUMBA::ManifoldFile* f = RUMBA::ManifoldFile::construct( "foo.img" );
	// we have requirements on the dimensions:
	if ( f->width() < 3 || f->height < 1 || f->depth() < 3 || f-> timepoints() < 1 )
	{
		delete f;
		cout << "Manifold too small" << endl;
		exit ( EXIT_FAILURE );
	}
	RUMBA::BaseManifold* b = f->get(1,0,1,0,2,1,2,1);
	b->print();

	for ( int i=0; i<b->size(); ++i )
		cout << b->getElementInt(i) << endl;
	cout << f->getElementDouble(4) << endl;
	return 0;
}
