require 'runit/testcase'
require 'runit/cui/testrunner'

require 'runit/setuppable'

class DummySetup
  extend RUNIT::Setuppable
  include RUNIT::Setuppable
  def dummy1
  end
  def setup1
    "setup1 called"
  end
  attach_setup :setup1, :dummy1
  def dummy2
  end
  def setup2
    "setup2 called"
  end
  attach_setup :setup2, :dummy2
  def invoke_set(id)
    invoke_setup(id)
  end
end

class DummySetupNew
  extend RUNIT::Setuppable
  include RUNIT::Setuppable
  def setup_new
    "DummySetupNew#setup_new called"
  end
  def dummy1
  end
  def invoke_set(id)
    invoke_setup(id)
  end
  attach_setup :setup_new, :dummy1
end
  
class TestSetuppable < RUNIT::TestCase
  def test_setup_invoke_setup
    dmsetup = DummySetup.new
    assert_equal("setup1 called", dmsetup.invoke_set(:dummy1))
    dmsetup = DummySetupNew.new
    assert_equal("DummySetupNew#setup_new called", dmsetup.invoke_set(:dummy1))
  end
end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestSetuppable.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestSetuppable.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
