
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 22, 23, 24, 26, 37, 
	38, 39, 43, 48, 53, 58, 63, 67, 
	71, 73, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 93, 100, 105, 109, 115, 118, 120, 
	126, 137, 139, 140, 141, 142, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 157, 158, 159, 160, 
	161, 162, 163, 164, 165, 166, 167, 168, 
	169, 170, 171, 172, 174, 175, 176, 177, 
	178, 179, 180, 181, 182, 183, 184, 185, 
	186, 187, 188, 189, 190, 191, 192, 193, 
	194, 203, 214, 216, 227, 230, 232, 234, 
	236, 238, 240, 242, 244, 246, 248, 250, 
	252, 254, 256, 258, 260, 262, 264, 266, 
	268, 270, 272, 274, 276, 278, 280, 282, 
	284, 286, 288, 290, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 310, 312, 314, 
	316, 318, 320, 322, 324, 326, 328, 330, 
	332, 335, 337, 339, 341, 343, 346, 348, 
	350, 352, 354, 356, 358, 360, 362, 364, 
	366, 368, 370, 372, 374, 376, 378, 380, 
	382, 384, 386, 388, 390, 392, 394, 396, 
	398, 400, 402, 404, 406, 408, 410, 412, 
	414, 416, 418, 420, 422, 424, 426, 428, 
	430, 432, 434, 436, 439, 442, 444, 446, 
	448, 450, 452, 454, 456, 458, 460, 462, 
	464, 466, 468, 470, 472, 474, 476, 478, 
	480, 482, 484, 486, 488, 490, 492, 494, 
	496, 498, 500, 502, 504, 506, 508, 510, 
	512, 514, 516, 517, 518, 519, 520, 522, 
	523, 524, 525, 526, 527, 528, 529, 530, 
	531, 532, 533, 540, 542, 544, 546, 548, 
	550, 552, 554, 556, 558, 560, 562, 564, 
	566, 568, 570, 572, 574, 576, 578, 580, 
	581, 582, 583, 584, 585, 586, 587, 588, 
	589, 590, 591, 592, 594, 595, 596, 597, 
	598, 600, 601, 602, 603, 604, 605, 606, 
	607, 608, 609, 610, 611, 612, 613, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 626, 627, 628, 629, 630, 
	631, 632, 633, 634, 643, 654, 656, 659, 
	661, 663, 665, 667, 669, 671, 673, 675, 
	677, 679, 681, 683, 685, 687, 689, 691, 
	693, 695, 697, 699, 701, 703, 705, 707, 
	709, 711, 713, 715, 717, 719, 721, 723, 
	725, 727, 729, 731, 733, 735, 737, 739, 
	741, 743, 745, 747, 749, 751, 753, 755, 
	757, 759, 761, 764, 766, 768, 770, 772, 
	774, 776, 778, 780, 782, 784, 786, 788, 
	790, 792, 794, 796, 798, 800, 802, 805, 
	808, 810, 812, 814, 816, 818, 820, 822, 
	824, 826, 828, 830, 832, 834, 836, 838, 
	840, 842, 844, 846, 848, 850, 852, 854, 
	856, 858, 860, 862, 864, 866, 868, 870, 
	872, 874, 876, 878, 880, 882, 883, 884, 
	885, 886, 887, 888, 889, 890, 891, 892, 
	893, 894, 895, 896, 897, 906, 917, 919, 
	922, 924, 926, 928, 930, 932, 934, 936, 
	938, 940, 942, 944, 946, 948, 950, 952, 
	954, 956, 958, 960, 962, 964, 966, 968, 
	970, 972, 974, 976, 978, 980, 982, 984, 
	986, 988, 991, 993, 995, 997, 999, 1001, 
	1003, 1005, 1007, 1009, 1011, 1013, 1015, 1017, 
	1019, 1021, 1023, 1025, 1027, 1029, 1031, 1033, 
	1035, 1037, 1039, 1041, 1043, 1045, 1047, 1049, 
	1051, 1053, 1055, 1057, 1059, 1061, 1064, 1066, 
	1068, 1070, 1072, 1075, 1077, 1079, 1081, 1083, 
	1085, 1087, 1089, 1091, 1093, 1095, 1097, 1099, 
	1101, 1103, 1105, 1107, 1109, 1111, 1113, 1115, 
	1117, 1119, 1121, 1123, 1125, 1127, 1129, 1131, 
	1133, 1135, 1137, 1139, 1141, 1143, 1145, 1147, 
	1149, 1151, 1153, 1155, 1157, 1159, 1161, 1163, 
	1166, 1169, 1171, 1173, 1175, 1177, 1179, 1181, 
	1183, 1185, 1187, 1189, 1191, 1193, 1195, 1197, 
	1199, 1201, 1203, 1205, 1207, 1209, 1211, 1213, 
	1215, 1217, 1219, 1221, 1223, 1225, 1227, 1229, 
	1231, 1233, 1235, 1237, 1239, 1241, 1243, 1244, 
	1246, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 
	1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 
	1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 
	1271, 1272, 1280, 1284, 1287, 1289, 1291, 1293, 
	1295, 1297, 1299, 1301, 1303, 1305, 1307, 1309, 
	1311, 1313, 1315, 1317, 1319, 1321, 1323, 1325, 
	1327, 1329, 1331, 1333, 1335, 1337, 1339, 1341, 
	1343, 1345, 1347, 1349, 1351, 1354, 1356, 1358, 
	1360, 1362, 1364, 1366, 1368, 1370, 1372, 1374, 
	1376, 1378, 1380, 1382, 1384, 1386, 1388, 1390, 
	1392, 1394, 1396, 1398, 1400, 1402, 1404, 1406, 
	1408, 1410, 1412, 1414, 1416, 1418, 1420, 1422, 
	1424, 1426, 1428, 1430, 1432, 1434, 1436, 1438, 
	1440, 1442, 1444, 1446, 1448, 1450, 1452, 1454, 
	1456, 1458, 1460, 1462, 1464, 1466, 1468, 1470, 
	1472, 1474, 1476, 1478, 1480, 1482, 1484, 1486, 
	1488, 1490, 1492, 1494, 1496, 1498, 1500, 1502, 
	1504, 1505, 1506, 1507, 1508
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -122, -112, -108, -102, 
	-99, -97, -95, -94, -92, -81, 32, 10, 
	10, 13, -48, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, 34, 34, 10, 
	32, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 32, 124, 9, 13, 10, 32, 92, 
	124, 9, 13, 10, 92, 124, 10, 92, 
	10, 32, 92, 124, 9, 13, -48, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -48, 32, -69, -48, -75, -47, -126, 
	-48, -80, -48, -70, -48, -66, -48, -74, 
	-48, -80, -48, -67, -48, -66, -48, -66, 
	-48, -69, -48, -72, -48, -75, -47, -123, 
	-48, -80, -48, -71, -48, -47, -75, -47, 
	-128, -48, -75, -48, -76, -47, -125, -48, 
	-68, -48, -66, -48, -78, -48, -80, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -122, -112, -108, -102, -99, 
	-97, -95, -94, -92, -81, 10, 10, 32, 
	-48, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -48, 10, 32, -69, 10, 
	-48, 10, -75, 10, -47, 10, -126, 10, 
	-48, 10, -80, 10, -48, 10, -70, 10, 
	-48, 10, -66, 10, -48, 10, -74, 10, 
	-48, 10, -80, 10, -48, 10, -67, 10, 
	-48, 10, -66, 10, -48, 10, -66, 10, 
	-48, 10, -69, 10, -48, 10, -72, 10, 
	-48, 10, -75, 10, -47, 10, -123, 10, 
	-48, 10, -80, 10, -48, 10, -71, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -65, 10, -47, 10, -125, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -48, 10, -68, 10, 
	-48, 10, -66, 10, 10, 32, 44, 10, 
	32, -47, 10, -119, 10, -47, 10, -126, 
	-122, 10, -47, 10, -128, 10, -47, 10, 
	-125, 10, -48, 10, -70, 10, -47, 10, 
	-126, 10, -47, 10, -125, 10, -47, 10, 
	-128, 10, -48, 10, -80, 10, 10, 32, 
	-47, 10, -127, 10, -47, 10, -122, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	-47, 10, -106, 10, -47, 10, -114, 10, 
	10, 58, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -47, 10, -106, 10, -48, 10, 
	-71, 10, -48, 10, -80, -66, 10, -48, 
	10, 32, -76, 10, -47, 10, -106, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-47, 10, -106, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, -48, 10, -70, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -128, -48, -72, -48, 
	-70, -65, -48, -69, -48, -80, -48, -76, 
	-48, -72, 58, 10, 10, -48, 10, 32, 
	35, 124, 9, 13, -92, 10, -47, 10, 
	-125, 10, -48, 10, -67, 10, -48, 10, 
	-70, 10, -47, 10, -122, 10, -47, 10, 
	-106, 10, -48, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, 10, 58, -47, -125, -47, -127, 
	-47, -126, -48, -72, -48, -68, -48, -66, 
	32, 44, 32, -47, -119, -47, -126, -122, 
	-47, -128, -47, -125, -48, -70, -47, -126, 
	-47, -125, -47, -128, -48, -80, 32, -47, 
	-127, -47, -122, -48, -75, -48, -67, -48, 
	-80, -47, -128, -47, -106, -47, -114, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -122, -112, -108, -102, -99, 
	-97, -95, -94, -92, -81, 10, 10, 32, 
	-48, 10, 32, -69, 10, -48, 10, -75, 
	10, -47, 10, -126, 10, -48, 10, -80, 
	10, -48, 10, -70, 10, -48, 10, -66, 
	10, -48, 10, -74, 10, -48, 10, -80, 
	10, -48, 10, -67, 10, -48, 10, -66, 
	10, -48, 10, -66, 10, -48, 10, -69, 
	10, -48, 10, -72, 10, -48, 10, -75, 
	10, -47, 10, -123, 10, -48, 10, -80, 
	10, -48, 10, -71, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -65, 
	10, -47, 10, -125, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -72, 
	10, -48, 10, -68, 10, -48, 10, -66, 
	10, 10, 32, 44, 10, 32, -47, 10, 
	-119, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -47, 10, 
	-106, 10, -48, 10, -71, 10, 10, 58, 
	-48, 10, -80, -66, 10, -48, 10, 32, 
	-76, 10, -47, 10, -106, 10, -47, 10, 
	-125, 10, -48, 10, -67, 10, -48, 10, 
	-70, 10, -47, 10, -122, 10, -47, 10, 
	-106, 10, -48, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, -48, 10, -70, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -48, -75, -48, -67, -48, -80, 
	-47, -128, -47, -106, -48, -71, 58, 10, 
	10, -48, 10, 32, 35, 37, 42, 64, 
	9, 13, -122, -112, -108, -102, -99, -97, 
	-95, -94, -92, -81, 10, 10, 32, -48, 
	10, 32, -69, 10, -48, 10, -75, 10, 
	-47, 10, -126, 10, -48, 10, -80, 10, 
	-48, 10, -70, 10, -48, 10, -66, 10, 
	-48, 10, -74, 10, -48, 10, -80, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-48, 10, -66, 10, -48, 10, -69, 10, 
	-48, 10, -72, 10, -48, 10, -75, 10, 
	-47, 10, -123, 10, -48, 10, -80, 10, 
	-48, 10, -71, 10, -48, -47, 10, -75, 
	10, -47, 10, -128, 10, -48, 10, -75, 
	10, -48, 10, -76, 10, -47, 10, -125, 
	10, -48, 10, -68, 10, -48, 10, -66, 
	10, -48, 10, -78, 10, -48, 10, -80, 
	10, 10, 58, -128, 10, -48, 10, -72, 
	10, -48, 10, -65, 10, -47, 10, -125, 
	10, -47, 10, -127, 10, -47, 10, -126, 
	10, -48, 10, -72, 10, -48, 10, -68, 
	10, -48, 10, -66, 10, 10, 32, 44, 
	10, 32, -47, 10, -119, 10, -47, 10, 
	-126, -122, 10, -47, 10, -128, 10, -47, 
	10, -125, 10, -48, 10, -70, 10, -47, 
	10, -126, 10, -47, 10, -125, 10, -47, 
	10, -128, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -47, 10, -106, 10, -47, 10, -114, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -47, 10, -106, 10, -48, 10, -71, 
	10, -48, 10, -80, -66, 10, -48, 10, 
	32, -76, 10, -47, 10, -106, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -47, 
	10, -106, 10, -48, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, -48, 10, -70, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -80, -66, -48, 32, 
	-76, -47, -106, -47, -125, -48, -67, -48, 
	-70, -47, -122, -47, -106, -48, -66, -48, 
	-67, -48, -80, -48, -69, 58, 10, 10, 
	-48, 10, 32, 35, 37, 64, 9, 13, 
	-97, -95, -92, 10, -48, -47, 10, -75, 
	10, -47, 10, -128, 10, -48, 10, -75, 
	10, -48, 10, -76, 10, -47, 10, -125, 
	10, -48, 10, -68, 10, -48, 10, -66, 
	10, -48, 10, -78, 10, -48, 10, -80, 
	10, 10, 58, -128, 10, -48, 10, -72, 
	10, -48, 10, -70, 10, -48, 10, -69, 
	10, -48, 10, -80, 10, -48, 10, -76, 
	10, -48, 10, -72, 10, -47, 10, -126, 
	-122, 10, -47, 10, -128, 10, -47, 10, 
	-125, 10, -48, 10, -70, 10, -47, 10, 
	-126, 10, -47, 10, -125, 10, -47, 10, 
	-128, 10, -48, 10, -80, 10, 10, 32, 
	-47, 10, -127, 10, -47, 10, -122, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	-47, 10, -106, 10, -47, 10, -114, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	-47, 10, -106, 10, -48, 10, -71, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-47, 10, -106, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-48, -70, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 10, 1, 1, 2, 9, 1, 
	1, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	9, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 11, 2, 9, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 11, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 11, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 6, 4, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 23, 25, 27, 30, 41, 
	43, 45, 49, 54, 59, 64, 69, 73, 
	77, 80, 82, 84, 86, 88, 90, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 115, 122, 127, 131, 137, 141, 144, 
	150, 161, 164, 166, 168, 170, 172, 174, 
	176, 178, 180, 182, 184, 186, 188, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 233, 235, 237, 239, 
	241, 243, 245, 247, 249, 251, 253, 255, 
	257, 259, 261, 263, 265, 267, 269, 271, 
	273, 282, 294, 297, 308, 312, 315, 318, 
	321, 324, 327, 330, 333, 336, 339, 342, 
	345, 348, 351, 354, 357, 360, 363, 366, 
	369, 372, 375, 378, 381, 384, 387, 390, 
	393, 396, 399, 402, 405, 408, 411, 414, 
	417, 420, 423, 426, 429, 432, 435, 438, 
	441, 444, 447, 450, 453, 456, 459, 462, 
	465, 469, 472, 475, 478, 481, 485, 488, 
	491, 494, 497, 500, 503, 506, 509, 512, 
	515, 518, 521, 524, 527, 530, 533, 536, 
	539, 542, 545, 548, 551, 554, 557, 560, 
	563, 566, 569, 572, 575, 578, 581, 584, 
	587, 590, 593, 596, 599, 602, 605, 608, 
	611, 614, 617, 620, 624, 628, 631, 634, 
	637, 640, 643, 646, 649, 652, 655, 658, 
	661, 664, 667, 670, 673, 676, 679, 682, 
	685, 688, 691, 694, 697, 700, 703, 706, 
	709, 712, 715, 718, 721, 724, 727, 730, 
	733, 736, 739, 741, 743, 745, 747, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 779, 782, 785, 788, 791, 
	794, 797, 800, 803, 806, 809, 812, 815, 
	818, 821, 824, 827, 830, 833, 836, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 866, 868, 870, 872, 
	874, 877, 879, 881, 883, 885, 887, 889, 
	891, 893, 895, 897, 899, 901, 903, 905, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	923, 925, 927, 929, 931, 933, 935, 937, 
	939, 941, 943, 945, 954, 966, 969, 973, 
	976, 979, 982, 985, 988, 991, 994, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1030, 1033, 1036, 1039, 1042, 1045, 
	1048, 1051, 1054, 1057, 1060, 1063, 1066, 1069, 
	1072, 1075, 1078, 1081, 1084, 1087, 1090, 1093, 
	1096, 1099, 1102, 1105, 1108, 1111, 1114, 1117, 
	1120, 1123, 1126, 1130, 1133, 1136, 1139, 1142, 
	1145, 1148, 1151, 1154, 1157, 1160, 1163, 1166, 
	1169, 1172, 1175, 1178, 1181, 1184, 1187, 1191, 
	1195, 1198, 1201, 1204, 1207, 1210, 1213, 1216, 
	1219, 1222, 1225, 1228, 1231, 1234, 1237, 1240, 
	1243, 1246, 1249, 1252, 1255, 1258, 1261, 1264, 
	1267, 1270, 1273, 1276, 1279, 1282, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1306, 1308, 1310, 
	1312, 1314, 1316, 1318, 1320, 1322, 1324, 1326, 
	1328, 1330, 1332, 1334, 1336, 1345, 1357, 1360, 
	1364, 1367, 1370, 1373, 1376, 1379, 1382, 1385, 
	1388, 1391, 1394, 1397, 1400, 1403, 1406, 1409, 
	1412, 1415, 1418, 1421, 1424, 1427, 1430, 1433, 
	1436, 1439, 1442, 1445, 1448, 1451, 1454, 1457, 
	1460, 1463, 1467, 1470, 1473, 1476, 1479, 1482, 
	1485, 1488, 1491, 1494, 1497, 1500, 1503, 1506, 
	1509, 1512, 1515, 1518, 1521, 1524, 1527, 1530, 
	1533, 1536, 1539, 1542, 1545, 1548, 1551, 1554, 
	1557, 1560, 1563, 1566, 1569, 1572, 1576, 1579, 
	1582, 1585, 1588, 1592, 1595, 1598, 1601, 1604, 
	1607, 1610, 1613, 1616, 1619, 1622, 1625, 1628, 
	1631, 1634, 1637, 1640, 1643, 1646, 1649, 1652, 
	1655, 1658, 1661, 1664, 1667, 1670, 1673, 1676, 
	1679, 1682, 1685, 1688, 1691, 1694, 1697, 1700, 
	1703, 1706, 1709, 1712, 1715, 1718, 1721, 1724, 
	1728, 1732, 1735, 1738, 1741, 1744, 1747, 1750, 
	1753, 1756, 1759, 1762, 1765, 1768, 1771, 1774, 
	1777, 1780, 1783, 1786, 1789, 1792, 1795, 1798, 
	1801, 1804, 1807, 1810, 1813, 1816, 1819, 1822, 
	1825, 1828, 1831, 1834, 1837, 1840, 1843, 1845, 
	1848, 1851, 1853, 1855, 1857, 1859, 1861, 1863, 
	1865, 1867, 1869, 1871, 1873, 1875, 1877, 1879, 
	1881, 1883, 1885, 1887, 1889, 1891, 1893, 1895, 
	1897, 1899, 1907, 1912, 1916, 1919, 1922, 1925, 
	1928, 1931, 1934, 1937, 1940, 1943, 1946, 1949, 
	1952, 1955, 1958, 1961, 1964, 1967, 1970, 1973, 
	1976, 1979, 1982, 1985, 1988, 1991, 1994, 1997, 
	2000, 2003, 2006, 2009, 2012, 2016, 2019, 2022, 
	2025, 2028, 2031, 2034, 2037, 2040, 2043, 2046, 
	2049, 2052, 2055, 2058, 2061, 2064, 2067, 2070, 
	2073, 2076, 2079, 2082, 2085, 2088, 2091, 2094, 
	2097, 2100, 2103, 2106, 2109, 2112, 2115, 2118, 
	2121, 2124, 2127, 2130, 2133, 2136, 2139, 2142, 
	2145, 2148, 2151, 2154, 2157, 2160, 2163, 2166, 
	2169, 2172, 2175, 2178, 2181, 2184, 2187, 2190, 
	2193, 2196, 2199, 2202, 2205, 2208, 2211, 2214, 
	2217, 2220, 2223, 2226, 2229, 2232, 2235, 2238, 
	2241, 2243, 2245, 2247, 2249
};

static const short _lexer_trans_targs[] = {
	2, 762, 6, 6, 7, 16, 18, 3, 
	32, 35, 6, 0, 3, 41, 55, 61, 
	67, 75, 295, 622, 628, 760, 0, 4, 
	0, 0, 5, 6, 17, 5, 2, 6, 
	6, 7, 16, 18, 3, 32, 35, 6, 
	0, 8, 0, 9, 0, 10, 9, 9, 
	0, 11, 11, 12, 11, 11, 11, 11, 
	12, 11, 11, 11, 11, 13, 11, 11, 
	11, 11, 14, 11, 11, 6, 15, 15, 
	0, 6, 15, 15, 0, 6, 17, 16, 
	6, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 764, 0, 0, 0, 
	0, 0, 33, 34, 6, 34, 34, 32, 
	33, 33, 6, 34, 32, 34, 0, 35, 
	36, 35, 0, 40, 39, 38, 36, 39, 
	37, 0, 38, 36, 37, 0, 38, 37, 
	40, 39, 38, 36, 39, 37, 2, 40, 
	40, 7, 16, 18, 3, 32, 35, 40, 
	0, 42, 45, 0, 43, 0, 44, 0, 
	3, 0, 46, 0, 47, 0, 48, 0, 
	49, 0, 50, 0, 51, 0, 52, 0, 
	53, 0, 54, 0, 3, 0, 56, 0, 
	57, 0, 58, 0, 59, 0, 60, 0, 
	3, 0, 62, 0, 63, 0, 64, 0, 
	65, 0, 66, 0, 3, 0, 68, 0, 
	69, 0, 70, 0, 71, 0, 72, 0, 
	73, 0, 74, 0, 3, 0, 76, 242, 
	0, 77, 0, 78, 0, 79, 0, 80, 
	0, 81, 0, 82, 0, 83, 0, 84, 
	0, 85, 0, 86, 0, 87, 0, 88, 
	0, 89, 0, 90, 0, 91, 0, 92, 
	0, 93, 0, 94, 0, 96, 95, 96, 
	95, 97, 96, 96, 6, 228, 98, 6, 
	96, 95, 98, 100, 114, 120, 126, 134, 
	156, 202, 208, 226, 96, 95, 96, 99, 
	95, 2, 6, 6, 7, 16, 18, 3, 
	32, 35, 6, 0, 101, 96, 104, 95, 
	102, 96, 95, 103, 96, 95, 98, 96, 
	95, 105, 96, 95, 106, 96, 95, 107, 
	96, 95, 108, 96, 95, 109, 96, 95, 
	110, 96, 95, 111, 96, 95, 112, 96, 
	95, 113, 96, 95, 98, 96, 95, 115, 
	96, 95, 116, 96, 95, 117, 96, 95, 
	118, 96, 95, 119, 96, 95, 98, 96, 
	95, 121, 96, 95, 122, 96, 95, 123, 
	96, 95, 124, 96, 95, 125, 96, 95, 
	98, 96, 95, 127, 96, 95, 128, 96, 
	95, 129, 96, 95, 130, 96, 95, 131, 
	96, 95, 132, 96, 95, 133, 96, 95, 
	98, 96, 95, 135, 96, 95, 136, 96, 
	95, 137, 96, 95, 138, 96, 95, 139, 
	96, 95, 140, 96, 95, 141, 96, 95, 
	142, 96, 95, 143, 96, 95, 144, 96, 
	95, 145, 96, 95, 146, 96, 95, 147, 
	96, 95, 148, 96, 95, 149, 96, 95, 
	150, 96, 95, 151, 96, 95, 152, 96, 
	95, 96, 99, 153, 95, 96, 154, 95, 
	155, 96, 95, 118, 96, 95, 157, 96, 
	95, 158, 190, 96, 95, 159, 96, 95, 
	160, 96, 95, 161, 96, 95, 162, 96, 
	95, 163, 96, 95, 164, 96, 95, 165, 
	96, 95, 166, 96, 95, 167, 96, 95, 
	168, 96, 95, 169, 96, 95, 170, 96, 
	95, 171, 96, 95, 172, 96, 95, 96, 
	173, 95, 174, 96, 95, 175, 96, 95, 
	176, 96, 95, 177, 96, 95, 178, 96, 
	95, 179, 96, 95, 180, 96, 95, 181, 
	96, 95, 182, 96, 95, 183, 96, 95, 
	184, 96, 95, 185, 96, 95, 186, 96, 
	95, 187, 96, 95, 188, 96, 95, 189, 
	96, 95, 96, 99, 95, 191, 96, 95, 
	192, 96, 95, 193, 96, 95, 194, 96, 
	95, 195, 96, 95, 196, 96, 95, 197, 
	96, 95, 198, 96, 95, 199, 96, 95, 
	200, 96, 95, 201, 96, 95, 189, 96, 
	95, 203, 96, 95, 98, 204, 96, 95, 
	205, 96, 99, 95, 206, 96, 95, 207, 
	96, 95, 98, 96, 95, 209, 96, 95, 
	210, 96, 95, 211, 96, 95, 212, 96, 
	95, 213, 96, 95, 214, 96, 95, 215, 
	96, 95, 216, 96, 95, 217, 96, 95, 
	218, 96, 95, 219, 96, 95, 220, 96, 
	95, 221, 96, 95, 222, 96, 95, 223, 
	96, 95, 224, 96, 95, 225, 96, 95, 
	189, 96, 95, 227, 96, 95, 154, 96, 
	95, 96, 229, 95, 96, 230, 95, 96, 
	231, 95, 96, 232, 95, 96, 233, 95, 
	96, 234, 95, 96, 235, 95, 96, 236, 
	95, 96, 237, 95, 96, 238, 95, 96, 
	239, 95, 96, 240, 95, 96, 241, 95, 
	96, 6, 95, 243, 0, 244, 0, 245, 
	0, 246, 0, 247, 279, 0, 248, 0, 
	249, 0, 250, 0, 251, 0, 252, 0, 
	253, 0, 254, 0, 255, 0, 256, 0, 
	258, 257, 258, 257, 259, 258, 258, 6, 
	6, 258, 257, 260, 258, 257, 261, 258, 
	257, 262, 258, 257, 263, 258, 257, 264, 
	258, 257, 265, 258, 257, 266, 258, 257, 
	267, 258, 257, 268, 258, 257, 269, 258, 
	257, 270, 258, 257, 271, 258, 257, 272, 
	258, 257, 273, 258, 257, 274, 258, 257, 
	275, 258, 257, 276, 258, 257, 277, 258, 
	257, 278, 258, 257, 258, 99, 257, 280, 
	0, 281, 0, 282, 0, 283, 0, 284, 
	0, 285, 0, 286, 0, 287, 0, 288, 
	0, 289, 0, 290, 0, 291, 0, 4, 
	292, 0, 293, 0, 294, 0, 59, 0, 
	296, 0, 297, 445, 0, 298, 0, 299, 
	0, 300, 0, 301, 0, 302, 0, 303, 
	0, 304, 0, 305, 0, 306, 0, 307, 
	0, 308, 0, 309, 0, 310, 0, 311, 
	0, 312, 0, 313, 0, 314, 0, 315, 
	0, 316, 0, 317, 0, 318, 0, 319, 
	0, 320, 0, 321, 0, 322, 0, 323, 
	0, 324, 0, 325, 0, 326, 0, 327, 
	0, 328, 0, 329, 0, 331, 330, 331, 
	330, 332, 331, 331, 6, 431, 333, 6, 
	331, 330, 333, 334, 348, 354, 360, 368, 
	390, 405, 411, 429, 331, 330, 331, 99, 
	330, 335, 331, 338, 330, 336, 331, 330, 
	337, 331, 330, 333, 331, 330, 339, 331, 
	330, 340, 331, 330, 341, 331, 330, 342, 
	331, 330, 343, 331, 330, 344, 331, 330, 
	345, 331, 330, 346, 331, 330, 347, 331, 
	330, 333, 331, 330, 349, 331, 330, 350, 
	331, 330, 351, 331, 330, 352, 331, 330, 
	353, 331, 330, 333, 331, 330, 355, 331, 
	330, 356, 331, 330, 357, 331, 330, 358, 
	331, 330, 359, 331, 330, 333, 331, 330, 
	361, 331, 330, 362, 331, 330, 363, 331, 
	330, 364, 331, 330, 365, 331, 330, 366, 
	331, 330, 367, 331, 330, 333, 331, 330, 
	369, 331, 330, 370, 331, 330, 371, 331, 
	330, 372, 331, 330, 373, 331, 330, 374, 
	331, 330, 375, 331, 330, 376, 331, 330, 
	377, 331, 330, 378, 331, 330, 379, 331, 
	330, 380, 331, 330, 381, 331, 330, 382, 
	331, 330, 383, 331, 330, 384, 331, 330, 
	385, 331, 330, 386, 331, 330, 331, 99, 
	387, 330, 331, 388, 330, 389, 331, 330, 
	352, 331, 330, 391, 331, 330, 392, 331, 
	330, 393, 331, 330, 394, 331, 330, 395, 
	331, 330, 396, 331, 330, 397, 331, 330, 
	398, 331, 330, 399, 331, 330, 400, 331, 
	330, 401, 331, 330, 402, 331, 330, 403, 
	331, 330, 404, 331, 330, 331, 99, 330, 
	406, 331, 330, 333, 407, 331, 330, 408, 
	331, 99, 330, 409, 331, 330, 410, 331, 
	330, 333, 331, 330, 412, 331, 330, 413, 
	331, 330, 414, 331, 330, 415, 331, 330, 
	416, 331, 330, 417, 331, 330, 418, 331, 
	330, 419, 331, 330, 420, 331, 330, 421, 
	331, 330, 422, 331, 330, 423, 331, 330, 
	424, 331, 330, 425, 331, 330, 426, 331, 
	330, 427, 331, 330, 428, 331, 330, 404, 
	331, 330, 430, 331, 330, 388, 331, 330, 
	331, 432, 330, 331, 433, 330, 331, 434, 
	330, 331, 435, 330, 331, 436, 330, 331, 
	437, 330, 331, 438, 330, 331, 439, 330, 
	331, 440, 330, 331, 441, 330, 331, 442, 
	330, 331, 443, 330, 331, 444, 330, 331, 
	6, 330, 446, 0, 447, 0, 448, 0, 
	449, 0, 450, 0, 451, 0, 452, 0, 
	453, 0, 454, 0, 455, 0, 456, 0, 
	457, 0, 458, 0, 460, 459, 460, 459, 
	461, 460, 460, 6, 608, 462, 6, 460, 
	459, 462, 463, 477, 483, 489, 497, 537, 
	582, 588, 606, 460, 459, 460, 99, 459, 
	464, 460, 467, 459, 465, 460, 459, 466, 
	460, 459, 462, 460, 459, 468, 460, 459, 
	469, 460, 459, 470, 460, 459, 471, 460, 
	459, 472, 460, 459, 473, 460, 459, 474, 
	460, 459, 475, 460, 459, 476, 460, 459, 
	462, 460, 459, 478, 460, 459, 479, 460, 
	459, 480, 460, 459, 481, 460, 459, 482, 
	460, 459, 462, 460, 459, 484, 460, 459, 
	485, 460, 459, 486, 460, 459, 487, 460, 
	459, 488, 460, 459, 462, 460, 459, 490, 
	460, 459, 491, 460, 459, 492, 460, 459, 
	493, 460, 459, 494, 460, 459, 495, 460, 
	459, 496, 460, 459, 462, 460, 459, 498, 
	516, 460, 459, 499, 460, 459, 500, 460, 
	459, 501, 460, 459, 502, 460, 459, 503, 
	460, 459, 504, 460, 459, 505, 460, 459, 
	506, 460, 459, 507, 460, 459, 508, 460, 
	459, 509, 460, 459, 510, 460, 459, 511, 
	460, 459, 512, 460, 459, 513, 460, 459, 
	514, 460, 459, 515, 460, 459, 460, 99, 
	459, 517, 460, 459, 518, 460, 459, 519, 
	460, 459, 520, 460, 459, 521, 460, 459, 
	522, 460, 459, 523, 460, 459, 524, 460, 
	459, 525, 460, 459, 526, 460, 459, 527, 
	460, 459, 528, 460, 459, 529, 460, 459, 
	530, 460, 459, 531, 460, 459, 532, 460, 
	459, 533, 460, 459, 460, 99, 534, 459, 
	460, 535, 459, 536, 460, 459, 481, 460, 
	459, 538, 460, 459, 539, 570, 460, 459, 
	540, 460, 459, 541, 460, 459, 542, 460, 
	459, 543, 460, 459, 544, 460, 459, 545, 
	460, 459, 546, 460, 459, 547, 460, 459, 
	548, 460, 459, 549, 460, 459, 550, 460, 
	459, 551, 460, 459, 552, 460, 459, 553, 
	460, 459, 460, 554, 459, 555, 460, 459, 
	556, 460, 459, 557, 460, 459, 558, 460, 
	459, 559, 460, 459, 560, 460, 459, 561, 
	460, 459, 562, 460, 459, 563, 460, 459, 
	564, 460, 459, 565, 460, 459, 566, 460, 
	459, 567, 460, 459, 568, 460, 459, 569, 
	460, 459, 515, 460, 459, 571, 460, 459, 
	572, 460, 459, 573, 460, 459, 574, 460, 
	459, 575, 460, 459, 576, 460, 459, 577, 
	460, 459, 578, 460, 459, 579, 460, 459, 
	580, 460, 459, 581, 460, 459, 515, 460, 
	459, 583, 460, 459, 462, 584, 460, 459, 
	585, 460, 99, 459, 586, 460, 459, 587, 
	460, 459, 462, 460, 459, 589, 460, 459, 
	590, 460, 459, 591, 460, 459, 592, 460, 
	459, 593, 460, 459, 594, 460, 459, 595, 
	460, 459, 596, 460, 459, 597, 460, 459, 
	598, 460, 459, 599, 460, 459, 600, 460, 
	459, 601, 460, 459, 602, 460, 459, 603, 
	460, 459, 604, 460, 459, 605, 460, 459, 
	515, 460, 459, 607, 460, 459, 535, 460, 
	459, 460, 609, 459, 460, 610, 459, 460, 
	611, 459, 460, 612, 459, 460, 613, 459, 
	460, 614, 459, 460, 615, 459, 460, 616, 
	459, 460, 617, 459, 460, 618, 459, 460, 
	619, 459, 460, 620, 459, 460, 621, 459, 
	460, 6, 459, 623, 0, 3, 624, 0, 
	625, 4, 0, 626, 0, 627, 0, 3, 
	0, 629, 0, 630, 0, 631, 0, 632, 
	0, 633, 0, 634, 0, 635, 0, 636, 
	0, 637, 0, 638, 0, 639, 0, 640, 
	0, 641, 0, 642, 0, 643, 0, 644, 
	0, 645, 0, 646, 0, 647, 0, 649, 
	648, 649, 648, 650, 649, 649, 6, 746, 
	6, 649, 648, 651, 683, 728, 649, 648, 
	652, 670, 649, 648, 653, 649, 648, 654, 
	649, 648, 655, 649, 648, 656, 649, 648, 
	657, 649, 648, 658, 649, 648, 659, 649, 
	648, 660, 649, 648, 661, 649, 648, 662, 
	649, 648, 663, 649, 648, 664, 649, 648, 
	665, 649, 648, 666, 649, 648, 667, 649, 
	648, 668, 649, 648, 669, 649, 648, 649, 
	99, 648, 671, 649, 648, 672, 649, 648, 
	673, 649, 648, 674, 649, 648, 675, 649, 
	648, 676, 649, 648, 677, 649, 648, 678, 
	649, 648, 679, 649, 648, 680, 649, 648, 
	681, 649, 648, 682, 649, 648, 669, 649, 
	648, 684, 649, 648, 685, 716, 649, 648, 
	686, 649, 648, 687, 649, 648, 688, 649, 
	648, 689, 649, 648, 690, 649, 648, 691, 
	649, 648, 692, 649, 648, 693, 649, 648, 
	694, 649, 648, 695, 649, 648, 696, 649, 
	648, 697, 649, 648, 698, 649, 648, 699, 
	649, 648, 649, 700, 648, 701, 649, 648, 
	702, 649, 648, 703, 649, 648, 704, 649, 
	648, 705, 649, 648, 706, 649, 648, 707, 
	649, 648, 708, 649, 648, 709, 649, 648, 
	710, 649, 648, 711, 649, 648, 712, 649, 
	648, 713, 649, 648, 714, 649, 648, 715, 
	649, 648, 669, 649, 648, 717, 649, 648, 
	718, 649, 648, 719, 649, 648, 720, 649, 
	648, 721, 649, 648, 722, 649, 648, 723, 
	649, 648, 724, 649, 648, 725, 649, 648, 
	726, 649, 648, 727, 649, 648, 669, 649, 
	648, 729, 649, 648, 730, 649, 648, 731, 
	649, 648, 732, 649, 648, 733, 649, 648, 
	734, 649, 648, 735, 649, 648, 736, 649, 
	648, 737, 649, 648, 738, 649, 648, 739, 
	649, 648, 740, 649, 648, 741, 649, 648, 
	742, 649, 648, 743, 649, 648, 744, 649, 
	648, 745, 649, 648, 669, 649, 648, 649, 
	747, 648, 649, 748, 648, 649, 749, 648, 
	649, 750, 648, 649, 751, 648, 649, 752, 
	648, 649, 753, 648, 649, 754, 648, 649, 
	755, 648, 649, 756, 648, 649, 757, 648, 
	649, 758, 648, 649, 759, 648, 649, 6, 
	648, 761, 0, 293, 0, 763, 0, 6, 
	0, 0, 0
};

static const char _lexer_trans_actions[] = {
	25, 0, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 39, 0, 
	39, 39, 50, 99, 19, 0, 25, 47, 
	0, 5, 1, 0, 25, 1, 31, 0, 
	39, 0, 39, 0, 39, 47, 0, 0, 
	39, 119, 41, 41, 41, 3, 111, 29, 
	29, 29, 0, 111, 29, 29, 29, 0, 
	111, 29, 0, 29, 0, 95, 7, 7, 
	39, 47, 0, 0, 39, 103, 21, 0, 
	47, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 39, 39, 
	39, 39, 0, 23, 107, 23, 23, 44, 
	23, 0, 47, 0, 1, 0, 39, 0, 
	0, 0, 39, 47, 33, 33, 80, 33, 
	33, 39, 0, 35, 0, 39, 0, 0, 
	47, 0, 0, 35, 0, 0, 89, 47, 
	0, 86, 83, 37, 89, 83, 92, 0, 
	39, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 77, 47, 0, 65, 29, 77, 65, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 47, 11, 
	0, 56, 115, 27, 53, 50, 27, 56, 
	50, 59, 27, 39, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 11, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 11, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 11, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 11, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 77, 47, 0, 74, 
	74, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 17, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 77, 47, 0, 71, 29, 77, 71, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 47, 15, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 15, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 15, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 15, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	15, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 124, 50, 47, 0, 
	77, 47, 0, 68, 29, 77, 68, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 47, 0, 47, 13, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 13, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 13, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 13, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 13, 0, 0, 39, 0, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 62, 29, 
	62, 0, 0, 0, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	9, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 9, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 764;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1537 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
    
#line 1544 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1820 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1883 "ext/gherkin_lexer_uk/gherkin_lexer_uk.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/uk.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_uk()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Uk", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

