
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 20, 21, 22, 41, 42, 43, 
	47, 52, 57, 62, 67, 71, 75, 77, 
	78, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 92, 93, 
	94, 96, 101, 108, 113, 114, 115, 116, 
	117, 118, 119, 120, 121, 122, 123, 124, 
	125, 126, 127, 128, 129, 130, 131, 144, 
	146, 148, 150, 152, 154, 156, 158, 160, 
	162, 164, 166, 168, 170, 172, 174, 176, 
	178, 180, 182, 184, 186, 188, 190, 192, 
	194, 196, 198, 200, 219, 221, 222, 224, 
	225, 227, 228, 229, 230, 231, 232, 233, 
	250, 252, 254, 256, 258, 260, 262, 264, 
	266, 268, 270, 272, 274, 276, 278, 280, 
	282, 284, 286, 288, 290, 292, 294, 296, 
	298, 300, 302, 304, 306, 308, 310, 312, 
	314, 316, 319, 321, 323, 325, 328, 330, 
	333, 335, 337, 339, 341, 343, 345, 347, 
	349, 351, 353, 355, 357, 359, 361, 363, 
	365, 367, 369, 371, 373, 376, 378, 380, 
	383, 385, 387, 388, 389, 390, 391, 392, 
	393, 394, 411, 413, 415, 417, 419, 421, 
	423, 425, 427, 429, 431, 433, 435, 437, 
	439, 441, 443, 445, 447, 449, 451, 453, 
	455, 457, 459, 461, 463, 465, 467, 469, 
	471, 473, 476, 478, 481, 483, 485, 487, 
	489, 491, 493, 495, 498, 500, 503, 505, 
	507, 509, 511, 513, 515, 517, 519, 521, 
	523, 525, 527, 531, 533, 535, 537, 539, 
	541, 543, 545, 547, 549, 551, 553, 555, 
	557, 559, 561, 563, 565, 567, 569, 571, 
	573, 575, 577, 579, 581, 584, 586, 588, 
	591, 593, 595, 596, 597, 598, 600, 601, 
	603, 604, 605, 607, 608, 609, 610, 611, 
	612, 613, 614, 616, 617, 618, 619, 620, 
	621, 622, 623, 624, 625, 627, 628, 629, 
	646, 648, 650, 652, 654, 656, 658, 660, 
	662, 664, 666, 668, 670, 672, 674, 676, 
	678, 680, 682, 684, 686, 688, 690, 692, 
	694, 696, 698, 700, 702, 704, 706, 708, 
	711, 713, 716, 718, 721, 723, 725, 727, 
	729, 731, 733, 735, 738, 740, 743, 745, 
	747, 750, 752, 754, 756, 758, 760, 762, 
	765, 767, 769, 771, 773, 775, 777, 779, 
	783, 785, 787, 789, 791, 793, 795, 797, 
	799, 801, 803, 805, 807, 809, 811, 813, 
	815, 817, 819, 821, 823, 825, 827, 829, 
	831, 833, 836, 838, 840, 843, 845, 847, 
	848, 849, 850, 859, 861, 863, 865, 867, 
	869, 871, 873, 875, 877, 879, 881, 883, 
	885, 887, 889, 891, 893, 896, 898, 900, 
	902, 904, 906, 908, 910, 913, 914, 915, 
	916, 917, 918, 920, 921, 922, 923, 924, 
	925, 926, 927, 928, 929, 930, 931, 932, 
	933, 934, 935, 936, 937, 938, 939, 940, 
	941, 942, 944, 945, 946, 948, 949, 950, 
	954, 960, 963, 965, 971, 990, 992, 994, 
	997, 999, 1001, 1003, 1005, 1007, 1009, 1011, 
	1014, 1016, 1018, 1021, 1023, 1025, 1027, 1029, 
	1031, 1033, 1036, 1038, 1040, 1042, 1044, 1046, 
	1048, 1050, 1053, 1057, 1059, 1061, 1063, 1065, 
	1067, 1070, 1072, 1074, 1076, 1078, 1080, 1082, 
	1084, 1086, 1088, 1090, 1092, 1094, 1096, 1098, 
	1100, 1102, 1104, 1106, 1108
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 73, 75, 77, 79, 80, 83, 
	90, 124, 9, 13, -69, -65, 10, 32, 
	34, 35, 37, 42, 64, 65, 70, 73, 
	75, 77, 79, 80, 83, 90, 124, 9, 
	13, 34, 34, 10, 32, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 10, 10, 13, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 108, 105, 117, 110, 107, 99, 105, 
	111, 110, 97, 108, 110, 111, 115, 116, 
	58, 10, 10, 10, 32, 35, 37, 64, 
	70, 75, 77, 79, 80, 83, 9, 13, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 117, 10, 110, 
	10, 107, 10, 99, 10, 105, 10, 111, 
	10, 110, 10, 97, 10, 108, 10, 110, 
	10, 111, 10, 115, 10, 116, 10, 58, 
	10, 32, 34, 35, 37, 42, 64, 65, 
	70, 73, 75, 77, 79, 80, 83, 90, 
	124, 9, 13, 97, 111, 100, 32, 97, 
	110, 99, 116, 101, 112, 116, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	70, 73, 75, 77, 79, 80, 83, 90, 
	9, 13, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, 10, 32, 
	10, 108, 10, 105, 10, 117, 10, 110, 
	10, 107, 10, 99, 10, 105, 10, 111, 
	10, 110, 10, 97, 10, 108, 10, 110, 
	10, 111, 10, 115, 10, 116, 10, 58, 
	10, 97, 10, 100, 10, 32, 97, 10, 
	111, 10, 103, 10, 117, -60, 10, 99, 
	-121, 10, 10, 110, 115, 10, 100, 10, 
	97, 10, 111, 10, 98, 10, 105, 10, 
	110, 10, 97, 10, 114, 10, 105, 10, 
	109, 10, 101, 10, 114, 10, 99, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 111, 10, 97, 10, 100, 116, 
	10, 97, 10, 116, 10, 101, 111, 10, 
	97, 10, 116, 101, 107, 115, 116, 58, 
	10, 10, 10, 32, 35, 37, 42, 64, 
	65, 70, 73, 75, 77, 79, 80, 83, 
	90, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 10, 108, 10, 105, 10, 117, 10, 
	110, 10, 107, 10, 99, 10, 105, 10, 
	111, 10, 110, 10, 97, 10, 108, 10, 
	110, 10, 111, 10, 115, 10, 116, 10, 
	58, 10, 97, 111, 10, 100, 10, 32, 
	97, 10, 110, 10, 99, 10, 101, 10, 
	112, 10, 111, 10, 103, 10, 117, -60, 
	10, 99, -121, 10, 10, 110, 115, 10, 
	100, 10, 97, 10, 111, 10, 98, 10, 
	105, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 109, 10, 101, 10, 114, 10, 
	99, 107, 116, 10, 101, 10, 110, 10, 
	97, 10, 114, 10, 105, 10, 111, 10, 
	105, 10, 99, 10, 114, 10, 117, 10, 
	107, 10, 116, 10, 117, 10, 114, 10, 
	97, 10, 32, 10, 115, 10, 99, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 106, 10, 97, 10, 100, 116, 
	10, 97, 10, 116, 10, 101, 111, 10, 
	97, 10, 116, 111, 103, 117, -60, 99, 
	-121, 110, 115, 100, 97, 110, 111, 111, 
	118, 97, 98, 105, 110, 97, 111, 114, 
	122, 97, 100, 105, 110, 105, 109, 101, 
	114, 58, 105, 10, 10, 10, 32, 35, 
	37, 42, 64, 65, 70, 73, 75, 77, 
	79, 80, 83, 90, 9, 13, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, 10, 108, 10, 105, 
	10, 117, 10, 110, 10, 107, 10, 99, 
	10, 105, 10, 111, 10, 110, 10, 97, 
	10, 108, 10, 110, 10, 111, 10, 115, 
	10, 116, 10, 58, 10, 97, 111, 10, 
	100, 10, 32, 97, 10, 110, 10, 99, 
	116, 10, 101, 10, 112, 10, 101, 10, 
	107, 10, 111, 10, 103, 10, 117, -60, 
	10, 99, -121, 10, 10, 110, 115, 10, 
	100, 10, 97, 10, 110, 111, 10, 111, 
	10, 118, 10, 97, 10, 98, 10, 105, 
	10, 110, 10, 111, 114, 10, 122, 10, 
	97, 10, 100, 10, 105, 10, 109, 10, 
	101, 10, 114, 10, 99, 107, 116, 10, 
	101, 10, 110, 10, 97, 10, 114, 10, 
	105, 10, 111, 10, 105, 10, 99, 10, 
	114, 10, 117, 10, 107, 10, 116, 10, 
	117, 10, 114, 10, 97, 10, 32, 10, 
	115, 10, 99, 10, 101, 10, 110, 10, 
	97, 10, 114, 10, 105, 10, 106, 10, 
	97, 10, 100, 116, 10, 97, 10, 116, 
	10, 101, 111, 10, 97, 10, 116, 58, 
	10, 10, 10, 32, 35, 70, 77, 79, 
	124, 9, 13, 10, 117, 10, 110, 10, 
	107, 10, 99, 10, 105, 10, 111, 10, 
	110, 10, 97, 10, 108, 10, 110, 10, 
	111, 10, 115, 10, 116, 10, 58, 10, 
	111, 10, 103, 10, 117, -60, 10, 99, 
	-121, 10, 10, 115, 10, 111, 10, 98, 
	10, 105, 10, 110, 10, 97, 99, 107, 
	116, 101, 110, 97, 114, 105, 106, 111, 
	105, 58, 105, 99, 97, 114, 117, 107, 
	116, 117, 114, 97, 32, 115, 99, 101, 
	110, 97, 114, 105, 106, 97, 100, 116, 
	97, 116, 101, 111, 97, 116, 32, 124, 
	9, 13, 10, 32, 92, 124, 9, 13, 
	10, 92, 124, 10, 92, 10, 32, 92, 
	124, 9, 13, 10, 32, 34, 35, 37, 
	42, 64, 65, 70, 73, 75, 77, 79, 
	80, 83, 90, 124, 9, 13, 10, 111, 
	10, 110, 10, 99, 116, 10, 101, 10, 
	112, 10, 101, 10, 107, 10, 111, 10, 
	103, 10, 117, -60, 10, 99, -121, 10, 
	10, 115, 10, 110, 111, 10, 111, 10, 
	118, 10, 97, 10, 98, 10, 105, 10, 
	110, 10, 111, 114, 10, 122, 10, 97, 
	10, 100, 10, 105, 10, 109, 10, 101, 
	10, 114, 10, 58, 105, 10, 99, 107, 
	116, 10, 101, 10, 110, 10, 97, 10, 
	114, 10, 105, 10, 106, 111, 10, 105, 
	10, 105, 10, 99, 10, 114, 10, 117, 
	10, 107, 10, 116, 10, 117, 10, 114, 
	10, 97, 10, 32, 10, 115, 10, 99, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 106, 0
};

static const char _lexer_single_lengths[] = {
	0, 18, 1, 1, 17, 1, 1, 2, 
	3, 3, 3, 3, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 3, 5, 3, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 11, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 17, 2, 1, 2, 1, 
	2, 1, 1, 1, 1, 1, 1, 15, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 3, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 3, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 15, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 4, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 3, 
	2, 2, 1, 1, 1, 2, 1, 2, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 15, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 3, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 3, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 3, 2, 2, 1, 
	1, 1, 7, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 3, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 1, 2, 1, 1, 2, 
	4, 3, 2, 4, 17, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 3, 4, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 1, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 20, 22, 24, 43, 45, 47, 
	51, 56, 61, 66, 71, 75, 79, 82, 
	84, 86, 88, 90, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 119, 124, 131, 136, 138, 140, 142, 
	144, 146, 148, 150, 152, 154, 156, 158, 
	160, 162, 164, 166, 168, 170, 172, 185, 
	188, 191, 194, 197, 200, 203, 206, 209, 
	212, 215, 218, 221, 224, 227, 230, 233, 
	236, 239, 242, 245, 248, 251, 254, 257, 
	260, 263, 266, 269, 288, 291, 293, 296, 
	298, 301, 303, 305, 307, 309, 311, 313, 
	330, 333, 336, 339, 342, 345, 348, 351, 
	354, 357, 360, 363, 366, 369, 372, 375, 
	378, 381, 384, 387, 390, 393, 396, 399, 
	402, 405, 408, 411, 414, 417, 420, 423, 
	426, 429, 433, 436, 439, 442, 446, 449, 
	453, 456, 459, 462, 465, 468, 471, 474, 
	477, 480, 483, 486, 489, 492, 495, 498, 
	501, 504, 507, 510, 513, 517, 520, 523, 
	527, 530, 533, 535, 537, 539, 541, 543, 
	545, 547, 564, 567, 570, 573, 576, 579, 
	582, 585, 588, 591, 594, 597, 600, 603, 
	606, 609, 612, 615, 618, 621, 624, 627, 
	630, 633, 636, 639, 642, 645, 648, 651, 
	654, 657, 661, 664, 668, 671, 674, 677, 
	680, 683, 686, 689, 693, 696, 700, 703, 
	706, 709, 712, 715, 718, 721, 724, 727, 
	730, 733, 736, 741, 744, 747, 750, 753, 
	756, 759, 762, 765, 768, 771, 774, 777, 
	780, 783, 786, 789, 792, 795, 798, 801, 
	804, 807, 810, 813, 816, 820, 823, 826, 
	830, 833, 836, 838, 840, 842, 845, 847, 
	850, 852, 854, 857, 859, 861, 863, 865, 
	867, 869, 871, 874, 876, 878, 880, 882, 
	884, 886, 888, 890, 892, 895, 897, 899, 
	916, 919, 922, 925, 928, 931, 934, 937, 
	940, 943, 946, 949, 952, 955, 958, 961, 
	964, 967, 970, 973, 976, 979, 982, 985, 
	988, 991, 994, 997, 1000, 1003, 1006, 1009, 
	1013, 1016, 1020, 1023, 1027, 1030, 1033, 1036, 
	1039, 1042, 1045, 1048, 1052, 1055, 1059, 1062, 
	1065, 1069, 1072, 1075, 1078, 1081, 1084, 1087, 
	1091, 1094, 1097, 1100, 1103, 1106, 1109, 1112, 
	1117, 1120, 1123, 1126, 1129, 1132, 1135, 1138, 
	1141, 1144, 1147, 1150, 1153, 1156, 1159, 1162, 
	1165, 1168, 1171, 1174, 1177, 1180, 1183, 1186, 
	1189, 1192, 1196, 1199, 1202, 1206, 1209, 1212, 
	1214, 1216, 1218, 1227, 1230, 1233, 1236, 1239, 
	1242, 1245, 1248, 1251, 1254, 1257, 1260, 1263, 
	1266, 1269, 1272, 1275, 1278, 1282, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1307, 1309, 1311, 
	1313, 1315, 1317, 1320, 1322, 1324, 1326, 1328, 
	1330, 1332, 1334, 1336, 1338, 1340, 1342, 1344, 
	1346, 1348, 1350, 1352, 1354, 1356, 1358, 1360, 
	1362, 1364, 1367, 1369, 1371, 1374, 1376, 1378, 
	1382, 1388, 1392, 1395, 1401, 1420, 1423, 1426, 
	1430, 1433, 1436, 1439, 1442, 1445, 1448, 1451, 
	1455, 1458, 1461, 1465, 1468, 1471, 1474, 1477, 
	1480, 1483, 1487, 1490, 1493, 1496, 1499, 1502, 
	1505, 1508, 1512, 1517, 1520, 1523, 1526, 1529, 
	1532, 1536, 1539, 1542, 1545, 1548, 1551, 1554, 
	1557, 1560, 1563, 1566, 1569, 1572, 1575, 1578, 
	1581, 1584, 1587, 1590, 1593
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 14, 16, 30, 33, 
	36, 38, 30, 84, 258, 263, 274, 412, 
	440, 447, 4, 0, 3, 0, 4, 0, 
	4, 4, 5, 14, 16, 30, 33, 36, 
	38, 30, 84, 258, 263, 274, 412, 440, 
	447, 4, 0, 6, 0, 7, 0, 8, 
	7, 7, 0, 9, 9, 10, 9, 9, 
	9, 9, 10, 9, 9, 9, 9, 11, 
	9, 9, 9, 9, 12, 9, 9, 4, 
	13, 13, 0, 4, 13, 13, 0, 4, 
	15, 14, 4, 0, 17, 0, 18, 0, 
	19, 0, 20, 0, 21, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 508, 0, 
	31, 0, 0, 32, 4, 15, 32, 0, 
	0, 0, 0, 34, 35, 4, 35, 35, 
	33, 34, 34, 4, 35, 33, 35, 0, 
	37, 0, 30, 0, 39, 0, 40, 0, 
	41, 0, 42, 0, 43, 0, 44, 0, 
	45, 0, 46, 0, 47, 0, 48, 0, 
	49, 0, 50, 0, 51, 0, 52, 0, 
	54, 53, 54, 53, 54, 54, 4, 55, 
	4, 69, 453, 460, 465, 473, 482, 54, 
	53, 54, 56, 53, 54, 57, 53, 54, 
	58, 53, 54, 59, 53, 54, 60, 53, 
	54, 61, 53, 54, 62, 53, 54, 63, 
	53, 54, 64, 53, 54, 65, 53, 54, 
	66, 53, 54, 67, 53, 54, 68, 53, 
	54, 4, 53, 54, 70, 53, 54, 71, 
	53, 54, 72, 53, 54, 73, 53, 54, 
	74, 53, 54, 75, 53, 54, 76, 53, 
	54, 77, 53, 54, 78, 53, 54, 79, 
	53, 54, 80, 53, 54, 81, 53, 54, 
	82, 53, 54, 83, 53, 4, 4, 5, 
	14, 16, 30, 33, 36, 38, 30, 84, 
	258, 263, 274, 412, 440, 447, 4, 0, 
	85, 87, 0, 86, 0, 31, 30, 0, 
	88, 0, 89, 162, 0, 90, 0, 91, 
	0, 92, 0, 93, 0, 95, 94, 95, 
	94, 95, 95, 4, 96, 110, 4, 111, 
	113, 110, 127, 130, 135, 143, 148, 155, 
	95, 94, 95, 97, 94, 95, 98, 94, 
	95, 99, 94, 95, 100, 94, 95, 101, 
	94, 95, 102, 94, 95, 103, 94, 95, 
	104, 94, 95, 105, 94, 95, 106, 94, 
	95, 107, 94, 95, 108, 94, 95, 109, 
	94, 95, 4, 94, 95, 83, 94, 95, 
	112, 94, 95, 110, 94, 95, 114, 94, 
	95, 115, 94, 95, 116, 94, 95, 117, 
	94, 95, 118, 94, 95, 119, 94, 95, 
	120, 94, 95, 121, 94, 95, 122, 94, 
	95, 123, 94, 95, 124, 94, 95, 125, 
	94, 95, 126, 94, 95, 83, 94, 95, 
	128, 94, 95, 129, 94, 95, 83, 110, 
	94, 95, 131, 94, 95, 132, 94, 95, 
	133, 94, 134, 95, 122, 94, 122, 95, 
	94, 95, 136, 138, 94, 95, 137, 94, 
	95, 110, 94, 95, 139, 94, 95, 140, 
	94, 95, 141, 94, 95, 142, 94, 95, 
	126, 94, 95, 144, 94, 95, 145, 94, 
	95, 146, 94, 95, 147, 94, 95, 126, 
	94, 95, 149, 94, 95, 150, 94, 95, 
	151, 94, 95, 152, 94, 95, 153, 94, 
	95, 154, 94, 95, 126, 94, 95, 156, 
	94, 95, 157, 160, 94, 95, 158, 94, 
	95, 159, 94, 95, 110, 110, 94, 95, 
	161, 94, 95, 112, 94, 163, 0, 164, 
	0, 165, 0, 166, 0, 167, 0, 169, 
	168, 169, 168, 169, 169, 4, 170, 184, 
	4, 185, 187, 184, 201, 208, 213, 221, 
	226, 251, 169, 168, 169, 171, 168, 169, 
	172, 168, 169, 173, 168, 169, 174, 168, 
	169, 175, 168, 169, 176, 168, 169, 177, 
	168, 169, 178, 168, 169, 179, 168, 169, 
	180, 168, 169, 181, 168, 169, 182, 168, 
	169, 183, 168, 169, 4, 168, 169, 83, 
	168, 169, 186, 168, 169, 184, 168, 169, 
	188, 168, 169, 189, 168, 169, 190, 168, 
	169, 191, 168, 169, 192, 168, 169, 193, 
	168, 169, 194, 168, 169, 195, 168, 169, 
	196, 168, 169, 197, 168, 169, 198, 168, 
	169, 199, 168, 169, 200, 168, 169, 83, 
	168, 169, 202, 204, 168, 169, 203, 168, 
	169, 83, 184, 168, 169, 205, 168, 169, 
	206, 168, 169, 207, 168, 169, 199, 168, 
	169, 209, 168, 169, 210, 168, 169, 211, 
	168, 212, 169, 196, 168, 196, 169, 168, 
	169, 214, 216, 168, 169, 215, 168, 169, 
	184, 168, 169, 217, 168, 169, 218, 168, 
	169, 219, 168, 169, 220, 168, 169, 200, 
	168, 169, 222, 168, 169, 223, 168, 169, 
	224, 168, 169, 225, 168, 169, 200, 168, 
	169, 227, 233, 235, 168, 169, 228, 168, 
	169, 229, 168, 169, 230, 168, 169, 231, 
	168, 169, 232, 168, 169, 200, 168, 169, 
	234, 168, 169, 220, 168, 169, 236, 168, 
	169, 237, 168, 169, 238, 168, 169, 239, 
	168, 169, 240, 168, 169, 241, 168, 169, 
	242, 168, 169, 243, 168, 169, 244, 168, 
	169, 245, 168, 169, 246, 168, 169, 247, 
	168, 169, 248, 168, 169, 249, 168, 169, 
	250, 168, 169, 220, 168, 169, 252, 168, 
	169, 253, 256, 168, 169, 254, 168, 169, 
	255, 168, 169, 184, 184, 168, 169, 257, 
	168, 169, 186, 168, 259, 0, 260, 0, 
	261, 0, 262, 47, 0, 47, 0, 264, 
	266, 0, 265, 0, 30, 0, 267, 270, 
	0, 268, 0, 269, 0, 166, 0, 271, 
	0, 272, 0, 273, 0, 51, 0, 275, 
	280, 0, 276, 0, 277, 0, 278, 0, 
	279, 0, 269, 0, 281, 0, 282, 0, 
	283, 0, 284, 0, 285, 383, 0, 287, 
	286, 287, 286, 287, 287, 4, 288, 302, 
	4, 303, 305, 302, 319, 328, 333, 343, 
	351, 376, 287, 286, 287, 289, 286, 287, 
	290, 286, 287, 291, 286, 287, 292, 286, 
	287, 293, 286, 287, 294, 286, 287, 295, 
	286, 287, 296, 286, 287, 297, 286, 287, 
	298, 286, 287, 299, 286, 287, 300, 286, 
	287, 301, 286, 287, 4, 286, 287, 83, 
	286, 287, 304, 286, 287, 302, 286, 287, 
	306, 286, 287, 307, 286, 287, 308, 286, 
	287, 309, 286, 287, 310, 286, 287, 311, 
	286, 287, 312, 286, 287, 313, 286, 287, 
	314, 286, 287, 315, 286, 287, 316, 286, 
	287, 317, 286, 287, 318, 286, 287, 83, 
	286, 287, 320, 322, 286, 287, 321, 286, 
	287, 83, 302, 286, 287, 323, 286, 287, 
	324, 326, 286, 287, 325, 286, 287, 317, 
	286, 287, 327, 286, 287, 316, 286, 287, 
	329, 286, 287, 330, 286, 287, 331, 286, 
	332, 287, 314, 286, 314, 287, 286, 287, 
	334, 336, 286, 287, 335, 286, 287, 302, 
	286, 287, 337, 340, 286, 287, 338, 286, 
	287, 339, 286, 287, 318, 286, 287, 341, 
	286, 287, 342, 286, 287, 339, 286, 287, 
	344, 347, 286, 287, 345, 286, 287, 346, 
	286, 287, 341, 286, 287, 348, 286, 287, 
	349, 286, 287, 350, 286, 287, 318, 286, 
	287, 352, 358, 360, 286, 287, 353, 286, 
	287, 354, 286, 287, 355, 286, 287, 356, 
	286, 287, 357, 286, 287, 318, 286, 287, 
	359, 286, 287, 339, 286, 287, 361, 286, 
	287, 362, 286, 287, 363, 286, 287, 364, 
	286, 287, 365, 286, 287, 366, 286, 287, 
	367, 286, 287, 368, 286, 287, 369, 286, 
	287, 370, 286, 287, 371, 286, 287, 372, 
	286, 287, 373, 286, 287, 374, 286, 287, 
	375, 286, 287, 339, 286, 287, 377, 286, 
	287, 378, 381, 286, 287, 379, 286, 287, 
	380, 286, 287, 302, 302, 286, 287, 382, 
	286, 287, 304, 286, 384, 0, 386, 385, 
	386, 385, 386, 386, 4, 387, 401, 406, 
	4, 386, 385, 386, 388, 385, 386, 389, 
	385, 386, 390, 385, 386, 391, 385, 386, 
	392, 385, 386, 393, 385, 386, 394, 385, 
	386, 395, 385, 386, 396, 385, 386, 397, 
	385, 386, 398, 385, 386, 399, 385, 386, 
	400, 385, 386, 83, 385, 386, 402, 385, 
	386, 403, 385, 386, 404, 385, 405, 386, 
	396, 385, 396, 386, 385, 386, 407, 385, 
	386, 408, 385, 386, 409, 385, 386, 410, 
	385, 386, 411, 385, 386, 400, 385, 413, 
	421, 424, 0, 414, 0, 415, 0, 416, 
	0, 417, 0, 418, 0, 419, 420, 0, 
	383, 0, 285, 0, 422, 0, 423, 0, 
	92, 0, 425, 0, 426, 0, 427, 0, 
	428, 0, 429, 0, 430, 0, 431, 0, 
	432, 0, 433, 0, 434, 0, 435, 0, 
	436, 0, 437, 0, 438, 0, 439, 0, 
	423, 0, 441, 0, 442, 445, 0, 443, 
	0, 444, 0, 30, 30, 0, 446, 0, 
	37, 0, 447, 448, 447, 0, 452, 451, 
	450, 448, 451, 449, 0, 450, 448, 449, 
	0, 450, 449, 452, 451, 450, 448, 451, 
	449, 452, 452, 5, 14, 16, 30, 33, 
	36, 38, 30, 84, 258, 263, 274, 412, 
	440, 447, 452, 0, 54, 454, 53, 54, 
	455, 53, 54, 456, 458, 53, 54, 457, 
	53, 54, 81, 53, 54, 459, 53, 54, 
	80, 53, 54, 461, 53, 54, 462, 53, 
	54, 463, 53, 464, 54, 78, 53, 78, 
	54, 53, 54, 466, 53, 54, 467, 470, 
	53, 54, 468, 53, 54, 469, 53, 54, 
	82, 53, 54, 471, 53, 54, 472, 53, 
	54, 469, 53, 54, 474, 477, 53, 54, 
	475, 53, 54, 476, 53, 54, 471, 53, 
	54, 478, 53, 54, 479, 53, 54, 480, 
	53, 54, 481, 53, 54, 83, 82, 53, 
	54, 483, 490, 492, 53, 54, 484, 53, 
	54, 485, 53, 54, 486, 53, 54, 487, 
	53, 54, 488, 53, 54, 489, 82, 53, 
	54, 82, 53, 54, 491, 53, 54, 469, 
	53, 54, 493, 53, 54, 494, 53, 54, 
	495, 53, 54, 496, 53, 54, 497, 53, 
	54, 498, 53, 54, 499, 53, 54, 500, 
	53, 54, 501, 53, 54, 502, 53, 54, 
	503, 53, 54, 504, 53, 54, 505, 53, 
	54, 506, 53, 54, 507, 53, 54, 469, 
	53, 0, 0
};

static const char _lexer_trans_actions[] = {
	0, 47, 0, 5, 1, 0, 25, 1, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 31, 0, 39, 0, 39, 0, 39, 
	47, 0, 5, 1, 0, 25, 1, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	31, 0, 39, 0, 39, 0, 39, 47, 
	0, 0, 39, 119, 41, 41, 41, 3, 
	111, 29, 29, 29, 0, 111, 29, 29, 
	29, 0, 111, 29, 0, 29, 0, 95, 
	7, 7, 39, 47, 0, 0, 39, 103, 
	21, 0, 47, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 39, 50, 99, 19, 0, 39, 
	39, 39, 39, 0, 23, 107, 23, 23, 
	44, 23, 0, 47, 0, 1, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 47, 0, 62, 29, 
	62, 77, 77, 77, 77, 77, 77, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 9, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 9, 0, 115, 27, 53, 
	50, 27, 56, 50, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 59, 27, 39, 
	0, 0, 39, 0, 39, 0, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 47, 0, 71, 29, 77, 71, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 15, 0, 47, 15, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 15, 0, 47, 
	0, 0, 47, 0, 0, 47, 15, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 0, 47, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 47, 0, 65, 29, 77, 
	65, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 11, 0, 47, 11, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 11, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 11, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 39, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	0, 39, 0, 39, 0, 39, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 0, 39, 124, 
	50, 47, 0, 47, 0, 68, 29, 77, 
	68, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 13, 0, 47, 13, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 13, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 13, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 39, 124, 50, 
	47, 0, 47, 0, 74, 77, 77, 77, 
	74, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 17, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 0, 47, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 0, 39, 0, 
	39, 0, 39, 0, 0, 39, 0, 39, 
	0, 39, 0, 0, 0, 39, 47, 33, 
	33, 80, 33, 33, 39, 0, 35, 0, 
	39, 0, 0, 47, 0, 0, 35, 0, 
	0, 47, 0, 86, 83, 37, 89, 83, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 92, 0, 39, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 9, 0, 0, 
	47, 0, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 508;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1163 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
    
#line 1170 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1446 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1509 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/sr_latn.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_sr_latn()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Sr_latn", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

