#include "ruby.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>
#include <X11/extensions/XTest.h>

VALUE cXTest;
Display *disp;

static VALUE init(int argc, VALUE *argv, VALUE self) {
  char *dispname;

  switch(argc) {
    case 0:
      dispname = NULL;
      break;
    case 1:
      dispname = STR2CSTR(argv[0]);
      break;
    default:
      rb_raise(rb_eTypeError, "Invalid argument count");
  }
  disp = XOpenDisplay(dispname);
  if (!disp)
    rb_raise(rb_eRuntimeError, "Couldn't open display");
  
  return self;
}

static VALUE button_press(VALUE self, VALUE button) {
  int but;
  but = NUM2INT(button);
  
  XTestGrabControl(disp, True);
  XTestFakeButtonEvent(disp, but, True, CurrentTime);
  XTestFakeButtonEvent(disp, but, False, 30);
  XSync(disp, False);
  XTestGrabControl(disp, False);
}

void Init_XTest() {
  cXTest = rb_define_class("XTest", rb_cObject);
  rb_define_method(cXTest, "initialize", init, -1);
  rb_define_method(cXTest, "button_press", button_press, 1);
}
