,(use sort unixm tables syscalls)
,(use rs.sys.threads.manager)

;;;

(define *process-environment* #f)
(define *process-environment-as-vector* #f)

(set! *process-environment* #f) ;; reset when process starts
(set! *process-environment-as-vector* #f)

(define (process-environment)
  (if (not *process-environment*)
      (let ((tbl (make-string-table)))
	(for-each (lambda ((e <pair>))
		    (table-insert! tbl (car e) (cdr e)))
		  (the-environ))
	(set! *process-environment* tbl)))
  *process-environment*)

(define (process-environment-as-vector)
  (if (not *process-environment-as-vector*)
      (set! *process-environment-as-vector*
	    (let (((tbl <string-table>) (process-environment)))
	      (vector-map
	       (lambda (k)
		 (string-append k "=" (table-lookup tbl k)))
	       (sort (list->vector (key-sequence tbl)) string<?)))))
  *process-environment-as-vector*)

;;

(define-syntax (as-string object)
  (if (string? object)
      object
      (to-string object)))

(define (run cmd . args)
  (run* cmd args '#(0 1 2)))

;; returns a port which accesses the output of the command

(define (run->port cmd . args)
  (bind ((r w (pipe)))
    (run* cmd args (vector 0 w 2))
    (fd-close w)
    (open-mbox-input-port r)))

;; returns a port which feeds the input of the command

(define (port->run cmd . args)
  (bind ((r w (pipe)))
    (run* cmd args (vector r 1 2))
    (fd-close r)
    (open-queued-output w)))

;; returns two ports, the first feeds the input of the command,
;; the second accesses the output of the command

(define (port->run->port cmd . args)
  (bind ((r1 w1 (pipe))
	 (r2 w2 (pipe)))
    (run* cmd args (vector r1 w2 2))
    (fd-close r1)
    (fd-close w2)
    (values (open-queued-output w1)
	    (open-mbox-input-port r2))))

;;

(define (run* cmd args fds)
  (let* ((cmd-str (as-string cmd))
	 (cmd-file (if (string-search cmd-str #\/)
		       (if (file-access? cmd-str (access-mask execute))
			   cmd-str
			   (error "~a: not accessible in `execute' mode" cmd))
		       (cmd-in-path cmd-str)))
	 (p (make <process>)))
    (fork-and-exec
     p
     cmd-file
     (list->vector (cons cmd-file
			 (map (lambda (a)
				(as-string a))
			      args)))
     #f
     (process-environment-as-vector)
     fds)
    p))

;;

(define *cmd-path* #f)
(define (cmd-path)
  (if (not *cmd-path*)
      (set! *cmd-path* (string-split (table-lookup (process-environment)
						   "PATH")
				     #\:)))
  *cmd-path*)

(define (cmd-in-path cmd)
  (let loop ((p (cmd-path)))
    (if (null? p)
	(error "~a: could not find" cmd)
	(let ((t (string-append (car p) "/" cmd)))
	  (if (file-access? t (access-mask execute))
	      t
	      (loop (cdr p)))))))

