/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: trace.h,v 1.10 2000/08/25 07:03:26 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern char const *my_name;
extern pid_t my_pid;

void rp_hook_death(void);


enum trace_bits {
    LOGAREA_HTTP = 0x01,
    LOGAREA_STREAM = 0x02,	/* bulk streaming of data */
    LOGAREA_CACHE = 0x04,       /* basis cache control */
    LOGAREA_HSYNC = 0x08,       /* rsync library -- binary encoding/signature */
    LOGAREA_PROTO = 0x10,       /* rproxy app-level protocol */
    LOGAREA_PARSE = 0x20,       /* low-level string parsing */
    LOGAREA_ERROR = 0x40,       /* error messages to clients */
    LOGAREA_PROCESS = 0x80,	/* forking of child processes, etc */
    LOGAREA_LOG = 0x100,        /* log files */
    LOGAREA_NET = 0x200         /* networking */
};

void rp_log(int area, int level, char const *fmt, ...)
    GCC_ATTRIBUTE((format(printf, 3, 4)));

void rp_setup_log(void);

void            write_trace_usage(FILE * out);
void            set_trace_flags(const char *);

void trace(int type, char const *fmt, ...)
    GCC_ATTRIBUTE((format(printf, 2, 3)));
