/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: logfile.c,v 1.5 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "sysheaders.h"

#include <sys/file.h>

#include "rproxy.h"
#include "request.h"
#include "trace.h"
#include "logfile.h"
#include "util.h"

int
rp_open_logfile(char const *filename)
{
    int fd;

    fd = open(filename, O_WRONLY | O_CREAT | O_APPEND, 0600);
    if (fd == -1) {
        rp_log(LOGAREA_LOG, LOG_ERR, "can't open logfile %s: %s",
                     filename, strerror(errno));
        exit(1);
    }

    return fd;
}


void
rp_log_atomic(int fd, char const *fmt, ...)
{
    char buf[1024];
    va_list ap;
    size_t len;
    int rc;
    char *p;

    va_start(ap, fmt);
    vsnprintf(buf, sizeof buf - 1, fmt, ap);
    va_end(ap);
    buf[sizeof buf - 1] = '\0'; /* just make sure */

    len = strlen(buf);

    p = buf;
    do {
        rc = write(fd, p, len);
        if ((size_t) rc == len) {
            break;
        } else if (rc == -1) {
            rp_log(LOGAREA_PROCESS, LOG_ERR, "error writing to log fd%d: %s",
                   fd, strerror(errno));
            return;             /* keep going */
        } else {
            assert((size_t) rc < len);
            rp_log(LOGAREA_PROCESS, LOG_WARNING, "non-atomic write to log fd%d", fd);
            len -= rc;
            p += rc;
        }
    } while (1);        
}


void
rp_log_stats(request_t *req)
{
    char stats_str[1024];

    if (config.stats_log_fd == -1)
        return;

    /* FIXME: I'm not sure this format will be very easy to parse.  We
     * want something that both humans and Perl (or favourite regexp
     * language) can read easily.  Perhaps lisp-style sexps? */
    hs_format_stats(&req->hs_stats, stats_str, sizeof stats_str - 1);
    rp_log_atomic(config.stats_log_fd,
                  "%s %s[%d] %s %d %s %s\n",
                  req->client_addr_str,
                  PACKAGE, getpid(),
                  str_or_null(req->url, "no-url"),
                  req->status,
                  str_or_null(req->resp_content_type, "no-mime-type"),
                  stats_str);
}
