#ifndef __RMDBG_INTERFACES_H__
#define __RMDBG_INTERFACES_H__

#ifdef RMDBG_ENABLED

/* rmem functions are hard cause they are macros, so we have to redefine them.. */

#undef rmem_alloc
#undef rmem_alloc0
#undef rmem_free
#undef rmem_new
#undef rmem_new0
#undef rmem_realloc

#define rmem_alloc(size) RMDBG_ALLOC("rmem_alloc", "rmem_free", size, malloc(size))
#define rmem_alloc0(size) RMDBG_ALLOC("rmem_alloc0", "rmem_free", size, calloc(1, size))
#define rmem_new(type,num) RMDBG_ALLOC("rmem_new", "rmem_free", sizeof (type) * num, rmem_alloc(sizeof (type) * num))
#define rmem_new0(type,num) RMDBG_ALLOC("rmem_new0", "rmem_free", sizeof (type) * num, rmem_alloc0(sizeof (type) * num))

/* Special case.. realloc is tricky so I had to reimplement it */
#define rmem_realloc(ptr, size) rmdbg_rmem_realloc__P (ptr, size, __FILE__, __LINE__, PRETTY_FUNCTION);
#define rmem_free(ptr) RMDBG_FREE(ptr, "rmem_free", free(ptr), TRUE)

/* RBuf functions */
#define rbuf_new() RMDBG_ALLOC("rbuf_new", "rbuf_free", sizeof (RBuf), rbuf_new())
#define rbuf_new_sized(size) RMDBG_ALLOC("rbuf_new_sized", "rbuf_free", sizeof (RBuf), rbuf_new_sized(size))
#define rbuf_new_with_str(str) RMDBG_ALLOC("rbuf_new_with_str", "rbuf_free", sizeof (RBuf), rbuf_new_with_str(str))
#define rbuf_new_with_static(str) RMDBG_ALLOC("rbuf_new_with_static", "rbuf_free", sizeof (RBuf), rbuf_new_with_static(str))
#define rbuf_new_with_long(val) RMDBG_ALLOC("rbuf_new_with_long", "rbuf_free", sizeof (RBuf), rbuf_new_with_long(val))
#define rbuf_new_with_float(val) RMDBG_ALLOC("rbuf_new_with_float", "rbuf_free", sizeof (RBuf), rbuf_new_with_float(val))
#define rbuf_new_with_data(str, len) RMDBG_ALLOC("rbuf_new_with_data", "rbuf_free", sizeof (RBuf), rbuf_new_with_data (str, len))
#define rbuf_new_with_rbuf(buf) RMDBG_ALLOC("rbuf_new_with_rbuf", "rbuf_free", sizeof (RBuf), rbuf_new_with_rbuf (buf))


/* Special case for split/free */
#define rbuf_split(str, sep, max) rmdbg_rbuf_split__P(str, sep, max, __FILE__, __LINE__, PRETTY_FUNCTION)
#define rlist_of_rbufs_free(ptr) rmdbg_rlist_of_rbufs_free__P(ptr, __FILE__, __LINE__, PRETTY_FUNCTION)

#ifdef HAVE_C99_VARIADIC_MACROS
#define rbuf_new_with_sprintf(buf,...) RMDBG_ALLOC("rbuf_new_with_sprintf", "rbuf_free", sizeof (RBuf), rbuf_new_with_sprintf (buf, __VA_ARGS__))
#endif /* HAVE_C99_VARIADIC_MACROS */

#define rbuf_free(ptr) RMDBG_FREE(ptr, "rbuf_free", rbuf_free(ptr), ptr ? !RFLAG_ISSET((ptr), RBUF_OWNED) : TRUE)


/* RArray */
#define rarray_new(esize, epc) RMDBG_ALLOC("rarray_new", "rarray_free", sizeof (RArray), rarray_new (esize, epc))
#define rarray_free(ptr) RMDBG_FREE(ptr, "rarray_free", rarray_free(ptr), TRUE)

/* RBHash */
#define rbhash_new() RMDBG_ALLOC("rbhash_new", "rbhash_free", sizeof (RBHash), rbhash_new())
#define rbhash_free(ptr) RMDBG_FREE(ptr, "rbhash_free", rbhash_free(ptr), TRUE)

/* rchunk */
#define rchunk_alloc(size) RMDBG_ALLOC("rchunk_alloc", "rchunk_free", size, rchunk_alloc(size))
#define rchunk_alloc0(size) RMDBG_ALLOC("rchunk_alloc0", "rchunk_free", size, rchunk_alloc0(size))
#define rchunk_free(ptr, size) RMDBG_FREE(ptr, "rchunk_free", rchunk_free(ptr, size), TRUE)

/* RHash */
#define rhash_new(hash, cmp) RMDBG_ALLOC("rhash_new", "rhash_free", sizeof (RHash), rhash_new(hash, cmp))
#define rhash_free(ptr) RMDBG_FREE(ptr, "rhash_free", rhash_free(ptr), TRUE)

/* RList */
#define rlist_new() RMDBG_ALLOC("rlist_new", "rlist_free", sizeof (RList), rlist_new())
#define rlist_free(ptr) RMDBG_FREE(ptr, "rlist_free", rlist_free(ptr), TRUE)

/* Rxp */
#define rxp_encoder_new() RMDBG_ALLOC("rxp_encoder_new", "rxp_encoder_free", sizeof (RXpEncoder), rxp_encoder_new())
#define rxp_encoder_free(ptr) RMDBG_FREE(ptr, "rxp_encoder_free", rxp_encoder_free(ptr), TRUE)

#define rxp_decoder_new(data,length) RMDBG_ALLOC("rxp_decoder_new", "rxp_decoder_free", sizeof (RXpDecoder), rxp_decoder_new(data, length))
#define rxp_decoder_free(ptr) RMDBG_FREE(ptr, "rxp_decoder_free", rxp_decoder_free(ptr), TRUE)

#define rxp_decode_rbuf(decoder,rbuf) rmdbg_rxp_decode_rbuf__P (decoder, rbuf, __FILE__, __LINE__, PRETTY_FUNCTION)


/* RThread */
#define rthread_create(function,data) RMDBG_ALLOC("rthread_create", "rthread_free", sizeof (RThread), rthread_create(function,data))
#define rthread_free(ptr) RMDBG_FREE(ptr, "rthread_free", rthread_free(ptr), TRUE)

/* RXp */

#endif /* RMDBG_ENABLED */

#endif /* __RMDBG_INTERFACES_H__ */


