
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RMAIN_H__
#define __RMAIN_H__

/* Extra headers for dealing with sockets. */

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


/* Winsock stuff */
#ifdef USE_WINSOCK

#include <winsock.h>

#else /* !USE_WINSOCK */

#define closesocket close
typedef int SOCKET;

#ifndef INVALID_SOCKET
#define INVALID_SOCKET -1
#endif /* INVALID_SOCKET */

#endif /* USE_WINSOCK */




typedef enum {
    RMAIN_READ      = 1 << 0,
    RMAIN_WRITE     = 1 << 1,
    RMAIN_ERROR     = 1 << 2
} RMainEventType;

typedef void (*RMainTimeoutEventFunction) (int id, void *user_data);

typedef void (*RMainFDEventFunction) (int id, int fd, RMainEventType event_type, void *user_data);

typedef void (*RMainSocketEventFunction) (int id, SOCKET socket, RMainEventType event_type, void *user_data);

typedef void (*RMainIdleEventFunction) (int id, void *user_data);


int
rmain_timeout_add (unsigned int ms, char *description, 
                   RMainTimeoutEventFunction function, void *user_data);

int
rmain_idle_add (char *description, RMainIdleEventFunction function, void *user_data);

int
rmain_fd_add (int fd, char *description, RMainEventType event_types, 
              RMainFDEventFunction function, void *user_data);

int
rmain_socket_add (SOCKET fd, char *description, RMainEventType event_types, 
                  RMainSocketEventFunction function, void *user_data);

/* Return description of id */
char *
rmain_description (int id);

void
rmain_remove (int id);

void
rmain_quit (void);

void
rmain (void);


#endif /* __RMAIN_H__ */


