#include "imageentry.h"

static void entryChanged(GtkEditable* widget, ImageEntry* data)
{
        data->changed();
}

ImageEntry::ImageEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        GtkWidget* pixmapEntry = gnome_pixmap_entry_new(0, "Select window background", true);
        valueWidget = gnome_pixmap_entry_gtk_entry(GNOME_PIXMAP_ENTRY(pixmapEntry));
        gtk_signal_connect(GTK_OBJECT(valueWidget), "changed", GTK_SIGNAL_FUNC(entryChanged), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), pixmapEntry, false, false, 3);
        gtk_widget_show(valueWidget);;
}

DataSet ImageEntry::getValue()
{
        string newValue(gtk_entry_get_text(GTK_ENTRY(valueWidget)));
        return DataSet(newValue);
}

void ImageEntry::setValue(const DataSet& value)
{
        if (value.count() > 0)
                gtk_entry_set_text(GTK_ENTRY(valueWidget), const_cast<gchar*> (value.getString().c_str()));
}
