#include "tree_saver_xml.h"
#include "module_tree.h"

#include <gnome-xml/parser.h>
#include <string>
using namespace std;

TreeSaverXml *TreeSaverXml::instance_ = 0;

static void save_module(const Path& path, xmlDoc* document, xmlNode* cur)
{
        try {
                // get module info so we know what variables to save
                const DataSetMap *m = ModuleTree::instance()->module_info(path);
                assert(m);
                const DataSetMap &modinf = *m;
                DataSet varnames = modinf["supported_vars"];
                varnames.addString("sticky");
                varnames.addDataSet(ModuleTree::instance()->get_value(path, "sticky"));
                varnames.noBlanks();

                for (int i = 0; i < varnames.count(); i++) {
                        string vname = varnames[i].getString();
                        string value = ModuleTree::instance()->get_value(path, vname).asString();
                        xmlSetProp(cur, reinterpret_cast<const xmlChar *> (vname.c_str()),
                                   reinterpret_cast<const xmlChar *> (value.c_str()));
                }

                int num_children = ModuleTree::instance()->child_count(path);
                for (int j = 0; j < num_children; j++) {
                        Path npath = path;
                        npath.add_last(j);
                        string mtype = ModuleTree::instance()->get_type(npath);
                        xmlNode* tree = xmlNewChild(cur, NULL,
                                                    reinterpret_cast<const xmlChar *> (mtype.c_str()), NULL);
                
                        // call ourselves recursively
                        save_module(npath, document, tree);
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void TreeSaverXml::save_to_file(const string& filename)
{
#ifdef WITH_GNOME
        xmlDoc* doc;
        
        doc = xmlNewDoc(reinterpret_cast<const xmlChar *> ("1.0"));
        doc->root = xmlNewDocNode(doc, NULL, reinterpret_cast<const xmlChar *> ("Configuration"), NULL);
	save_module(Path(), doc, doc->root);
        if (verbose)
                cout << "Saving configuration: " << filename << endl; 
        if (xmlSaveFile(filename.c_str(), doc) == -1)
                cerr << "Error writing config file" << endl;

        xmlFreeDoc(doc);
#else
        if (verbose)
                cout << "Not saving configuration (because we don't have gnome-xml)\n";
#endif
}

