#* 
#* ------------------------------------------------------------------
#* Role PlayingDB V2.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* RPGEdMonster.tcl - Monster Editor
#* Created by Robert Heller on Tue Aug 18 21:39:20 1998
#* ------------------------------------------------------------------
#* Modification History: 
#* $Log: RPGEdMonster.tcl,v $
#* Revision 1.5  2000/02/11 00:30:25  heller
#* Change MacOS type code GIF => GIFf
#*
#* Revision 1.4  1999/07/13 01:29:16  heller
#* Fix documentation: spelling, punctuation, etc.
#*
#* Revision 1.3  1998/12/30 15:10:51  heller
#* Add in comments
#*
#* Revision 1.2  1998/12/28 01:41:55  heller
#* Add in chapter heading text.
#*
#* Revision 1.1  1998/12/28 01:29:06  heller
#* Initial revision
#*
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Role Playing DB -- A database package that creates and maintains
#* 		       a database of RPG characters, monsters, treasures,
#* 		       spells, and playing environments.
#* 
#*     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#@Chapter:RPGEdMonster.tcl -- The adversaries in the game
#@Label:RPGEdMonster.tcl
#$Id: RPGEdMonster.tcl,v 1.5 2000/02/11 00:30:25 heller Rel $
# This file contains code to create and edit Monster objects.  These objects
# are used to represent ``monsters'' -- creatures and beings that the players'
# characters need to defeat.  These Monsters typically guard treasure or 
# generally inhabit (guard) the places the player characters are traveling
# in while searching for treasure.

proc RPGEdMonster {{filename {}}} {
# This procedure edits a Monster object.
# <in> the filename -- filename of the object to be edited.
# [index] RPGEdMonster!procedure

  global tk_version
  set toplevel [GenerateToplevelName rpgEdMon]

  RPGToplevel .$toplevel {Role Playing V2 Monster Editor} Monster
  wm withdraw .$toplevel
  global .$toplevel
  upvar #0 .$toplevel data
  set data(filename) "$filename"
  set data(filetype) "monster"
  if {[string length "$filename"] > 0} {
    set data(object) [Monster]
    set object $data(object)
    if {[file readable "$filename"]} {
    set buffer [Record]
      if {[catch [list $buffer ReadRecord "$filename"] err]} {
        CloseWindow .$toplevel
        tkerror "Could not load $filename: $err"
        return
      }
      if {[string compare {*Monster} "[lindex [$buffer ReturnRecord] 0]"] != 0} {
	CloseWindow .$toplevel
	tkerror "Not a Monster file: $filename"
	return
      }
      $object UpdateFromRecord $buffer
      rename $buffer {}
    } else {
      CloseWindow .$toplevel
      tkerror "File does not exist or is not readable: $filename"
      return
    }
  } else {
    set data(object) [Monster]
    set object $data(object)
    set data(dirty) 0
  }

# Construct a toplevel to display the monster's picture
  toplevel .$toplevel.picture
  wm transient .$toplevel.picture .$toplevel
  wm title .$toplevel.picture {Picture of Monster}
  wm protocol .$toplevel.picture WM_DELETE_WINDOW {NoOperation}
  label .$toplevel.picture.imname -text "[$object Image]" -relief sunken -border 2
  image create photo im$toplevel
#  puts stderr "*** \[image names\] = [image names] - 'im$toplevel'"
  label .$toplevel.picture.picture -image im$toplevel -relief ridge -border 2
  bind .$toplevel.picture <Destroy> [list catch "image delete im$toplevel"]
  pack .$toplevel.picture.imname -expand 1 -fill x
  pack .$toplevel.picture.picture -expand 1 -fill both
  set im "[$object Image]"
  if {[string length "$im"] > 0} { 
    if {[catch [list im$toplevel configure -format gif -file "$im"] err]} {
      tkerror "Could not set image file $im for image im$toplevel: $err"
    }
  }
  set data(image) "$im"


  # build widget .$toplevel.stringParams
  frame .$toplevel.stringParams \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.stringParams.left
  frame .$toplevel.stringParams.left

  # build widget .$toplevel.stringParams.left.name
  frame .$toplevel.stringParams.left.name

  # build widget .$toplevel.stringParams.left.name.label14
  label .$toplevel.stringParams.left.name.label14 \
    -text {Name / Type:}

  # build widget .$toplevel.stringParams.left.name.value
  entry .$toplevel.stringParams.left.name.value \
    -width {0} \
    -textvariable ".[set toplevel](name)"
  bind .$toplevel.stringParams.left.name.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.stringParams.left.alignment
  frame .$toplevel.stringParams.left.alignment \
    -relief {raised}

  # build widget .$toplevel.stringParams.left.alignment.label14
  label .$toplevel.stringParams.left.alignment.label14 \
    -text {Alignment:}

  # build widget .$toplevel.stringParams.left.alignment.value
  entry .$toplevel.stringParams.left.alignment.value \
    -width {0} \
    -textvariable ".[set toplevel](alignment)"
  bind .$toplevel.stringParams.left.alignment.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.stringParams.left.treasureType
  frame .$toplevel.stringParams.left.treasureType

  # build widget .$toplevel.stringParams.left.treasureType.label14
  label .$toplevel.stringParams.left.treasureType.label14 \
    -text {Treas. Type:}

  # build widget .$toplevel.stringParams.left.treasureType.value
  entry .$toplevel.stringParams.left.treasureType.value \
    -width {0} \
    -textvariable ".[set toplevel](treasureType)"
  bind .$toplevel.stringParams.left.treasureType.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.stringParams.right
  frame .$toplevel.stringParams.right

  # build widget .$toplevel.stringParams.right.specialAttacks
  frame .$toplevel.stringParams.right.specialAttacks

  # build widget .$toplevel.stringParams.right.specialAttacks.label14
  label .$toplevel.stringParams.right.specialAttacks.label14 \
    -text {Spec. Attacks:}

  # build widget .$toplevel.stringParams.right.specialAttacks.value
  entry .$toplevel.stringParams.right.specialAttacks.value \
    -width {0} \
    -textvariable ".[set toplevel](specialAttacks)"
  bind .$toplevel.stringParams.right.specialAttacks.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.stringParams.right.specialDefences
  frame .$toplevel.stringParams.right.specialDefences

  # build widget .$toplevel.stringParams.right.specialDefences.label14
  label .$toplevel.stringParams.right.specialDefences.label14 \
    -text {Spec. Defenses:}

  # build widget .$toplevel.stringParams.right.specialDefences.value
  entry .$toplevel.stringParams.right.specialDefences.value \
    -width {0} \
    -textvariable ".[set toplevel](specialDefences)"
  bind .$toplevel.stringParams.right.specialDefences.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.stringParams.right.psionics
  frame .$toplevel.stringParams.right.psionics

  # build widget .$toplevel.stringParams.right.psionics.label14
  label .$toplevel.stringParams.right.psionics.label14 \
    -text {Psionics:}

  # build widget .$toplevel.stringParams.right.psionics.value
  entry .$toplevel.stringParams.right.psionics.value \
    -width {0} \
    -textvariable ".[set toplevel](psionics)"
  bind .$toplevel.stringParams.right.psionics.value <KeyPress> \
	"SetDirty .$toplevel"

  # build widget .$toplevel.hpParams
  frame .$toplevel.hpParams \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.hpParams.hp
  frame .$toplevel.hpParams.hp

  # build widget .$toplevel.hpParams.hp.radiobutton16
  radiobutton .$toplevel.hpParams.hp.radiobutton16 \
    -text {Hit Points} \
    -value {Monster::Points} \
    -variable ".[set toplevel](HitType)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.hpParams.hp.hitpoints
  entry .$toplevel.hpParams.hp.hitpoints \
    -width {0} \
    -textvariable ".[set toplevel](hitpoints)"
  bind .$toplevel.hpParams.hp.hitpoints <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.hpParams.hp.hitpoints \
	[list .$toplevel.hpParams.hp.hitpoints Entry .$toplevel all IntEntry]

  # build widget .$toplevel.hpParams.hdice
  frame .$toplevel.hpParams.hdice

  # build widget .$toplevel.hpParams.hdice.radiobutton16
  radiobutton .$toplevel.hpParams.hdice.radiobutton16 \
    -text {Hit Dice} \
    -value {Monster::Dice} \
    -variable ".[set toplevel](HitType)" \
    -command "SetDirty .$toplevel"

  # build widget .$toplevel.hpParams.hdice.ndie
  entry .$toplevel.hpParams.hdice.ndie \
    -width {1} \
    -textvariable ".[set toplevel](ndie)"
  bind .$toplevel.hpParams.hdice.ndie <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.hpParams.hdice.ndie \
	[list .$toplevel.hpParams.hdice.ndie Entry .$toplevel all IntEntry]

  # build widget .$toplevel.hpParams.hdice.label19
  label .$toplevel.hpParams.hdice.label19 \
    -text {d}

  # build widget .$toplevel.hpParams.hdice.hdie
  entry .$toplevel.hpParams.hdice.hdie \
    -width {1} \
    -textvariable ".[set toplevel](hdie)"
  bind .$toplevel.hpParams.hdice.hdie <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.hpParams.hdice.hdie \
	[list .$toplevel.hpParams.hdice.hdie Entry .$toplevel all IntEntry]

  # build widget .$toplevel.hpParams.hdice.label21
  label .$toplevel.hpParams.hdice.label21 \
    -text {+}

  # build widget .$toplevel.hpParams.hdice.hplus
  entry .$toplevel.hpParams.hdice.hplus \
    -width {0} \
    -textvariable ".[set toplevel](hplus)"
  bind .$toplevel.hpParams.hdice.hplus <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.hpParams.hdice.hplus \
	[list .$toplevel.hpParams.hdice.hplus Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams
  frame .$toplevel.intParams \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.intParams.left
  frame .$toplevel.intParams.left

  # build widget .$toplevel.intParams.left.ac
  frame .$toplevel.intParams.left.ac

  # build widget .$toplevel.intParams.left.ac.label14
  label .$toplevel.intParams.left.ac.label14 \
    -text {Armor Class:}

  # build widget .$toplevel.intParams.left.ac.value
  entry .$toplevel.intParams.left.ac.value \
    -width {0} \
    -textvariable ".[set toplevel](ac)"
  bind .$toplevel.intParams.left.ac.value <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.left.ac.value \
	[list .$toplevel.intParams.left.ac.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.left.lair
  frame .$toplevel.intParams.left.lair

  # build widget .$toplevel.intParams.left.lair.label14
  label .$toplevel.intParams.left.lair.label14 \
    -text {Percent in Lair:}

  # build widget .$toplevel.intParams.left.lair.value
  entry .$toplevel.intParams.left.lair.value \
    -width {0} \
    -textvariable ".[set toplevel](lair)"
  bind .$toplevel.intParams.left.lair.value <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.left.lair.value \
	[list .$toplevel.intParams.left.lair.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.left.nAtt
  frame .$toplevel.intParams.left.nAtt

  # build widget .$toplevel.intParams.left.nAtt.label14
  label .$toplevel.intParams.left.nAtt.label14 \
    -text {Num. of Attacks:}

  # build widget .$toplevel.intParams.left.nAtt.value
  entry .$toplevel.intParams.left.nAtt.value \
    -width {0} \
    -textvariable ".[set toplevel](nAtt)"
  bind .$toplevel.intParams.left.nAtt.value <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.left.nAtt.value \
	[list .$toplevel.intParams.left.nAtt.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.left.magRes
  frame .$toplevel.intParams.left.magRes

  # build widget .$toplevel.intParams.left.magRes.label14
  label .$toplevel.intParams.left.magRes.label14 \
    -text {Magical Res.:}

  # build widget .$toplevel.intParams.left.magRes.value
  entry .$toplevel.intParams.left.magRes.value \
    -width {0} \
    -textvariable ".[set toplevel](magRes)"
  bind .$toplevel.intParams.left.magRes.value <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.left.magRes.value \
	[list .$toplevel.intParams.left.magRes.value Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right
  frame .$toplevel.intParams.right

  # build widget .$toplevel.intParams.right.move
  frame .$toplevel.intParams.right.move

  # build widget .$toplevel.intParams.right.move.label14
  label .$toplevel.intParams.right.move.label14 \
    -text {Move:}

  # build widget .$toplevel.intParams.right.move.m
  entry .$toplevel.intParams.right.move.m \
    -width {2} \
    -textvariable ".[set toplevel](move)"
  bind .$toplevel.intParams.right.move.m <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.move.m \
	[list .$toplevel.intParams.right.move.m Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.move.label35
  label .$toplevel.intParams.right.move.label35 \
    -text {"/}

  # build widget .$toplevel.intParams.right.move.f
  entry .$toplevel.intParams.right.move.f \
    -width {2} \
    -textvariable ".[set toplevel](fly)"
  bind .$toplevel.intParams.right.move.f <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.move.f \
	[list .$toplevel.intParams.right.move.f Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.move.label37
  label .$toplevel.intParams.right.move.label37 \
    -text {"//}

  # build widget .$toplevel.intParams.right.move.s
  entry .$toplevel.intParams.right.move.s \
    -width {2} \
    -textvariable ".[set toplevel](swim)"
  bind .$toplevel.intParams.right.move.s <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.move.s \
	[list .$toplevel.intParams.right.move.s Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.move.label39
  label .$toplevel.intParams.right.move.label39 \
    -text {"(}

  # build widget .$toplevel.intParams.right.move.b
  entry .$toplevel.intParams.right.move.b \
    -width {2} \
    -textvariable ".[set toplevel](burrow)"
  bind .$toplevel.intParams.right.move.b <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.move.b \
	[list .$toplevel.intParams.right.move.b Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.move.label41
  label .$toplevel.intParams.right.move.label41 \
    -text {")*}

  # build widget .$toplevel.intParams.right.move.w
  entry .$toplevel.intParams.right.move.w \
    -width {2} \
    -textvariable ".[set toplevel](web)"
  bind .$toplevel.intParams.right.move.w <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.move.w \
	[list .$toplevel.intParams.right.move.w Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.move.label43
  label .$toplevel.intParams.right.move.label43 \
    -text {"}

  # build widget .$toplevel.intParams.right.damAtt
  frame .$toplevel.intParams.right.damAtt

  # build widget .$toplevel.intParams.right.damAtt.label14
  label .$toplevel.intParams.right.damAtt.label14 \
    -text {Damage/Attack:}

  # build widget .$toplevel.intParams.right.damAtt.min
  entry .$toplevel.intParams.right.damAtt.min \
    -width {0} \
    -textvariable ".[set toplevel](damAtt.min)"
  bind .$toplevel.intParams.right.damAtt.min <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.damAtt.min \
	[list .$toplevel.intParams.right.damAtt.min Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.damAtt.label45
  label .$toplevel.intParams.right.damAtt.label45 \
    -text {to}

  # build widget .$toplevel.intParams.right.damAtt.max
  entry .$toplevel.intParams.right.damAtt.max \
    -width {0} \
    -textvariable ".[set toplevel](damAtt.max)"
  bind .$toplevel.intParams.right.damAtt.max <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.damAtt.max \
	[list .$toplevel.intParams.right.damAtt.max Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.numApear
  frame .$toplevel.intParams.right.numApear \
    -borderwidth {1}

  # build widget .$toplevel.intParams.right.numApear.label14
  label .$toplevel.intParams.right.numApear.label14 \
    -text {Number Appearing:}

  # build widget .$toplevel.intParams.right.numApear.min
  entry .$toplevel.intParams.right.numApear.min \
    -width {0} \
    -textvariable ".[set toplevel](numApear.min)"
  bind .$toplevel.intParams.right.numApear.min <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.numApear.min \
	[list .$toplevel.intParams.right.numApear.min Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.numApear.label45
  label .$toplevel.intParams.right.numApear.label45 \
    -text {to}

  # build widget .$toplevel.intParams.right.numApear.max
  entry .$toplevel.intParams.right.numApear.max \
    -width {0} \
    -textvariable ".[set toplevel](numApear.max)"
  bind .$toplevel.intParams.right.numApear.max <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.numApear.max \
	[list .$toplevel.intParams.right.numApear.max Entry .$toplevel all IntEntry]

  # build widget .$toplevel.intParams.right.size
  frame .$toplevel.intParams.right.size

  # build widget .$toplevel.intParams.right.size.label14
  label .$toplevel.intParams.right.size.label14 \
    -text {Size:}

  # build widget .$toplevel.intParams.right.size.value
  entry .$toplevel.intParams.right.size.value \
    -width {0} \
    -textvariable ".[set toplevel](size)"
  bind .$toplevel.intParams.right.size.value <KeyPress> \
	"SetDirty .$toplevel"
  bindtags .$toplevel.intParams.right.size.value \
	[list .$toplevel.intParams.right.size.value Entry .$toplevel all FloatEntry]

  # build widget .$toplevel.ifs
  frame .$toplevel.ifs \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.ifs.intel
  tk_optionMenu .$toplevel.ifs.intel .[set toplevel](intelligence) \
	Non Animal Semi Low Average Very Highly Exceptionally Genius SupraGenius Godlike

  # build widget .$toplevel.ifs.freq
  tk_optionMenu .$toplevel.ifs.freq .[set toplevel](frequency) \
	Unique VeryRare Rare Uncommon Common

  # build widget .$toplevel.description
  frame .$toplevel.description \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .$toplevel.description.scrollbar1
  scrollbar .$toplevel.description.scrollbar1 \
    -command ".$toplevel.description.value yview" \
    -relief {raised}

  # build widget .$toplevel.description.value
  text .$toplevel.description.value \
    -height {2} \
    -width {60} \
    -wrap {word} \
    -yscrollcommand ".$toplevel.description.scrollbar1 set"
  bindtags .$toplevel.description.value \
	[list .$toplevel.description.value Text .$toplevel all UpdComments]

  # build widget .$toplevel.buttons
  frame .$toplevel.buttons \
    -borderwidth {2}

  # build widget .$toplevel.buttons.button49
  button .$toplevel.buttons.button49 \
    -command "LoadMonster .$toplevel" \
    -text {Load}

  # build widget .$toplevel.buttons.button50
  button .$toplevel.buttons.button50 \
    -command "SaveMonster .$toplevel" \
    -text {Save}

  # build widget .$toplevel.buttons.button51
  button .$toplevel.buttons.button51 \
    -text {Change Picture} \
    -command "UpdateMonsterPicture .$toplevel im$toplevel"

  # pack master .$toplevel.stringParams
  pack configure .$toplevel.stringParams.left \
    -expand 1 \
    -fill both \
    -side left
  pack configure .$toplevel.stringParams.right \
    -expand 1 \
    -fill both \
    -side right

  # pack master .$toplevel.stringParams.left
  pack configure .$toplevel.stringParams.left.name \
    -expand 1 \
    -fill x
  pack configure .$toplevel.stringParams.left.alignment \
    -expand 1 \
    -fill x
  pack configure .$toplevel.stringParams.left.treasureType \
    -expand 1 \
    -fill x

  # pack master .$toplevel.stringParams.left.name
  pack configure .$toplevel.stringParams.left.name.label14 \
    -side left
  pack configure .$toplevel.stringParams.left.name.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.stringParams.left.alignment
  pack configure .$toplevel.stringParams.left.alignment.label14 \
    -side left
  pack configure .$toplevel.stringParams.left.alignment.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.stringParams.left.treasureType
  pack configure .$toplevel.stringParams.left.treasureType.label14 \
    -side left
  pack configure .$toplevel.stringParams.left.treasureType.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.stringParams.right
  pack configure .$toplevel.stringParams.right.specialAttacks \
    -expand 1 \
    -fill x
  pack configure .$toplevel.stringParams.right.specialDefences \
    -expand 1 \
    -fill x
  pack configure .$toplevel.stringParams.right.psionics \
    -expand 1 \
    -fill x

  # pack master .$toplevel.stringParams.right.specialAttacks
  pack configure .$toplevel.stringParams.right.specialAttacks.label14 \
    -side left
  pack configure .$toplevel.stringParams.right.specialAttacks.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.stringParams.right.specialDefences
  pack configure .$toplevel.stringParams.right.specialDefences.label14 \
    -side left
  pack configure .$toplevel.stringParams.right.specialDefences.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.stringParams.right.psionics
  pack configure .$toplevel.stringParams.right.psionics.label14 \
    -side left
  pack configure .$toplevel.stringParams.right.psionics.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.hpParams
  pack configure .$toplevel.hpParams.hp \
    -expand 1 \
    -fill both \
    -side left
  pack configure .$toplevel.hpParams.hdice \
    -expand 1 \
    -fill both \
    -side right

  # pack master .$toplevel.hpParams.hp
  pack configure .$toplevel.hpParams.hp.radiobutton16 \
    -side left
  pack configure .$toplevel.hpParams.hp.hitpoints \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.hpParams.hdice
  pack configure .$toplevel.hpParams.hdice.radiobutton16 \
    -side left
  pack configure .$toplevel.hpParams.hdice.ndie \
    -side left
  pack configure .$toplevel.hpParams.hdice.label19 \
    -side left
  pack configure .$toplevel.hpParams.hdice.hdie \
    -side left
  pack configure .$toplevel.hpParams.hdice.label21 \
    -side left
  pack configure .$toplevel.hpParams.hdice.hplus \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.intParams
  pack configure .$toplevel.intParams.left \
    -expand 1 \
    -fill both \
    -side left
  pack configure .$toplevel.intParams.right \
    -expand 1 \
    -fill both \
    -side right

  # pack master .$toplevel.intParams.left
  pack configure .$toplevel.intParams.left.ac \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.left.lair \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.left.nAtt \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.left.magRes \
    -expand 1 \
    -fill x

  # pack master .$toplevel.intParams.left.ac
  pack configure .$toplevel.intParams.left.ac.label14 \
    -side left
  pack configure .$toplevel.intParams.left.ac.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.intParams.left.lair
  pack configure .$toplevel.intParams.left.lair.label14 \
    -side left
  pack configure .$toplevel.intParams.left.lair.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.intParams.left.nAtt
  pack configure .$toplevel.intParams.left.nAtt.label14 \
    -side left
  pack configure .$toplevel.intParams.left.nAtt.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.intParams.left.magRes
  pack configure .$toplevel.intParams.left.magRes.label14 \
    -side left
  pack configure .$toplevel.intParams.left.magRes.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.intParams.right
  pack configure .$toplevel.intParams.right.move \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.right.damAtt \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.right.numApear \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams.right.size \
    -expand 1 \
    -fill x

  # pack master .$toplevel.intParams.right.move
  pack configure .$toplevel.intParams.right.move.label14 \
    -side left
  pack configure .$toplevel.intParams.right.move.m \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.move.label35 \
    -side left
  pack configure .$toplevel.intParams.right.move.f \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.move.label37 \
    -side left
  pack configure .$toplevel.intParams.right.move.s \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.move.label39 \
    -side left
  pack configure .$toplevel.intParams.right.move.b \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.move.label41 \
    -side left
  pack configure .$toplevel.intParams.right.move.w \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.move.label43 \
    -side left

  # pack master .$toplevel.intParams.right.damAtt
  pack configure .$toplevel.intParams.right.damAtt.label14 \
    -side left
  pack configure .$toplevel.intParams.right.damAtt.min \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.damAtt.label45 \
    -side left
  pack configure .$toplevel.intParams.right.damAtt.max \
    -expand 1 \
    -fill x \
    -side left

  # pack master .$toplevel.intParams.right.numApear
  pack configure .$toplevel.intParams.right.numApear.label14 \
    -side left
  pack configure .$toplevel.intParams.right.numApear.min \
    -expand 1 \
    -fill x \
    -side left
  pack configure .$toplevel.intParams.right.numApear.label45 \
    -side left
  pack configure .$toplevel.intParams.right.numApear.max \
    -expand 1 \
    -fill x \
    -side left

  # pack master .$toplevel.intParams.right.size
  pack configure .$toplevel.intParams.right.size.label14 \
    -side left
  pack configure .$toplevel.intParams.right.size.value \
    -expand 1 \
    -fill x \
    -side right

  # pack master .$toplevel.ifs
  pack configure .$toplevel.ifs.intel -side left -expand 1 -fill x
  pack configure .$toplevel.ifs.freq  -side right  -expand 1 -fill x

  # pack master .$toplevel.description
  pack configure .$toplevel.description.scrollbar1 \
    -fill y \
    -side right
  pack configure .$toplevel.description.value \
    -expand 1 \
    -fill both

  # pack master .$toplevel.buttons
  pack configure .$toplevel.buttons.button49 \
    -expand 1 \
    -side left
  pack configure .$toplevel.buttons.button50 \
    -expand 1 \
    -side left
  pack configure .$toplevel.buttons.button51 \
    -expand 1 \
    -side left

  # pack master .$toplevel
  pack configure .$toplevel.stringParams \
    -expand 1 \
    -fill x
  pack configure .$toplevel.hpParams \
    -expand 1 \
    -fill x
  pack configure .$toplevel.intParams \
    -expand 1 \
    -fill x
  pack configure .$toplevel.ifs \
    -expand 1 \
    -fill x
  pack configure .$toplevel.description \
    -expand 1 \
    -fill both
  pack configure .$toplevel.buttons \
    -expand 1 \
    -fill x

  set data(name) "[$object Name]"
  set data(alignment) "[$object Alignment]"
  set data(treasureType) "[$object TreasureType]"
  set data(specialAttacks) "[$object SpecialAttacks]"
  set data(specialDefences) "[$object SpecialDefences]"
  set data(psionics) "[$object Psionics]"
  set data(HitType) [$object Hittype]
  set data(hitpoints) [$object HitPoints]
  set data(ndie) [$object NumHitDice]
  set data(hdie) [$object HitDieSides]
  set data(hplus) [$object HitAdjustment]
  set data(ac) [$object ArmorClass]
  set data(lair) [$object PercentInLair]
  set data(nAtt) [$object NumberOfAttacks]
  set data(magRes) [$object MagicalResistance]
  set data(move) [$object LandSpeed]
  set data(fly) [$object FlyingSpeed]
  set data(swim) [$object SwimmingSpeed]
  set data(burrow) [$object BurrowingSpeed]
  set data(web) [$object WebSpeed]
  set damAtt [$object DamagePerAttack]
  set data(damAtt.min) [lindex $damAtt 0]
  set data(damAtt.max) [lindex $damAtt 1]
  set numApear [$object  NumberAppearing]
  set data(numApear.min) [lindex $numApear 0]
  set data(numApear.max) [lindex $numApear 1]
  set data(size) [$object Size]
  set data(comments) [$object Comments]
  .$toplevel.description.value insert end "$data(comments)"
  set intel [$object Intelligence]
  regsub -all {^Monster::} "$intel" {} data(intelligence)
  set freq [$object Frequency]
  regsub -all {^Monster::} "$freq" {} data(frequency)
  rename $object {}

# end of widget tree

  wm deiconify .$toplevel
}

proc UpdateMonsterPicture {tl img} {
# This procedure updates the picture (GIF file) of the monster.
# <in> tl -- the toplevel.
# <in> img -- the image file.
# [index] UpdateMonsterPicture!procedure

  upvar #0 $tl data
  set initdir "[file dirname $data(image)]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set newIm [tk_getOpenFile -defaultextension {.gif} \
			    -filetypes { { {GIF Files} {*.gif *.GIF} GIFf } } \
			    -initialfile "$data(image)" \
			    -initialdir "$initdir" \
			    -parent "$tl" \
			    -title {Select a new image file}]
  if {[string length "$newIm"] == 0} {return}
  if {[catch [list $img configure -format gif -file "$newIm"] err]} {
    tkerror "Could not set image file $newIm for image $img: $err"
  }
  $tl.picture.imname configure -text "$newIm"
  set data(image) "$newIm"
  set data(dirty) 1
}

proc CheckWriteDirtyRecordMonster {tl} {
# This procedure handles closing the window when the in memory copy of the
# object is ``dirty'' (modified).  It asks the user if the object should be 
# saved or not.
# <in> tl -- the toplevel.
# [index] CheckWriteDirtyRecordMonster!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set saveP [tk_dialog .askDirty "Save monster?" "Save modified Monster data?" \
	questhead 0 "Yes" "No"]
  if {$saveP == 0} {
    switch -exact $data(HitType) {
      Monster::Points {
	set object [Monster -this [NewMonster \
			-image "$data(image)" \
			-name "$data(name)" \
			-alignment "$data(alignment)" \
			-treasure "$data(treasureType)" \
			-specialatt "$data(specialAttacks)" \
			-specialdef "$data(specialDefences)" \
			-psionics "$data(psionics)" \
			-armorclass $data(ac) \
			-landspeed $data(move) \
			-flyingspeed $data(fly) \
			-swimmingspeed $data(swim) \
			-burrowingspeed $data(burrow) \
			-webspeed $data(web) \
			-percentlair $data(lair) \
			-numattacks $data(nAtt) \
			-mindamage $data(damAtt.min) \
			-maxdamage $data(damAtt.max) \
			-magicres $data(magRes) \
			-minnumappear $data(numApear.min) \
			-maxnumappear $data(numApear.max) \
			-intelligence Monster::$data(intelligence) \
			-frequency Monster::$data(frequency) \
			-size $data(size) \
			-comments "$data(comments)" \
			-hitpoints $data(hitpoints) \
			-hittype $data(HitType)]]
      }
      Monster::Dice {
	set object [Monster -this [NewMonster \
			-image "$data(image)" \
			-name "$data(name)" \
			-alignment "$data(alignment)" \
			-treasure "$data(treasureType)" \
			-specialatt "$data(specialAttacks)" \
			-specialdef "$data(specialDefences)" \
			-psionics "$data(psionics)" \
			-armorclass $data(ac) \
			-landspeed $data(move) \
			-flyingspeed $data(fly) \
			-swimmingspeed $data(swim) \
			-burrowingspeed $data(burrow) \
			-webspeed $data(web) \
			-percentlair $data(lair) \
			-numattacks $data(nAtt) \
			-mindamage $data(damAtt.min) \
			-maxdamage $data(damAtt.max) \
			-magicres $data(magRes) \
			-minnumappear $data(numApear.min) \
			-maxnumappear $data(numApear.max) \
			-intelligence Monster::$data(intelligence) \
			-frequency Monster::$data(frequency) \
			-size $data(size) \
			-comments "$data(comments)" \
			-hitdie $data(hdie) \
			-numhitdice $data(ndie) \
			-hitadjust $data(hplus) \
			-hittype $data(HitType)]]
      }
    }
    set buffer [Record -this [$object RawData]]
    if {[string length "$filename"] == 0} {
      set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				   -initialfile "new.$filetype" \
				   -initialdir "[pwd]" \
				   -filetypes [list [list "Monster files" \
							  "*.$filetype"]]\
				   -parent . \
				   -title {File to save monster data in}]
      if {[string length "$filename"] == 0} {return}
      if {[string length "[file extension $filename]"] == 0} {
	set filename "$filename.$filetype"
      }
    }
    $buffer WriteRecord "$filename"
    rename $buffer {}
    rename $object {}
  }
}

proc SaveAsMonster {tl} {
# This procedure is bound to the ``SaveAs...'' menu item. It saves the current
# object in a file to be named.
# <in> tl -- the toplevel.
# [index] SaveAsMonster!procedure

  SaveMonster $tl 1
}

proc SaveMonster {tl {forceNew 0}} {
# This procedure is bound to the ``Save'' menu item. It saves the current
# object in the file named in the data structure or in a new file name.
# <in> tl -- the toplevel.
# <in> forceNew -- flag to force the use of a new file name.
# [index] SaveAsMonster!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  switch -exact $data(HitType) {
    Monster::Points {
      set object [Monster -this [NewMonster \
			  -image "$data(image)" \
			  -name "$data(name)" \
			  -alignment "$data(alignment)" \
			  -treasure "$data(treasureType)" \
			  -specialatt "$data(specialAttacks)" \
			  -specialdef "$data(specialDefences)" \
			  -psionics "$data(psionics)" \
			  -armorclass $data(ac) \
			  -landspeed $data(move) \
			  -flyingspeed $data(fly) \
			  -swimmingspeed $data(swim) \
			  -burrowingspeed $data(burrow) \
			  -webspeed $data(web) \
			  -percentlair $data(lair) \
			  -numattacks $data(nAtt) \
			  -mindamage $data(damAtt.min) \
			  -maxdamage $data(damAtt.max) \
			  -magicres $data(magRes) \
			  -minnumappear $data(numApear.min) \
			  -maxnumappear $data(numApear.max) \
			  -intelligence Monster::$data(intelligence) \
			  -frequency Monster::$data(frequency) \
			  -size $data(size) \
			  -commentary "$data(comments)" \
			  -hitpoints $data(hitpoints) \
			  -hittype $data(HitType)]]
    }
    Monster::Dice {
	set object [Monster -this [NewMonster \
			-image "$data(image)" \
			-name "$data(name)" \
			-alignment "$data(alignment)" \
			-treasure "$data(treasureType)" \
			-specialatt "$data(specialAttacks)" \
			-specialdef "$data(specialDefences)" \
			-psionics "$data(psionics)" \
			-armorclass $data(ac) \
			-landspeed $data(move) \
			-flyingspeed $data(fly) \
			-swimmingspeed $data(swim) \
			-burrowingspeed $data(burrow) \
			-webspeed $data(web) \
			-percentlair $data(lair) \
			-numattacks $data(nAtt) \
			-mindamage $data(damAtt.min) \
			-maxdamage $data(damAtt.max) \
			-magicres $data(magRes) \
			-minnumappear $data(numApear.min) \
			-maxnumappear $data(numApear.max) \
			-intelligence Monster::$data(intelligence) \
			-frequency Monster::$data(frequency) \
			-size $data(size) \
			-commentary "$data(comments)" \
			-hitdie $data(hdie) \
			-numhitdice $data(ndie) \
			-hitadjust $data(hplus) \
			-hittype $data(HitType)]]
    }
  }
  set buffer [Record -this [$object RawData]]
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  if {[string length "$filename"] == 0} {
    set initfile "new.$filetype"
  } else {
    set initfile "$filename"
  }
  if {$forceNew || [string length "$filename"] == 0} {
    set filename [tk_getSaveFile -defaultextension ".$filetype" \
      				 -initialfile "$initfile" \
				 -initialdir "$initdir" \
				 -filetypes [list [list "Monster files" \
							  "*.$filetype"]]\
				 -parent $tl \
				 -title {File to save monster data in}]
    if {[string length "$filename"] == 0} {return}
    if {[string length "[file extension $filename]"] == 0} {
      set filename "$filename.$filetype"
    }
  }
  $buffer WriteRecord "$filename"
  rename $buffer {}
  rename $object {}
  set data(dirty) 0
  set data(filename) "$filename"
}

proc LoadMonster {tl} {
# This procedure loads a new monster object into the current GUI.
# <in> tl -- the toplevel.
# [index] LoadMonster!procedure

  upvar #0 $tl data
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  if {$data(dirty)} {
    set saveP [tk_dialog .askDirty "Save monster?" \
		"Save modified Monster data?" \
		questhead 0 "Yes" "No"]
    if {$saveP == 0} {SaveMonster $tl}
  }
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$filetype" \
				   -initialfile "$filename" \
                                   -initialdir "$initdir" \
                                   -filetypes [list [list "Monster files" \
							  "*.$filetype"]]\
                                   -parent $tl \
                                   -title {File to load monster data from}]
  if {[string length "$filename"] == 0} {return}
  set buffer [Record]
  if {[catch [list $buffer ReadRecord "$filename"] err]} {
    tkerror "Could not load file $filename: $err"
    rename $buffer {}
    return
  }
  set key [lindex [$buffer ReturnRecord] 0]
  if {[string compare "$key" {*Monster}] != 0} {
    rename $buffer {}
    tkerror "Not a monster file: $filename"
    return
  }
  set object [Monster]
  $object UpdateFromRecord $buffer
  rename $buffer {}
  set data(name) "[$object Name]"
  set data(alignment) "[$object Alignment]"
  set data(treasureType) "[$object TreasureType]"
  set data(specialAttacks) "[$object SpecialAttacks]"
  set data(specialDefences) "[$object SpecialDefences]"
  set data(psionics) "[$object Psionics]"
  set data(HitType) [$object Hittype]
#  puts stderr "*** LoadMonster: data(HitType) = $data(HitType)"
  set data(hitpoints) [$object HitPoints]
  set data(ndie) [$object NumHitDice]
  set data(hdie) [$object HitDieSides]
  set data(hplus) [$object HitAdjustment]
  set data(ac) [$object ArmorClass]
  set data(lair) [$object PercentInLair]
  set data(nAtt) [$object NumberOfAttacks]
  set data(magRes) [$object MagicalResistance]
  set data(move) [$object LandSpeed]
  set data(fly) [$object FlyingSpeed]
  set data(swim) [$object SwimmingSpeed]
  set data(burrow) [$object BurrowingSpeed]
  set data(web) [$object WebSpeed]
  set damAtt [$object DamagePerAttack]
  set data(damAtt.min) [lindex $damAtt 0]
  set data(damAtt.max) [lindex $damAtt 1]
  set numApear [$object  NumberAppearing]
  set data(numApear.min) [lindex $numApear 0]
  set data(numApear.max) [lindex $numApear 1]
  set data(size) [$object Size]
  set data(comments) [$object Comments]
  $tl.description.value insert end "$data(comments)"
  set intel [$object Intelligence]
  regsub -all {^Monster::} "$intel" {} data(intelligence)
  set freq [$object Frequency]
  regsub -all {^Monster::} "$freq" {} data(frequency)
  set data(image) "[$object Image]"
  set imname [$tl.picture.picture cget -image]
  if {[catch [list $imname configure -format gif -file "[$object Image]"] err]} {
    tkerror "Could not set image file [$object Image] for image $imname: $err"
  }
  rename $object {}
}

proc OpenMonster {tl} {
# This procedure opens a monster object file in a new GUI toplevel window.
# It is bound to the ``Open...'' menu item on the ``File'' menu.
# <in> tl -- the current toplevel.
# [index] OpenMonster!procedure

  if {"$tl" == {.}} {
    set data(filename) {}
    set data(filetype) monster
    set data(class) Monster
  } else {
    upvar #0 $tl data
  }
  set filename "$data(filename)"
  set filetype "$data(filetype)"
  set initdir "[file dirname $filename]"
  if {[string compare "$initdir" {.}] == 0} {set initdir "[pwd]"}
  if {[string compare "[string index "$initdir" 0]" {/}] != 0} {
    set initdir [file join "[pwd]" "$initdir"]
  }
  set filename [tk_getOpenFile -defaultextension ".$data(filetype)" \
			   -filetypes [list [list "$data(class) files" \
					"*.$filetype"]]\
			   -parent $tl \
			   -initialfile "$filename" \
			   -initialdir "$initdir" \
			   -title "File to load $data(class) data from"]
  if {[string length "$filename"] == 0} {return}
  RPGEd$data(class) "$filename"
}


package provide RPGEdMonster 1.0
