/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Character.cc - Character class
 * Created by Robert Heller on Tue Jul 14 12:19:19 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Character.cc,v $
 * Revision 1.2  1998/12/30 01:04:49  heller
 * Add comments to the code.
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <iostream.h>
#include <Character.h>
#include <Dice.h>
#include <stdio.h>

static char rcsid[] = "$Id: Character.cc,v 1.2 1998/12/30 01:04:49 heller Rel1 $";


/*
 * Copy constructor (copy from reference)
 * Just initialize ourselves from the source reference.
 */

Character::Character(const Character &that)
{
	_Character(that.strength,that.intelligence,that.wisdom,that.dexterity,
		   that.constitution,that.charisma,that.exceptional_strength,
		   that.level,that.hdie,that.ndie,that.maxdie,that.name,
		   that.player,that.race,that.chclass,that.alignment,
		   that.sex,that.age,that.comments,that.image);
}

/*
 * Copy constructor (copy from pointer)
 * Just initialize ourselves from the source pointer.
 */

Character::Character(const Character *that)
{
	_Character(that->strength,that->intelligence,that->wisdom,
		   that->dexterity,that->constitution,that->charisma,
		   that->exceptional_strength,that->level,that->hdie,
		   that->ndie,that->maxdie,that->name,that->player,that->race,
		   that->chclass,that->alignment,that->sex,that->age,
		   that->comments,that->image);
}

/*
 * Type conversion constructor, from a Record pointer.
 * Copy the record object and then initialize ourselves from the record.
 */

Character::Character (const Record *rec)
{
	rawData = *rec;
	RecordToCharacter();
}

/*
 * Set our age.  Update the record object.
 */
 
int Character::SetAge(int newage)
{
	age = newage;
	UpdateRecord();
	return age;
}

/*
 * Set our strength.  Update the record object.
 */
 
int Character::SetStrength(int newS)
{
	strength = newS;
	UpdateRecord();
	return strength;
}

/*
 * Set our intelligence.  Update the record object.
 */
 
int Character::SetIntelligence(int newI)
{
	intelligence = newI;
	UpdateRecord();
	return intelligence;
}

/*
 * Set our wisdom.  Update the record object.
 */
 
int Character::SetWisdom(int newW)
{
	wisdom = newW;
	UpdateRecord();
	return wisdom;
}

/*
 * Set our dexterity.  Update the record object.
 */
 
int Character::SetDexterity(int newD)
{
	dexterity = newD;
	UpdateRecord();
	return dexterity;
}

/*
 * Set our constitution.  Update the record object.
 */
 
int Character::SetConstitution(int newC)
{
	constitution = newC;
	UpdateRecord();
	return constitution;
}

/*
 * Set our charisma.  Update the record object.
 */
 
int Character::SetCharisma(int newCh)
{
	charisma = newCh;
	UpdateRecord();
	return charisma;
}

/*
 * Set our exceptional strength.  Update the record object.
 */
 
int Character::SetExceptionalStrength(int newES)
{
	exceptional_strength = newES;
	UpdateRecord();
	return exceptional_strength;
}

/*
 * Set our experience points.  Update the record object.
 */
 
int Character::SetExperiencePoints(int newEP)
{
	experience_points = newEP;
	UpdateRecord();
	return experience_points;
}

/*
 * Set our gold.  Update the record object.
 */
 
int Character::SetGold(int newGP)
{
	gold = newGP;
	UpdateRecord();
	return gold;
}

/*
 * Set our name.  Update the record object.
 */
 
const char *Character::SetName(const char * newN)
{
	name = newN;
	UpdateRecord();
	return name;
}

/*
 * Set our player.  Update the record object.
 */
 
const char *Character::SetPlayer(const char * newP)
{
	player = newP;
	UpdateRecord();
	return player;
}

/*
 * Set our race.  Update the record object.
 */
 
const char *Character::SetRace(const char *newR)
{
	race = newR;
	UpdateRecord();
	return race;
}

/*
 * Set our character class.  Update the record object.
 */
 
const char *Character::SetCharacterClass(const char *newCh)
{
	chclass = newCh;
	UpdateRecord();
	return chclass;
}

/*
 * Set our alignment.  Update the record object.
 */
 
const char *Character::SetAlignment(const char *newA)
{
	alignment = newA;
	UpdateRecord();
	return alignment;
}

/*
 * Set our sex.  Update the record object.
 */
 
const char *Character::SetSex(const char *newS)
{
	sex = newS;
	UpdateRecord();
	return sex;
}

/*
 * Set our comments.  Update the record object.
 */
 
const char *Character::SetComments(const char *newC)
{
	comments = newC;
	UpdateRecord();
	return comments;
}

/*
 * Set our image (GIF file).  Update the record object.
 */
 
const char *Character::SetImage(const char *newI)
{
	image = newI;
	UpdateRecord();
	return image;
}

/*
 * Advance our level.
 * Not only is the level advance, but the number of hit dice is increased and
 * additional hit points are awarded.
 */
 
void Character::AdvanceLevel()
{
	level++;
	if (ndie <= maxdie)
	{
		Dice die(hdie);
		ndie++;
		hitpoints += die.Roll();
	}
	UpdateRecord();
}

/*
 * Basic initialization function.  All fields are set and then the record
 * is updated to contain the values set and all internal pointers are
 * re-directed to the internal record structure.
 */
 
void Character::_Character(int s, int i, int w, int d, int c, int ch,
			   int es, int l, int hd, int nd, int md,
			   const char * n, const char * p, const char * r, 
			   const char * chc, const char * align, 
			   const char * sx, int ag,const char * com,
			   const char * im)
{
	strength = s;
	intelligence = i;
	wisdom = w;
	dexterity = d;
	constitution = c;
	charisma = ch;
	exceptional_strength = es;
	level = l;
	hdie = hd;
	ndie = nd;
	maxdie = md;
	name = n;
	player = p;
	race = r;
	chclass = chc;
	alignment = align;
	sex = sx;
	age = ag;
	comments = com;
	image = im;
	experience_points = 0;
	gold = 0;
	/* Roll the dice for this character's hitpoints */
	Dice *dice = new Dice(hdie,ndie);
	hitpoints = dice->Roll();
	delete dice;
	/* Update the record */
	UpdateRecord();
}

/*
 * Use the internal record to populate the other slots in the class.
 */

void Character::RecordToCharacter ()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	name = NULL;
	player = NULL;
	race = NULL;
	chclass = NULL;
	alignment = NULL;
	sex = NULL;
	comments = NULL;
	// while bytes remain...
	// peel off a keyed item
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		// keys: s: strength, i: intelligence, w: wisdom, d: dexterity,
		//       c: constitution, h: charisma, e: exceptional strength,
		//       l: level, D: hit die, N: number of hit dice, 
		//       M: maximum number of hit dice, H: hit points, n: name,
		//       p: player, r: race, C: character class, a: alignment,
		//       S: sex (gender), A: age, T: comments,
		//       E: experience points, G: gold, I: image
		switch (*str++) {
			case 's': strength = atol(str); break;
			case 'i': intelligence = atol(str); break;
			case 'w': wisdom = atol(str); break;
			case 'd': dexterity = atol(str); break;
			case 'c': constitution = atol(str); break;
			case 'h': charisma = atol(str); break;
			case 'e': exceptional_strength = atol(str); break;
			case 'l': level = atol(str); break;
			case 'D': hdie = atol(str); break;
			case 'N': ndie = atol(str); break;
			case 'M': maxdie = atol(str); break;
			case 'H': hitpoints = atol(str); break;
			case 'n': name = str; break;
			case 'p': player = str; break;
			case 'r': race = str; break;
			case 'C': chclass = str; break;
			case 'a': alignment = str; break;
			case 'S': sex = str; break;
			case 'A': age = atol(str); break;
			case 'T': comments = str; break;
			case 'E': experience_points = atol(str); break;
			case 'G': gold = atol(str); break;
			case 'I': image = str; break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
}

/*
 * Initialize the internal record buffer to hold the current data in the class
 * data members.  Pointer members are set to point to the internal buffer.
 */

void Character::UpdateRecord()
{
	// Temporary static buffers to hold numeric member values.
	static char strengthS[12],
		    intelligenceS[12],
		    wisdomS[12],
		    dexterityS[12],
		    constitutionS[12],
		    charismaS[12],
		    exceptional_strengthS[12],
		    levelS[12],
		    hdieS[12],
		    ndieS[12],
		    maxdieS[12],
		    hitpointsS[12],
		    ageS[12],
		    experience_pointsS[12],
		    goldS[12];
	// form numeric strings
	sprintf(strengthS,"%d",strength);
	sprintf(intelligenceS,"%d",intelligence);
	sprintf(wisdomS,"%d",wisdom);
	sprintf(dexterityS,"%d",dexterity);
	sprintf(constitutionS,"%d",constitution);
	sprintf(charismaS,"%d",charisma);
	sprintf(exceptional_strengthS,"%d",exceptional_strength);
	sprintf(levelS,"%d",level);
	sprintf(hdieS,"%d",hdie);
	sprintf(ndieS,"%d",ndie);
	sprintf(maxdieS,"%d",maxdie);
	sprintf(hitpointsS,"%d",hitpoints);
	sprintf(ageS,"%d",age);
	sprintf(experience_pointsS,"%d",experience_points);
	sprintf(goldS,"%d",gold);
	// Calculate the size of the record.
	int rsize = 11 +		// "*Character\0"
		  strlen(strengthS) + 3 + // "%snnn\0"
		  strlen(intelligenceS) + 3 + // "%innn\0"
		  strlen(wisdomS) + 3 + // "%wnnn\0"
		  strlen(dexterityS) + 3 + // "%dnnn\0"
		  strlen(constitutionS) + 3 + // "%cnnn\0"
		  strlen(charismaS) + 3 + // "%hnnn\0"
		  strlen(exceptional_strengthS) + 3 + // "%ennn\0"
		  strlen(levelS) + 3 + // "%lnnn\0"
		  strlen(hdieS) + 3 + // "%Dnnn\0"
		  strlen(ndieS) + 3 + // "%Nnnn\0"
		  strlen(maxdieS) + 3 + // "%Mnnn\0"
		  strlen(hitpointsS) + 3 + // "%Hnnn\0"
		  strlen(experience_pointsS) + 3 + // "%Ennn\0"
		  strlen(goldS) + 3 + // "%Gnnn\0"
		  ((name)?(strlen(name)):(0)) + 3 + // "%nxxx\0"
		  ((player)?(strlen(player)):(0)) + 3 + // "%pxxx\0"
		  ((race)?(strlen(race)):(0)) + 3 + // "%rxxx\0"
		  ((chclass)?(strlen(chclass)):(0)) + 3 + // "%Cxxx\0"
		  ((alignment)?(strlen(alignment)):(0)) + 3 + // "%axxx\0"
		  ((sex)?(strlen(sex)):(0)) + 3 + // "%Sxxx\0"
		  strlen(ageS) + 3 + // "%Annn\0"
		  ((comments)?(strlen(comments)):(0)) + 3 + // "%Tnnn\0"
		  ((image)?(strlen(image)):(0)) + 3 + // "%Innn\0"
		  strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	// Insert header key
	strcpy(p,"*Character"); p += strlen(p) + 1;
	// Fill in data strings
	*p++ = '%'; *p++ = 's'; strcpy(p,strengthS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'i'; strcpy(p,intelligenceS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'w'; strcpy(p,wisdomS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'd'; strcpy(p,dexterityS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'c'; strcpy(p,constitutionS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'h'; strcpy(p,charismaS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'e'; strcpy(p,exceptional_strengthS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'l'; strcpy(p,levelS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; strcpy(p,hdieS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'N'; strcpy(p,ndieS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'M'; strcpy(p,maxdieS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'H'; strcpy(p,hitpointsS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'p'; if (player) strcpy(p,player); else strcpy(p,""); player = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'r'; if (race) strcpy(p,race); else strcpy(p,""); race = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (chclass) strcpy(p,chclass); else strcpy(p,""); chclass = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'a'; if (alignment) strcpy(p,alignment); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'S'; if (sex) strcpy(p,sex); else strcpy(p,""); sex = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'A'; strcpy(p,ageS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; if (comments) strcpy(p,comments); else strcpy(p,""); comments = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'I'; if (image) strcpy(p,image); else strcpy(p,""); image = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'E'; strcpy(p,experience_pointsS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'G'; strcpy(p,goldS); p += strlen(p) + 1;
	// terminator
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}



