//roarcatvio.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2012
 *
 *  This file is part of roarclients a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

#define BUFSIZE 1024

void usage (void) {
 printf("roarcatvio [OPTIONS]... [FILE]\n");

 printf("\nOptions:\n\n");

 printf("  --server SERVER    - Set server hostname\n"
        "  --rate   RATE      - Set sample rate\n"
        "  --bits   BITS      - Set bits per sample\n"
        "  --chans  CHANNELS  - Set number of channels\n"
        "  --codec  CODEC     - Set the codec\n"
        "  --help             - Show this help\n"
       );

}

int main (int argc, char * argv[]) {
 struct roar_audio_info info = {.rate = ROAR_RATE_DEFAULT, .bits = ROAR_BITS_DEFAULT, .channels = ROAR_CHANNELS_DEFAULT};
 int    codec    = -1;
 int    auinfo_changed = 0;
 char * server   = NULL;
 char * k;
 int    i;
 char * name = "roarcatvio";
 roar_vs_t * vss;
 char * filename = NULL;
 int err;

 for (i = 1; i < argc; i++) {
  k = argv[i];

  if ( !strcmp(k, "--server") || !strcmp(k, "-s") ) {
   server = argv[++i];
  } else if ( !strcmp(k, "-n") ) {
   name = argv[++i];
  } else if ( !strcmp(k, "--rate") || !strcmp(k, "-r") ) {
   info.rate = roar_str2rate(argv[++i]);
   auinfo_changed = 1;
  } else if ( !strcmp(k, "--bits") ) {
   info.bits = roar_str2bits(argv[++i]);
   auinfo_changed = 1;
  } else if ( !strcmp(k, "-b") ) {
   info.bits = 8;
   auinfo_changed = 1;
  } else if ( !strcmp(k, "--channels") || !strcmp(k, "--chans") ) {
   info.channels = roar_str2channels(argv[++i]);
   auinfo_changed = 1;
  } else if ( !strcmp(k, "-m") ) {
   info.channels = 1;
   auinfo_changed = 1;
  } else if ( !strcmp(k, "--codec") ) {
   codec = roar_str2codec(argv[++i]);
   auinfo_changed = 1;
  } else if ( !strcmp(k, "--help") ) {
   usage();
   return 0;
  } else if ( filename == NULL ) {
   filename    = k;
  } else {
   fprintf(stderr, "Error: unknown argument: %s\n", k);
   usage();
   return 1;
  }
 }

 if ( codec == -1 )
  codec = ROAR_CODEC_DEFAULT;

 info.codec = codec;

 if ( (vss = roar_vs_new(server, name, &err)) == NULL ) {
  fprintf(stderr, "Error: can not connect to server: %s: %s\n",
   server == NULL ? "(default)" : server, roar_error2str(err));
  return 10;
 }

 if ( auinfo_changed ) {
  if ( roar_vs_stream(vss, &info, ROAR_DIR_PLAY, &err) == -1 ) {
   fprintf(stderr, "Error: can not create new stream: %s\n", roar_error2str(err));
   roar_vs_close(vss, ROAR_VS_TRUE, NULL);
   return 10;
  }
 }

 if ( roar_vs_file_simple(vss, filename, &err) == -1 ) {
  fprintf(stderr, "Error: can not open file: %s: %s\n", filename, roar_error2str(err));
  roar_vs_close(vss, ROAR_VS_TRUE, NULL);
  return 10;
 }

 roar_vs_run(vss, NULL);

 roar_vs_sync(vss, ROAR_VS_WAIT, NULL);
 roar_vs_close(vss, ROAR_VS_FALSE, NULL);

 return 0;
}

//ll
