//roarbidir.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2012
 *
 *  This file is part of roarclients a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

#define BUFSIZE 1024

void usage (void) {
 printf("roarbidir [OPTIONS]... [IN_FILE]\n");

 printf("\nOptions:\n\n");

 printf("  --server SERVER    - Set server hostname\n"
        "  --rate   RATE      - Set sample rate\n"
        "  --bits   BITS      - Set bits per sample\n"
        "  --chans  CHANNELS  - Set number of channels\n"
        "  --codec  CODEC     - Set the codec\n"
        "  --help             - Show this help\n"
       );

}

int main (int argc, char * argv[]) {
 int    rate     = ROAR_RATE_DEFAULT;
 int    bits     = ROAR_BITS_DEFAULT;
 int    channels = ROAR_CHANNELS_DEFAULT;
 int    codec    = ROAR_CODEC_DEFAULT;
 char * server   = NULL;
 char * k;
 int    i;
 struct roar_vio_defaults  def;
 struct roar_vio_calls in_store;
 struct roar_vio_calls * in = NULL, * out = NULL;
 struct roar_vio_calls * vss_vio = NULL;
 roar_vs_t * vss;
 struct roar_vio_select vios[2];
 char buf[BUFSIZE];
 int err;
 ssize_t ret;

 if ( roar_vio_dstr_init_defaults(&def, ROAR_VIO_DEF_TYPE_NONE, O_RDONLY, 0644) == -1 )
  return 1;

 for (i = 1; i < argc; i++) {
  k = argv[i];

  if ( strcmp(k, "--server") == 0 ) {
   server = argv[++i];
  } else if ( strcmp(k, "--rate") == 0 ) {
   rate = roar_str2rate(argv[++i]);
  } else if ( strcmp(k, "--bits") == 0 ) {
   bits = roar_str2bits(argv[++i]);
  } else if ( strcmp(k, "--channels") == 0 || strcmp(k, "--chans") == 0 ) {
   channels = roar_str2channels(argv[++i]);
  } else if ( strcmp(k, "--codec") == 0 ) {
   codec = roar_str2codec(argv[++i]);
  } else if ( strcmp(k, "--help") == 0 ) {
   usage();
   return 0;
  } else if ( in == NULL ) {
   if ( roar_vio_open_dstr(&in_store, k, &def, 1) == -1 ) {
    fprintf(stderr, "Error: can not open file: %s: %s\n", k, roar_error2str(roar_error));
    return 1;
   }
   in = &in_store;
  } else {
   fprintf(stderr, "Error: unknown argument: %s\n", k);
   usage();
   return 1;
  }
 }

 if ( (vss = roar_vs_new_simple(server, "roarbidir", rate, channels, codec, bits, ROAR_DIR_BIDIR, &err)) == NULL ) {
  fprintf(stderr, "Error: can not start playback: %s\n", roar_error2str(err));
  if ( in != NULL )
   roar_vio_close(in);
  return 1;
 }

 if ( in  == NULL )
  in  = roar_stdin;
 if ( out == NULL )
  out = roar_stdout;

 vss_vio = roar_vs_vio_obj(vss, NULL);

 while (1) {
  memset(vios, 0, sizeof(vios));

  ROAR_VIO_SELECT_SETVIO(&(vios[0]), vss_vio, ROAR_VIO_SELECT_READ);
  ROAR_VIO_SELECT_SETVIO(&(vios[1]), in, ROAR_VIO_SELECT_READ);

  if ( (ret = roar_vio_select(vios, 2, NULL, NULL)) == -1 )
   break;

  if ( ret < 0 )
   continue;

  if ( vios[0].eventsa & ROAR_VIO_SELECT_READ ) {
   if ( (ret = roar_vs_read(vss, buf, sizeof(buf), NULL)) == -1 )
    break;
   if ( roar_vio_write(out, buf, ret) != ret )
    break;
  }
  if ( vios[1].eventsa & ROAR_VIO_SELECT_READ ) {
   if ( (ret = roar_vio_read(in, buf, sizeof(buf))) == -1 )
    break;
   if ( roar_vs_write(vss, buf, ret, NULL) != ret )
    break;
  }
 }

 roar_vs_close(vss, ROAR_VS_TRUE, NULL);

 roar_vio_close(in);

 return 0;
}

//ll
