/*
 *  utils.c              -
 *
 *  Created: 20020220
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: utils.c,v 1.3 2002/03/23 22:11:59 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <utils.h>

#include <sys/stat.h>

/* Pusta pixmapa. */
static gchar *dummy_pixmap_xpm[] = { "1 1 1 1", "  c None", " " };

/* Zwraca pust pixmap. */
static GtkWidget *create_dummy_pixmap(GtkWidget *widget)
{
    GdkColormap *colormap;
    GdkPixmap *gdkpixmap;
    GdkBitmap *mask;
    GtkWidget *pixmap;
    
    colormap = gtk_widget_get_colormap(widget);
    gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
                                                      NULL, dummy_pixmap_xpm);
    
    if (gdkpixmap == NULL)
        g_error("Couldn't create replacement pixmap.");

    pixmap = gtk_pixmap_new(gdkpixmap, mask);
    
    gdk_pixmap_unref(gdkpixmap);
    gdk_bitmap_unref(mask);
    
    return pixmap;
}

/* Funkcja sprawdzajaca czy plik o okrelonej nazwie istnieje w zadanym katalogu
   i jeeli tak, zwraca pen nazw pliku, albo NULL - w przeciwnym przypadku. */
static gchar *check_file_exist(const gchar *directory, const gchar *filename)
{
    gchar *full_filename;
    struct stat s;
    gint status;
    
    full_filename = (gchar *)g_malloc(strlen(directory) + 1 + strlen(filename) + 1);
    strcpy(full_filename, directory);
    strcat(full_filename, G_DIR_SEPARATOR_S);
    strcat(full_filename, filename);
    
    status = stat(full_filename, &s);
    if (status == 0 && S_ISREG(s.st_mode))
        return full_filename;
	
    g_free(full_filename);
    return NULL;
}

GtkWidget *create_pixmap(GtkWidget *widget, const gchar *filename)
{
    gchar *found_filename;
    GtkWidget *pixmap;
    
    /* Sprawdzanie czy zadany plik istnieje. */
    found_filename = check_file_exist(PIXMAPSDIR, filename);
    
    /* Jeeli plik nie istnieje zwraca pust pixmap. */
    if (!found_filename)
    {
        g_warning("Couldn't find pixmap file: %s", filename);
	pixmap = create_dummy_pixmap(widget);
    }
    else
    {
        GdkColormap *colormap;
        GdkPixmap *gdkpixmap;
        GdkBitmap *mask;

        /* Tworzenie bitmapy. */
        colormap = gtk_widget_get_colormap(widget);
        gdkpixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask, NULL, found_filename);
    
        if (gdkpixmap == NULL)
        {
            g_warning("Error loading pixmap file: %s", filename);
	    g_free(found_filename);
	    pixmap = create_dummy_pixmap(widget);
        }
        else
	{
            g_free(found_filename);
            pixmap = gtk_pixmap_new(gdkpixmap, mask);
    
            gdk_pixmap_unref(gdkpixmap);
            gdk_bitmap_unref(mask);
	}
    }
    
    return pixmap;
}
