/*
 *  Rexx/Tk Multi-column listbox
 *  Copyright (C) 2000  Mark Hessling  <M.Hessling@qut.edu.au>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * TBD for 8.3 and above
 * add:
   pathName column itemconfigure name index option value[,option value...]
 */
#include "rexxtk.h"

char *RxPackageName = "rexxtkmclistbox";
char *ExtensionSource =
"package require Tk 8.0\n"
"package provide mclistbox 1.02\n"
"namespace eval ::mclistbox {\n"
"namespace export mclistbox\n"
"variable widgetOptions\n"
"variable columnOptions\n"
"variable widgetCommands\n"
"variable columnCommands\n"
"variable labelCommands\n"
"}\n"
"proc ::mclistbox::Init {} {\n"
"variable widgetOptions\n"
"variable columnOptions\n"
"variable widgetCommands\n"
"variable columnCommands\n"
"variable labelCommands\n"
"array set widgetOptions [list  "
"-background          {background          Background}  "
"-bd                  -borderwidth  "
"-bg                  -background  "
"-borderwidth         {borderWidth         BorderWidth}  "
"-columnbd            -columnborderwidth  "
"-columnborderwidth   {columnBorderWidth   BorderWidth}  "
"-columnrelief        {columnRelief        Relief}  "
"-cursor              {cursor              Cursor}  "
"-exportselection     {exportSelection     ExportSelection}  "
"-fg                  -foreground  "
"-fillcolumn          {fillColumn          FillColumn}  "
"-font                {font                Font}  "
"-foreground          {foreground          Foreground}  "
"-height              {height              Height}  "
"-highlightbackground {highlightBackground HighlightBackground}  "
"-highlightcolor      {highlightColor      HighlightColor}  "
"-highlightthickness  {highlightThickness  HighlightThickness}  "
"-labelanchor         {labelAnchor         Anchor}  "
"-labelbackground     {labelBackground     Background}  "
"-labelbd             -labelborderwidth  "
"-labelbg             -labelbackground  "
"-labelborderwidth    {labelBorderWidth    BorderWidth}  "
"-labelfg             -labelforeground  "
"-labelfont           {labelFont           Font}  "
"-labelforeground     {labelForeground     Foreground}  "
"-labelheight         {labelHeight         Height}  "
"-labelimage          {labelImage          Image}  "
"-labelrelief         {labelRelief         Relief}  "
"-labels              {labels              Labels}  "
"-relief              {relief              Relief}  "
"-resizablecolumns    {resizableColumns    ResizableColumns}  "
"-selectbackground    {selectBackground    Foreground}  "
"-selectborderwidth   {selectBorderWidth   BorderWidth}  "
"-selectcommand       {selectCommand       Command}  "
"-selectforeground    {selectForeground    Background}  "
"-selectmode          {selectMode          SelectMode}  "
"-setgrid             {setGrid             SetGrid}  "
"-takefocus           {takeFocus           TakeFocus}  "
"-width               {width               Width}  "
"-xscrollcommand      {xScrollCommand      ScrollCommand}  "
"-yscrollcommand      {yScrollCommand      ScrollCommand}  "
"]\n"
"array set columnOptions [list  "
"-background         {background           Background}  "
"-bitmap  {bitmap               Bitmap}  "
"-font               {font                 Font}  "
"-foreground         {foreground           Foreground}  "
"-image              {image                Image}  "
"-label   {label                Label}  "
"-position           {position             Position}  "
"-resizable          {resizable            Resizable}  "
"-visible            {visible              Visible}  "
"-width              {width                Width}  "
"]\n"
"set widgetCommands [list  "
"activate  bbox       cget     column    configure   "
"curselection delete     get      index     insert  "
"label        nearest    scan     see       selection   "
"size         xview      yview\n"
"]\n"
"set columnCommands [list add cget configure delete names nearest]\n"
"set labelCommands  [list bind]\n"
"set packages [package names]\n"
"if {[lsearch -exact [package names] \"Tk\"] != -1} {\n"
"set tmpWidget \".__tmp__\"\n"
"set count 0\n"
"while {[winfo exists $tmpWidget] == 1} {\n"
"set tmpWidget \".__tmp__$count\"\n"
"incr count\n"
"}\n"
"listbox $tmpWidget\n"
"foreach foo [$tmpWidget configure] {\n"
"if {[llength $foo] == 5} {\n"
"set option [lindex $foo 1]\n"
"set value [lindex $foo 4]\n"
"option add *Mclistbox.$option $value widgetDefault\n"
"if {[string compare $option \"foreground\"] == 0  "
"|| [string compare $option \"background\"] == 0  "
"|| [string compare $option \"font\"] == 0} {\n"
"option add *Mclistbox*MclistboxColumn.$option $value  "
"widgetDefault\n"
"}\n"
"}\n"
"}\n"
"destroy $tmpWidget\n"
"label $tmpWidget\n"
"foreach option [list Anchor Background Font  "
"Foreground Height Image  ] {\n"
"set values [$tmpWidget configure -[string tolower $option]]\n"
"option add *Mclistbox.label$option [lindex $values 3]\n"
"}\n"
"destroy $tmpWidget\n"
"option add *Mclistbox.columnBorderWidth   0      widgetDefault\n"
"option add *Mclistbox.columnRelief        flat   widgetDefault\n"
"option add *Mclistbox.labelBorderWidth    1      widgetDefault\n"
"option add *Mclistbox.labelRelief         raised widgetDefault\n"
"option add *Mclistbox.labels              1      widgetDefault\n"
"option add *Mclistbox.resizableColumns    1      widgetDefault\n"
"option add *Mclistbox.selectcommand       {}     widgetDefault\n"
"option add *Mclistbox.fillcolumn          {}     widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.visible       1      widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.resizable     1      widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.position      end    widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.label         \"\"     widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.width         0      widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.bitmap        \"\"     widgetDefault\n"
"option add *Mclistbox*MclistboxColumn.image         \"\"     widgetDefault\n"
"}\n"
"SetClassBindings\n"
"}\n"
"proc ::mclistbox::mclistbox {args} {\n"
"variable widgetOptions\n"
"if {![info exists widgetOptions]} {\n"
"Init\n"
"}\n"
"if {[llength $args] == 0} {\n"
"error \"wrong # args: should be \\\"mclistbox pathName ?options?\\\"\"\n"
"}\n"
"if {[winfo exists [lindex $args 0]]} {\n"
"error \"window name \\\"[lindex $args 0]\\\" already exists\"\n"
"}\n"
"foreach {name value} [lrange $args 1 end] {\n"
"Canonize [lindex $args 0] option $name\n"
"}\n"
"set w [eval Build $args]\n"
"SetBindings $w\n"
"return $w\n"
"}\n"
"proc ::mclistbox::Build {w args} {\n"
"variable widgetOptions\n"
"namespace eval ::mclistbox::$w {\n"
"variable options\n"
"variable widgets\n"
"variable misc\n"
"}\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"set misc(columns) {}\n"
"set widgets(this)   [frame  $w -class Mclistbox -takefocus 1]\n"
"foreach name [array names widgetOptions] {\n"
"if {[llength $widgetOptions($name)] == 1} continue\n"
"set optName  [lindex $widgetOptions($name) 0]\n"
"set optClass [lindex $widgetOptions($name) 1]\n"
"set options($name) [option get $w $optName $optClass]\n"
"}\n"
"if {[llength $args] > 0} {\n"
"array set options $args\n"
"}\n"
"set widgets(text) [text $w.text  "
"-width 0  "
"-height 0  "
"-padx 0  "
"-pady 0  "
"-wrap none  "
"-borderwidth 0  "
"-highlightthickness 0  "
"-takefocus 0  "
"-cursor {}  "
"]\n"
"$widgets(text) configure -state disabled\n"
"set columnWidgets [NewColumn $w {__hidden__}]\n"
"set widgets(hiddenFrame)   [lindex $columnWidgets 0]\n"
"set widgets(hiddenListbox) [lindex $columnWidgets 1]\n"
"set widgets(hiddenLabel)   [lindex $columnWidgets 2]\n"
"pack propagate $widgets(hiddenFrame) on\n"
"pack $widgets(hiddenFrame) -side top -fill both -expand y\n"
"place $widgets(text) -x 0 -y 0 -relwidth 1.0 -relheight 1.0\n"
"raise $widgets(text)\n"
"set widgets(frame) ::mclistbox::${w}::$w\n"
"rename ::$w $widgets(frame)\n"
"proc ::$w {command args}  "
"\"eval ::mclistbox::WidgetProc {$w} \\$command \\$args\"\n"
"if {[catch \"Configure $widgets(this) [array get options]\" error]} {\n"
"catch {destroy $w}\n"
"}\n"
"selection handle $w [list ::mclistbox::SelectionHandler $w get]\n"
"return $w\n"
"}\n"
"proc ::mclistbox::SelectionHandler {w type {offset \"\"} {length \"\"}} {\n"
"upvar ::mclistbox::${w}::options   options\n"
"upvar ::mclistbox::${w}::misc      misc\n"
"upvar ::mclistbox::${w}::widgets   widgets\n"
"switch -exact $type {\n"
"own {\n"
"selection own  "
"-command [list ::mclistbox::SelectionHandler $w lose]  "
"-selection PRIMARY  "
"$w\n"
"}\n"
"lose {\n"
"if {$options(-exportselection)} {\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) selection clear 0 end\n"
"}\n"
"}\n"
"}\n"
"get {\n"
"set end [expr {$length + $offset - 1}]\n"
"set column [lindex $misc(columns) 0]\n"
"set curselection [$widgets(listbox$column) curselection]\n"
"set data \"\"\n"
"foreach index $curselection {\n"
"set rowdata [join [::mclistbox::WidgetProc-get $w $index]  \"\t\"]\n"
"lappend data $rowdata\n"
"}\n"
"set data [join $data \"\n\"]\n"
"return [string range $data $offset $end]\n"
"}\n"
"}\n"
"}\n"
"proc ::mclistbox::convert {w args} {\n"
"set result {}\n"
"if {![winfo exists $w]} {\n"
"error \"window \\\"$w\\\" doesn't exist\"\n"
"}\n"
"while {[llength $args] > 0} {\n"
"set option [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"switch -exact -- $option {\n"
"-x {\n"
"set value [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"set win $w\n"
"while {[winfo class $win] != \"Mclistbox\"} {\n"
"incr value [winfo x $win]\n"
"set win [winfo parent $win]\n"
"if {$win == \".\"} break\n"
"}\n"
"lappend result $value\n"
"}\n"
"-y {\n"
"set value [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"set win $w\n"
"while {[winfo class $win] != \"Mclistbox\"} {\n"
"incr value [winfo y $win]\n"
"set win [winfo parent $win]\n"
"if {$win == \".\"} break\n"
"}\n"
"lappend result $value\n"
"}\n"
"-w -\n"
"-W {\n"
"set win $w\n"
"while {[winfo class $win] != \"Mclistbox\"} {\n"
"set win [winfo parent $win]\n"
"if {$win == \".\"} break;\n"
"}\n"
"lappend result $win\n"
"}\n"
"}\n"
"}\n"
"return $result\n"
"}\n"
"proc ::mclistbox::SetBindings {w} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"bind $widgets(text) <Configure>  "
"[list ::mclistbox::AdjustColumns $w %h]\n"
"}\n"
"proc ::mclistbox::SetClassBindings {} {\n"
"bind Mclistbox <Destroy> [list ::mclistbox::DestroyHandler %W]\n"
"foreach event [bind Listbox] {\n"
"set binding [bind Listbox $event]\n"
"regsub -all {%W} $binding {[::mclistbox::convert %W -W]} binding\n"
"regsub -all {%x} $binding {[::mclistbox::convert %W -x %x]} binding\n"
"regsub -all {%y} $binding {[::mclistbox::convert %W -y %y]} binding\n"
"bind Mclistbox $event $binding\n"
"}\n"
"set this {[::mclistbox::convert %W -W]}\n"
"bind MclistboxMouseBindings <ButtonPress-1>  "
"\"::mclistbox::ResizeEvent $this buttonpress %W %x %X %Y\"\n"
"bind MclistboxMouseBindings <ButtonRelease-1>  "
"\"::mclistbox::ResizeEvent $this buttonrelease %W %x %X %Y\"\n"
"bind MclistboxMouseBindings <Enter>  "
"\"::mclistbox::ResizeEvent $this motion %W %x %X %Y\"\n"
"bind MclistboxMouseBindings <Motion>  "
"\"::mclistbox::ResizeEvent $this motion %W %x %X %Y\"\n"
"bind MclistboxMouseBindings <B1-Motion>  "
"\"::mclistbox::ResizeEvent $this drag %W %x %X %Y\"\n"
"}\n"
"proc ::mclistbox::NewColumn {w id} {\n"
"upvar ::mclistbox::${w}::widgets   widgets\n"
"upvar ::mclistbox::${w}::options   options\n"
"upvar ::mclistbox::${w}::misc      misc\n"
"upvar ::mclistbox::${w}::columnID  columnID\n"
"set frame      "
"[frame $w.frame$id  "
"-takefocus 0  "
"-highlightthickness 0  "
"-class MclistboxColumn  "
"-background $options(-background)  "
"]\n"
"set listbox    "
"[listbox $frame.listbox  "
"-takefocus 0  "
"-bd 0  "
"-setgrid $options(-setgrid)  "
"-exportselection false  "
"-selectmode $options(-selectmode)  "
"-highlightthickness 0  "
"]\n"
"set label      "
"[label $frame.label  "
"-takefocus 0  "
"-relief raised  "
"-bd 1  "
"-highlightthickness 0  "
"]\n"
"set columnID($label) $id\n"
"set columnID($frame) $id\n"
"set columnID($listbox) $id\n"
"set tag MclistboxLabel\n"
"bindtags $label  [list MclistboxMouseBindings $label]\n"
"foreach option [list bd image height relief font anchor  "
"background foreground borderwidth] {\n"
"if {[info exists options(-label$option)]  "
"&& $options(-label$option) != \"\"} {\n"
"$label configure -$option $options(-label$option)\n"
"}\n"
"}\n"
"foreach option [list borderwidth relief] {\n"
"if {[info exists options(-column$option)]  "
"&& $options(-column$option) != \"\"} {\n"
"$frame configure -$option $options(-column$option)\n"
"}\n"
"}\n"
"pack propagate $frame off\n"
"pack $label   -side top -fill x -expand n\n"
"pack $listbox -side top -fill both -expand y -pady 2\n"
"bindtags $listbox [list $w Mclistbox all]\n"
"return [list $frame $listbox $label]\n"
"}\n"
"proc ::mclistbox::Column-add {w args} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"variable widgetOptions\n"
"set id \"column-[llength $misc(columns)]\" ;# a suitable default\n"
"if {![string match {-*} [lindex $args 0]]} {\n"
"set id [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"if {[lsearch -exact $misc(columns) $id] != -1} {\n"
"error \"column \\\"$id\\\" already exists\"\n"
"}\n"
"}\n"
"set opts(-bitmap)     {}\n"
"set opts(-image)      {}\n"
"set opts(-visible)    1\n"
"set opts(-resizable)  1\n"
"set opts(-position)   \"end\"\n"
"set opts(-width)      20\n"
"set opts(-background) $options(-background)\n"
"set opts(-foreground) $options(-foreground)\n"
"set opts(-font)       $options(-font)\n"
"set opts(-label)      $id\n"
"if {[expr {[llength $args]%2}] == 1} {\n"
"set option [::mclistbox::Canonize $w \"column option\" [lindex $args end]]\n"
"error \"value for \\\"[lindex $args end]\\\" missing\"\n"
"}\n"
"array set opts $args\n"
"if {[llength $misc(columns)] > 0} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set existingRows [$widgets(listbox$col0) size]\n"
"} else {\n"
"set existingRows 0\n"
"}\n"
"set widgetlist [NewColumn $w $id]\n"
"set widgets(frame$id)   [lindex $widgetlist 0]\n"
"set widgets(listbox$id) [lindex $widgetlist 1]\n"
"set widgets(label$id)   [lindex $widgetlist 2]\n"
"lappend misc(columns) $id\n"
"eval ::mclistbox::Column-configure {$w} {$id} [array get opts]\n"
"if {$existingRows > 0} {\n"
"set blanks {}\n"
"for {set i 0} {$i < $existingRows} {incr i} {\n"
"lappend blanks {}\n"
"}\n"
"eval {$widgets(listbox$id)} insert end $blanks\n"
"}\n"
"InvalidateScrollbars $w\n"
"return $id\n"
"}\n"
"proc ::mclistbox::Column-configure {w id args} {\n"
"variable widgetOptions\n"
"variable columnOptions\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"set index [CheckColumnID $w $id]\n"
"set listbox $widgets(listbox$id)\n"
"set frame   $widgets(frame$id)\n"
"set label   $widgets(label$id)\n"
"if {[llength $args] == 0} {\n"
"set results {}\n"
"foreach opt [lsort [array names columnOptions]] {\n"
"if {[llength $columnOptions($opt)] == 1} {\n"
"set alias $columnOptions($opt)\n"
"set optName $columnOptions($alias)\n"
"lappend results [list $opt $optName]\n"
"} else {\n"
"set optName  [lindex $columnOptions($opt) 0]\n"
"set optClass [lindex $columnOptions($opt) 1]\n"
"set default [option get $frame $optName $optClass]\n"
"lappend results [list $opt $optName $optClass  "
"$default $options($id:$opt)]\n"
"}\n"
"}\n"
"return $results\n"
"} elseif {[llength $args] == 1} {\n"
"set option [::mclistbox::Canonize $w \"column option\" [lindex $args 0]]\n"
"set value $options($id:$option)\n"
"set optName  [lindex $columnOptions($option) 0]\n"
"set optClass [lindex $columnOptions($option) 1]\n"
"set default  [option get $frame $optName $optClass]\n"
"set results  [list $option $optName $optClass $default $value]\n"
"return $results\n"
"}\n"
"if {[expr {[llength $args]%2}] == 1} {\n"
"error \"value for \\\"[lindex $args end]\\\" missing\"\n"
"}\n"
"foreach {name value} $args {\n"
"set name [::mclistbox::Canonize $w \"column option\" $name]\n"
"set opts($name) $value\n"
"}\n"
"foreach option [array names opts] {\n"
"set value $opts($option)\n"
"set options($id:$option) $value\n"
"switch -- $option {\n"
"-label {\n"
"$label configure -text $value\n"
"}\n"
"-image -\n"
"-bitmap {\n"
"$label configure $option $value\n"
"}\n"
"-width {\n"
"set font [$listbox cget -font]\n"
"set factor [font measure $options(-font) \"0\"]\n"
"set width [expr {$value * $factor}]\n"
"$widgets(frame$id) configure -width $width\n"
"set misc(min-$widgets(frame$id)) $width\n"
"AdjustColumns $w\n"
"}\n"
"-font -\n"
"-foreground -\n"
"-background {\n"
"if {[string length $value] == 0} {set value $options($option)}\n"
"$listbox configure $option $value\n"
"}\n"
"-resizable {\n"
"if {[catch {\n"
"if {$value} {\n"
"set options($id:-resizable) 1\n"
"} else {\n"
"set options($id:-resizable) 0\n"
"}\n"
"} msg]} {\n"
"error \"expected boolean but got \\\"$value\\\"\"\n"
"}\n"
"}\n"
"-visible {\n"
"if {[catch {\n"
"if {$value} {\n"
"set options($id:-visible) 1\n"
"$widgets(text) configure -state normal\n"
"$widgets(text) window configure 1.$index -window $frame\n"
"$widgets(text) configure -state disabled\n"
"} else {\n"
"set options($id:-visible) 0\n"
"$widgets(text) configure -state normal\n"
"$widgets(text) window configure 1.$index -window {}\n"
"$widgets(text) configure -state disabled\n"
"}\n"
"InvalidateScrollbars $w\n"
"} msg]} {\n"
"error \"expected boolean but got \\\"$value\\\"\"\n"
"}\n"
"}\n"
"-position {\n"
"if {[string compare $value \"start\"] == 0} {\n"
"set position 0\n"
"} elseif {[string compare $value \"end\"] == 0} {\n"
"set position [expr {[llength $misc(columns)] -1}]\n"
"} else {\n"
"set position $value\n"
"}\n"
"if {$position >= [llength $misc(columns)]} {\n"
"set max [expr {[llength $misc(columns)] -1}]\n"
"error \"bad position; must be in the range of 0-$max\"\n"
"}\n"
"set current [lsearch -exact $misc(columns) $id]\n"
"set misc(columns) [lreplace $misc(columns) $current $current]\n"
"set misc(columns) [linsert $misc(columns) $position $id]\n"
"set frame $widgets(frame$id)\n"
"$widgets(text) configure -state normal\n"
"$widgets(text) window create 1.$position  "
"-window $frame -stretch 1\n"
"$widgets(text) configure -state disabled\n"
"}\n"
"}\n"
"}\n"
"}\n";
char *ExtensionSource1 =
"proc ::mclistbox::DestroyHandler {w} {\n"
"if {[info exists ::mclistbox::${w}::misc(afterid)]} {\n"
"catch {\n"
"after cancel $::mclistbox::${w}::misc(afterid)\n"
"unset ::mclistbox::${w}::misc(afterid)\n"
"}\n"
"}\n"
"if {[string compare [winfo class $w] \"Mclistbox\"] == 0} {\n"
"namespace delete ::mclistbox::$w\n"
"rename $w {}\n"
"}\n"
"}\n"
"proc ::mclistbox::MassageIndex {w index} {\n"
"upvar ::mclistbox::${w}::widgets   widgets\n"
"upvar ::mclistbox::${w}::misc      misc\n"
"if {[regexp {@([0-9]+),([0-9]+)} $index matchvar x y]} {\n"
"set id [lindex $misc(columns) 0]\n"
"incr y -[winfo y $widgets(listbox$id)]\n"
"incr y -[winfo y $widgets(frame$id)]\n"
"incr x [winfo x $widgets(listbox$id)]\n"
"incr x [winfo x $widgets(frame$id)]\n"
"set index @${x},${y}\n"
"}\n"
"return $index\n"
"}\n"
"proc ::mclistbox::WidgetProc {w command args} {\n"
"variable widgetOptions\n"
"upvar ::mclistbox::${w}::widgets   widgets\n"
"upvar ::mclistbox::${w}::options   options\n"
"upvar ::mclistbox::${w}::misc      misc\n"
"upvar ::mclistbox::${w}::columnID  columnID\n"
"set command [::mclistbox::Canonize $w command $command]\n"
"if {[string compare $command \"column\"] == 0} {\n"
"set subcommand [::mclistbox::Canonize $w \"column command\"  "
"[lindex $args 0]]\n"
"set command \"$command-$subcommand\"\n"
"set args [lrange $args 1 end]\n"
"} elseif {[string compare $command \"label\"] == 0} {\n"
"set subcommand [::mclistbox::Canonize $w \"label command\"  "
"[lindex $args 0]]\n"
"set command \"$command-$subcommand\"\n"
"set args [lrange $args 1 end]\n"
"}\n"
"set result \"\"\n"
"catch {unset priorSelection}\n"
"switch $command {\n"
"xview {\n"
"set result [eval {$widgets(text)} xview $args]\n"
"InvalidateScrollbars $w\n"
"}\n"
"yview {\n"
"if {[llength $args] == 0} {\n"
"set result [$widgets(hiddenListbox) yview]\n"
"} else {\n"
"if {[llength $args] == 1} {\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"set args [list $index]\n"
"}\n"
"foreach id $misc(columns) {\n"
"eval {$widgets(listbox$id)} yview $args\n"
"}\n"
"eval {$widgets(hiddenListbox)} yview $args\n"
"InvalidateScrollbars $w\n"
"set result \"\"\n"
"}\n"
"}\n"
"activate {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong \\# of args: should be $w activate index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) activate $index\n"
"}\n"
"set result \"\"\n"
"}\n"
"bbox {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong \\# of args: should be $w bbox index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"set id [lindex $misc(columns) 0]\n"
"set bbox [$widgets(listbox$id) bbox $index]\n"
"if {[string length $bbox] == 0} {return \"\"}\n"
"foreach {x y w h} $bbox {}\n"
"incr y [winfo y $widgets(listbox$id)]\n"
"incr y [winfo y $widgets(frame$id)]\n"
"incr x [winfo x $widgets(listbox$id)]\n"
"incr x [winfo x $widgets(frame$id)]\n"
"set id [lindex $misc(columns) end]\n"
"set w [expr {[winfo width $widgets(frame$id)] +  "
"[winfo x $widgets(frame$id)]}]\n"
"set bbox [list $x $y [expr {$x + $w}] $h]\n"
"set result $bbox\n"
"}\n"
"label-bind {\n"
"set id [lindex $args 0]\n"
"set index [CheckColumnID $w $id]\n"
"set args [lrange $args 1 end]\n"
"if {[llength $args] == 0} {\n"
"set result [bind $widgets(label$id)]\n"
"} else {\n"
"set sequence [lindex $args 0]\n"
"if {[llength $args] == 1} {\n"
"set result [lindex [bind $widgets(label$id) $sequence] end]\n"
"} else {\n"
"set code [lindex $args 1]\n"
"regsub -all {%W} $code $w code\n"
"set result [bind $widgets(label$id) $sequence  "
"[list ::mclistbox::LabelEvent $w $id $code]]\n"
"}\n"
"}\n"
"}\n"
"column-add {\n"
"eval ::mclistbox::Column-add {$w} $args\n"
"AdjustColumns $w\n"
"set result \"\"\n"
"}\n"
"column-delete {\n"
"foreach id $args {\n"
"set index [CheckColumnID $w $id]\n"
"set misc(columns) [lreplace $misc(columns) $index $index]\n"
"destroy $widgets(frame$id)\n"
"unset widgets(frame$id)\n"
"unset widgets(listbox$id)\n"
"unset widgets(label$id)\n"
"}\n"
"InvalidateScrollbars $w\n"
"set result \"\"\n"
"}\n"
"column-cget {\n"
"if {[llength $args] != 2} {\n"
"error \"wrong # of args: should be \\\"$w column cget name option\\\"\"\n"
"}\n"
"set id [::mclistbox::Canonize $w column [lindex $args 0]]\n"
"set option [lindex $args 1]\n"
"set data [::mclistbox::Column-configure $w $id $option]\n"
"set result [lindex $data 4]\n"
"}\n"
"column-configure {\n"
"set id [::mclistbox::Canonize $w column [lindex $args 0]]\n"
"set args [lrange $args 1 end]\n"
"set result [eval ::mclistbox::Column-configure {$w} {$id} $args]\n"
"}\n"
"column-names {\n"
"if {[llength $args] != 0} {\n"
"error \"wrong # of args: should be \\\"$w column names\\\"\"\n"
"}\n"
"set result $misc(columns)\n"
"}\n"
"column-nearest {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong # of args: should be \\\"$w column nearest x\\\"\"\n"
"}\n"
"set x [lindex $args 0]\n"
"set tmp [$widgets(text) index @$x,0]\n"
"set tmp [split $tmp \".\"]\n"
"set index [lindex $tmp 1]\n"
"set result [lindex $misc(columns) $index]\n"
"}\n"
"cget {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong # args: should be $w cget option\"\n"
"}\n"
"set opt [::mclistbox::Canonize $w option [lindex $args 0]]\n"
"set result $options($opt)\n"
"}\n"
"configure {\n"
"set result [eval ::mclistbox::Configure {$w} $args]\n"
"}\n"
"curselection {\n"
"set id [lindex $misc(columns) 0]\n"
"set result [$widgets(listbox$id) curselection]\n"
"}\n"
"delete {\n"
"if {[llength $args] < 1 || [llength $args] > 2} {\n"
"error \"wrong \\# of args: should be $w delete first ?last?\"\n"
"}\n"
"if {$options(-selectcommand) != \"\"} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set priorSelection [$widgets(listbox$col0) curselection]\n"
"}\n"
"set index1 [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"if {[llength $args] == 2} {\n"
"set index2 [::mclistbox::MassageIndex $w [lindex $args 1]]\n"
"} else {\n"
"set index2 \"\"\n"
"}\n"
"foreach id $misc(columns) {\n"
"eval {$widgets(listbox$id)} delete $index1 $index2\n"
"}\n"
"eval {$widgets(hiddenListbox)} delete $index1 $index2\n"
"InvalidateScrollbars $w\n"
"set result \"\"\n"
"}\n"
"get {\n"
"if {[llength $args] < 1 || [llength $args] > 2} {\n"
"error \"wrong \\# of args: should be $w get first ?last?\"\n"
"}\n"
"set index1 [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"if {[llength $args] == 2} {\n"
"set index2 [::mclistbox::MassageIndex $w [lindex $args 1]]\n"
"} else {\n"
"set index2 \"\"\n"
"}\n"
"set result [eval ::mclistbox::WidgetProc-get {$w} $index1 $index2]\n"
"}\n"
"index {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong \\# of args: should be $w index index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"set id [lindex $misc(columns) 0]\n"
"set result [$widgets(listbox$id) index $index]\n"
"}\n"
"insert {\n"
"if {[llength $args] < 1} {\n"
"error \"wrong \\# of args: should be $w insert ?element  "
"element...?\"\n"
"}\n"
"if {$options(-selectcommand) != \"\"} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set priorSelection [$widgets(listbox$col0) curselection]\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"::mclistbox::Insert $w $index [lrange $args 1 end]\n"
"InvalidateScrollbars $w\n"
"set result \"\"\n"
"}\n"
"nearest {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong \\# of args: should be $w nearest y\"\n"
"}\n"
"set id [lindex $misc(columns) 0]\n"
"set y [lindex $args 0]\n"
"incr y -[winfo y $widgets(listbox$id)]\n"
"incr y -[winfo y $widgets(frame$id)]\n"
"set col0 [lindex $misc(columns) 0]\n"
"set result [$widgets(listbox$col0) nearest $y]\n"
"}\n"
"scan {\n"
"foreach {subcommand x y} $args {}\n"
"switch $subcommand {\n"
"mark {\n"
"set misc(scanmarkx) $x\n"
"set misc(scanmarky) $y\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) scan mark $x $y\n"
"}\n"
"$widgets(text) scan mark [winfo pointerx $w]  $y\n"
"}\n"
"dragto {\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) scan dragto $misc(scanmarkx) $y\n"
"}\n"
"$widgets(text) scan dragto  "
"[winfo pointerx $w] $misc(scanmarky)\n"
"InvalidateScrollbars $w\n"
"}\n"
"set result \"\"\n"
"}\n"
"}\n"
"see {\n"
"if {[llength $args] != 1} {\n"
"error \"wrong \\# of args: should be $w see index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) see $index\n"
"}\n"
"InvalidateScrollbars $w\n"
"set result {}\n"
"}\n"
"selection {\n"
"if {$options(-selectcommand) != \"\"} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set priorSelection [$widgets(listbox$col0) curselection]\n"
"}\n"
"set subcommand [lindex $args 0]\n"
"set args [lrange $args 1 end]\n"
"set prefix \"wrong \\# of args: should be $w\"\n"
"switch $subcommand {\n"
"includes {\n"
"if {[llength $args] != 1} {\n"
"error \"$prefix selection $subcommand index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"set id [lindex $misc(columns) 0]\n"
"set result [$widgets(listbox$id) selection includes $index]\n"
"}\n"
"set {\n"
"switch [llength $args] {\n"
"1 {\n"
"set index1 [::mclistbox::MassageIndex $w  "
"[lindex $args 0]]\n"
"set index2 \"\"\n"
"}\n"
"2 {\n"
"set index1 [::mclistbox::MassageIndex $w  "
"[lindex $args 0]]\n"
"set index2 [::mclistbox::MassageIndex $w  "
"[lindex $args 1]]\n"
"}\n"
"default {\n"
"error \"$prefix selection clear first ?last?\"\n"
"}\n"
"}\n"
"if {$options(-exportselection)} {\n"
"SelectionHandler $w own\n"
"}\n"
"if {$index1 != \"\"} {\n"
"foreach id $misc(columns) {\n"
"eval {$widgets(listbox$id)} selection set  "
"$index1 $index2\n"
"}\n"
"}\n"
"set result \"\"\n"
"}\n"
"anchor {\n"
"if {[llength $args] != 1} {\n"
"error \"$prefix selection $subcommand index\"\n"
"}\n"
"set index [::mclistbox::MassageIndex $w [lindex $args 0]]\n"
"if {$options(-exportselection)} {\n"
"SelectionHandler $w own\n"
"}\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) selection anchor $index\n"
"}\n"
"set result \"\"\n"
"}\n"
"clear {\n"
"switch [llength $args] {\n"
"1 {\n"
"set index1 [::mclistbox::MassageIndex $w  "
"[lindex $args 0]]\n"
"set index2 \"\"\n"
"}\n"
"2 {\n"
"set index1 [::mclistbox::MassageIndex $w  "
"[lindex $args 0]]\n"
"set index2 [::mclistbox::MassageIndex $w  "
"[lindex $args 1]]\n"
"}\n"
"default {\n"
"error \"$prefix selection clear first ?last?\"\n"
"}\n"
"}\n"
"if {$options(-exportselection)} {\n"
"SelectionHandler $w own\n"
"}\n"
"foreach id $misc(columns) {\n"
"eval {$widgets(listbox$id)} selection clear  "
"$index1 $index2\n"
"}\n"
"set result \"\"\n"
"}\n"
"}\n"
"}\n"
"size {\n"
"set id [lindex $misc(columns) 0]\n"
"set result [$widgets(listbox$id) size]\n"
"}\n"
"}\n"
"if {[info exists priorSelection] && $options(-selectcommand) != \"\"} {\n"
"set column [lindex $misc(columns) 0]\n"
"set currentSelection [$widgets(listbox$column) curselection]\n"
"if {[string compare $priorSelection $currentSelection] != 0} {\n"
"if {![info exists misc(skipRecursiveCall)]} {\n"
"set misc(skipRecursiveCall) 1\n"
"uplevel \\#0 $options(-selectcommand) $currentSelection\n"
"catch {unset misc(skipRecursiveCall)}\n"
"}\n"
"}\n"
"}\n"
"return $result\n"
"}\n"
"proc ::mclistbox::WidgetProc-get {w args} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"set returnType \"list\"\n"
"if {[llength $args] == 1} {\n"
"lappend args [lindex $args 0]\n"
"set returnType \"listOfLists\"\n"
"}\n"
"foreach id $misc(columns) {\n"
"set data($id) [eval {$widgets(listbox$id)} get $args]\n"
"}\n"
"set result {}\n"
"set rows [llength $data($id)]\n"
"for {set i 0} {$i < $rows} {incr i} {\n"
"set this {}\n"
"foreach column $misc(columns) {\n"
"lappend this [lindex $data($column) $i]\n"
"}\n"
"lappend result $this\n"
"}\n"
"if {[string compare $returnType \"list\"] == 0} {\n"
"return $result\n"
"} else {\n"
"return [lindex $result 0]\n"
"}\n"
"}\n"
"proc ::mclistbox::CheckColumnID {w id} {\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"set id [::mclistbox::Canonize $w column $id]\n"
"set index [lsearch -exact $misc(columns) $id]\n"
"return $index\n"
"}\n"
"proc ::mclistbox::LabelEvent {w id code} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"set cursor [$widgets(label$id) cget -cursor]\n"
"if {[string compare $cursor $options(-cursor)] == 0} {\n"
"uplevel \\#0 $code\n"
"}\n"
"}\n"
"proc ::mclistbox::HumanizeList {list} {\n"
"if {[llength $list] == 1} {\n"
"return [lindex $list 0]\n"
"} else {\n"
"set list [lsort $list]\n"
"set secondToLast [expr {[llength $list] -2}]\n"
"set most [lrange $list 0 $secondToLast]\n"
"set last [lindex $list end]\n"
"return \"[join $most {, }] or $last\"\n"
"}\n"
"}\n"
"proc ::mclistbox::Canonize {w object opt} {\n"
"variable widgetOptions\n"
"variable columnOptions\n"
"variable widgetCommands\n"
"variable columnCommands\n"
"variable labelCommands\n"
"switch $object {\n"
"command {\n"
"if {[lsearch -exact $widgetCommands $opt] >= 0} {\n"
"return $opt\n"
"}\n"
"set list $widgetCommands\n"
"foreach element $list {\n"
"set tmp($element) \"\"\n"
"}\n"
"set matches [array names tmp ${opt}*]\n"
"}\n"
"{label command} {\n"
"if {[lsearch -exact $labelCommands $opt] >= 0} {\n"
"return $opt\n"
"}\n"
"set list $labelCommands\n"
"foreach element $list {\n"
"set tmp($element) \"\"\n"
"}\n"
"set matches [array names tmp ${opt}*]\n"
"}\n"
"{column command} {\n"
"if {[lsearch -exact $columnCommands $opt] >= 0} {\n"
"return $opt\n"
"}\n"
"set list $columnCommands\n"
"foreach element $list {\n"
"set tmp($element) \"\"\n"
"}\n"
"set matches [array names tmp ${opt}*]\n"
"}\n"
"option {\n"
"if {[info exists widgetOptions($opt)]  "
"&& [llength $widgetOptions($opt)] == 3} {\n"
"return $opt\n"
"}\n"
"set list [array names widgetOptions]\n"
"set matches [array names widgetOptions ${opt}*]\n"
"}\n"
"{column option} {\n"
"if {[info exists columnOptions($opt)]} {\n"
"return $opt\n"
"}\n"
"set list [array names columnOptions]\n"
"set matches [array names columnOptions ${opt}*]\n"
"}\n"
"column {\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"if {[lsearch -exact $misc(columns) $opt] != -1} {\n"
"return $opt\n"
"}\n"
"set list $misc(columns)\n"
"foreach element $misc(columns) {\n"
"set tmp($element) \"\"\n"
"}\n"
"set matches [array names tmp ${opt}*]\n"
"}\n"
"}\n"
"if {[llength $matches] == 0} {\n"
"set choices [HumanizeList $list]\n"
"error \"unknown $object \\\"$opt\\\"; must be one of $choices\"\n"
"} elseif {[llength $matches] == 1} {\n"
"set opt [lindex $matches 0]\n"
"switch $object {\n"
"option {\n"
"if {[llength $widgetOptions($opt)] == 1} {\n"
"set opt $widgetOptions($opt)\n"
"}\n"
"}\n"
"{column option} {\n"
"if {[llength $columnOptions($opt)] == 1} {\n"
"set opt $columnOptions($opt)\n"
"}\n"
"}\n"
"}\n"
"return $opt\n"
"} else {\n"
"set choices [HumanizeList $list]\n"
"error \"ambiguous $object \\\"$opt\\\"; must be one of $choices\"\n"
"}\n"
"}\n"
"proc ::mclistbox::Configure {w args} {\n"
"variable widgetOptions\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"if {[llength $args] == 0} {\n"
"set results {}\n"
"foreach opt [lsort [array names widgetOptions]] {\n"
"if {[llength $widgetOptions($opt)] == 1} {\n"
"set alias $widgetOptions($opt)\n"
"set optName $widgetOptions($alias)\n"
"lappend results [list $opt $optName]\n"
"} else {\n"
"set optName  [lindex $widgetOptions($opt) 0]\n"
"set optClass [lindex $widgetOptions($opt) 1]\n"
"set default [option get $w $optName $optClass]\n"
"lappend results [list $opt $optName $optClass  "
"$default $options($opt)]\n"
"}\n"
"}\n"
"return $results\n"
"}\n"
"if {[llength $args] == 1} {\n"
"set opt [::mclistbox::Canonize $w option [lindex $args 0]]\n"
"set optName  [lindex $widgetOptions($opt) 0]\n"
"set optClass [lindex $widgetOptions($opt) 1]\n"
"set default [option get $w $optName $optClass]\n"
"set results [list $opt $optName $optClass  "
"$default $options($opt)]\n"
"return $results\n"
"}\n"
"if {[expr {[llength $args]%2}] == 1} {\n"
"error \"value for \\\"[lindex $args end]\\\" missing\"\n"
"}\n"
"foreach {name value} $args {\n"
"set name [::mclistbox::Canonize $w option $name]\n"
"set opts($name) $value\n"
"}\n"
"foreach option [array names opts] {\n"
"set newValue $opts($option)\n"
"if {[info exists options($option)]} {\n"
"set oldValue $options($option)\n"
"}\n"
"switch -- $option {\n"
"-exportselection {\n"
"if {$newValue} {\n"
"SelectionHandler $w own\n"
"set options($option) 1\n"
"} else {\n"
"set options($option) 0\n"
"}\n"
"}\n"
"-fillcolumn {\n"
"AdjustColumns $w\n"
"set options($option) $newValue\n"
"}\n"
"-takefocus {\n"
"$widgets(frame) configure -takefocus $newValue\n"
"set options($option) [$widgets(frame) cget $option]\n"
"}\n"
"-background {\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) configure -background $newValue\n"
"$widgets(frame$id) configure   -background $newValue\n"
"}\n"
"$widgets(frame) configure -background $newValue\n"
"$widgets(text) configure -background $newValue\n"
"set options($option) [$widgets(frame) cget $option]\n"
"}\n"
"-foreground -\n"
"-font -\n"
"-selectborderwidth -\n"
"-selectforeground -\n"
"-selectbackground -\n"
"-setgrid {\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) configure $option $newValue\n"
"}\n"
"$widgets(hiddenListbox) configure $option $newValue\n"
"set options($option) [$widgets(hiddenListbox) cget $option]\n"
"}\n"
"-cursor {\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) configure $option $newValue\n"
"$widgets(frame$id) configure -cursor $newValue\n"
"}\n"
"foreach id $misc(columns) {\n"
"$widgets(frame$id) configure -cursor $newValue\n"
"}\n"
"$widgets(hiddenListbox) configure $option $newValue\n"
"set options($option) [$widgets(hiddenListbox) cget $option]\n"
"}\n"
"-labels {\n"
"if {$newValue} {\n"
"set newValue 1\n"
"foreach id $misc(columns) {\n"
"pack $widgets(label$id)  "
"-side top -fill x -expand n  "
"-before $widgets(listbox$id)\n"
"}\n"
"pack $widgets(hiddenLabel)  "
"-side top -fill x -expand n  "
"-before $widgets(hiddenListbox)\n"
"} else {\n"
"set newValue\n"
"foreach id $misc(columns) {\n"
"pack forget $widgets(label$id)\n"
"}\n"
"pack forget $widgets(hiddenLabel)\n"
"}\n"
"set options($option) $newValue\n"
"}\n"
"-height {\n"
"$widgets(hiddenListbox) configure -height $newValue\n"
"InvalidateScrollbars $w\n"
"set options($option) [$widgets(hiddenListbox) cget $option]\n"
"}\n"
"-width {\n"
"if {$newValue == 0} {\n"
"error \"a -width of zero is not supported. \"\n"
"}\n"
"$widgets(hiddenListbox) configure -width $newValue\n"
"InvalidateScrollbars $w\n"
"set options($option) [$widgets(hiddenListbox) cget $option]\n"
"}\n"
"-columnborderwidth -\n"
"-columnrelief {\n"
"regsub {column} $option {} listboxoption\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) configure $listboxoption $newValue\n"
"}\n"
"$widgets(hiddenListbox) configure $listboxoption $newValue\n"
"set options($option) [$widgets(hiddenListbox) cget  "
"$listboxoption]\n"
"}\n"
"-resizablecolumns {\n"
"if {$newValue} {\n"
"set options($option) 1\n"
"} else {\n"
"set options($option) 0\n"
"}\n"
"}\n"
"-labelimage -\n"
"-labelheight -\n"
"-labelrelief -\n"
"-labelfont -\n"
"-labelanchor -\n"
"-labelbackground -\n"
"-labelforeground -\n"
"-labelborderwidth {\n"
"regsub {label} $option {} labeloption\n"
"foreach id $misc(columns) {\n"
"$widgets(label$id) configure $labeloption $newValue\n"
"}\n"
"$widgets(hiddenLabel) configure $labeloption $newValue\n"
"set options($option) [$widgets(hiddenLabel) cget $labeloption]\n"
"}\n"
"-borderwidth -\n"
"-highlightthickness -\n"
"-highlightcolor -\n"
"-highlightbackground -\n"
"-relief {\n"
"$widgets(frame) configure $option $newValue\n"
"set options($option) [$widgets(frame) cget $option]\n"
"}\n"
"-selectmode {\n"
"set options($option) $newValue\n"
"}\n"
"-selectcommand {\n"
"set options($option) $newValue\n"
"}\n"
"-xscrollcommand {\n"
"InvalidateScrollbars $w\n"
"set options($option) $newValue\n"
"}\n"
"-yscrollcommand {\n"
"InvalidateScrollbars $w\n"
"set options($option) $newValue\n"
"}\n"
"}\n"
"}\n"
"}\n"
"proc ::mclistbox::UpdateScrollbars {w} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"if {![winfo ismapped $w]} {\n"
"catch {unset misc(afterid)}\n"
"return\n"
"}\n"
"update idletasks\n"
"if {[llength $misc(columns)] > 0} {\n"
"if {[string length $options(-yscrollcommand)] != 0} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set yview [$widgets(listbox$col0) yview]\n"
"eval $options(-yscrollcommand) $yview\n"
"}\n"
"if {[string length $options(-xscrollcommand)] != 0} {\n"
"set col0 [lindex $misc(columns) 0]\n"
"set xview [$widgets(text) xview]\n"
"eval $options(-xscrollcommand) $xview\n"
"}\n"
"}\n"
"catch {unset misc(afterid)}\n"
"}\n"
"proc ::mclistbox::InvalidateScrollbars {w} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"if {![info exists misc(afterid)]} {\n"
"set misc(afterid)  "
"[after idle \"catch {::mclistbox::UpdateScrollbars $w}\"]\n"
"}\n"
"}\n"
"proc ::mclistbox::Insert {w index arglist} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"foreach list $arglist {\n"
"for {set i [llength $list]} {$i < [llength $misc(columns)]} {incr i} {\n"
"lappend list {}\n"
"}\n"
"set column 0\n"
"foreach id $misc(columns) {\n"
"$widgets(listbox$id) insert $index [lindex $list $column]\n"
"incr column\n"
"}\n"
"$widgets(hiddenListbox) insert $index \"x\"\n"
"}\n"
"return \"\"\n"
"}\n"
"proc ::mclistbox::ColumnIsHidden {w id} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"set retval 1\n"
"set col [lsearch -exact $misc(columns) $id]\n"
"if {$col != \"\"} {\n"
"set index \"1.$col\"\n"
"catch {\n"
"set window [$widgets(text) window cget $index -window]\n"
"if {[string length $window] > 0 && [winfo exists $window]} {\n"
"set retval 0\n"
"}\n"
"}\n"
"}\n"
"return $retval\n"
"}\n"
"proc ::mclistbox::AdjustColumns {w {height \"\"}} {\n"
"upvar ::mclistbox::${w}::widgets widgets\n"
"upvar ::mclistbox::${w}::options options\n"
"upvar ::mclistbox::${w}::misc    misc\n"
"if {[string length $height] == 0} {\n"
"set height [winfo height $widgets(text)]\n"
"}\n"
"incr height -4\n"
"foreach id $misc(columns) {\n"
"$widgets(frame$id) configure -height $height\n"
"}\n"
"if {$options(-fillcolumn) != \"\"} {\n"
"if {![info exists widgets(frame$options(-fillcolumn))]} {\n"
"return\n"
"}\n"
"set frame $widgets(frame$options(-fillcolumn))\n"
"set minwidth $misc(min-$frame)\n"
"set colwidth 0\n"
"set col 0\n"
"foreach id $misc(columns) {\n"
"if {![ColumnIsHidden $w $id] && $id != $options(-fillcolumn)} {\n"
"incr colwidth [winfo reqwidth $widgets(frame$id)]\n"
"}\n"
"}\n"
"set id $options(-fillcolumn)\n"
"set optwidth [expr {[winfo width $widgets(text)] -  "
"(2 * [$widgets(text) cget -padx])}]\n"
"set newwidth [expr {$optwidth - $colwidth}]\n"
"if {$newwidth < $minwidth} {\n"
"set newwidth $minwidth\n"
"}\n"
"$widgets(frame$id) configure -width $newwidth\n"
"}\n"
"InvalidateScrollbars $w\n"
"}\n"
"proc ::mclistbox::FindResizableNeighbor {w id {direction right}} {\n"
"upvar ::mclistbox::${w}::widgets       widgets\n"
"upvar ::mclistbox::${w}::options       options\n"
"upvar ::mclistbox::${w}::misc          misc\n"
"if {$direction == \"right\"} {\n"
"set incr 1\n"
"set stop [llength $misc(columns)]\n"
"set start [expr {[lsearch -exact $misc(columns) $id] + 1}]\n"
"} else {\n"
"set incr -1\n"
"set stop -1\n"
"set start [expr {[lsearch -exact $misc(columns) $id] - 1}]\n"
"}\n"
"for {set i $start} {$i != $stop} {incr i $incr} {\n"
"set col [lindex $misc(columns) $i]\n"
"if {![ColumnIsHidden $w $col] && $options($col:-resizable)} {\n"
"return $col\n"
"}\n"
"}\n"
"return \"\"\n"
"}\n"
"proc ::mclistbox::ResizeEvent {w type widget x X Y} {\n"
"upvar ::mclistbox::${w}::widgets       widgets\n"
"upvar ::mclistbox::${w}::options       options\n"
"upvar ::mclistbox::${w}::misc          misc\n"
"upvar ::mclistbox::${w}::columnID      columnID\n"
"if {!$options(-resizablecolumns)} {\n"
"return\n"
"}\n"
"variable drag\n"
"set threshold [expr {$options(-labelborderwidth) + 4}]\n"
"set resizeCursor sb_h_double_arrow\n"
"if {![info exists columnID($widget)]} {\n"
"return\n"
"}\n"
"set id $columnID($widget)\n"
"switch $type {\n"
"buttonpress {\n"
"if {[$widgets(label$id) cget -cursor] == $resizeCursor} {\n"
"if {$x <= $threshold} {\n"
"set lid [::mclistbox::FindResizableNeighbor $w $id left]\n"
"if {$lid == \"\"} return\n"
"set drag(leftFrame)  $widgets(frame$lid)\n"
"set drag(rightFrame) $widgets(frame$id)\n"
"set drag(leftListbox)  $widgets(listbox$lid)\n"
"set drag(rightListbox) $widgets(listbox$id)\n"
"} else {\n"
"set rid [::mclistbox::FindResizableNeighbor $w $id right]\n"
"if {$rid == \"\"} return\n"
"set drag(leftFrame)  $widgets(frame$id)\n"
"set drag(rightFrame) $widgets(frame$rid)\n"
"set drag(leftListbox)  $widgets(listbox$id)\n"
"set drag(rightListbox) $widgets(listbox$rid)\n"
"}\n"
"set drag(leftWidth)  [winfo width $drag(leftFrame)]\n"
"set drag(rightWidth) [winfo width $drag(rightFrame)]\n"
"set drag(maxDelta)   [expr {$drag(rightWidth) - 1}]\n"
"set drag(minDelta)  -[expr {$drag(leftWidth) - 1}]\n"
"set drag(x) $X\n"
"}\n"
"}\n"
"motion {\n"
"if {[info exists drag(x)]} {return}\n"
"set resizable 0\n"
"if {!$options($id:-resizable)} {return}\n"
"if {$x < $threshold} {\n"
"set leftColumn [::mclistbox::FindResizableNeighbor $w $id left]\n"
"if {$leftColumn != \"\"} {\n"
"set resizable 1\n"
"}\n"
"} elseif {$x > [winfo width $widget] - $threshold} {\n"
"set rightColumn [::mclistbox::FindResizableNeighbor $w $id  "
"right]\n"
"if {$rightColumn != \"\"} {\n"
"set resizable 1\n"
"}\n"
"}\n"
"set cursor [$widgets(label$id) cget -cursor]\n"
"if {$resizable && $cursor != $resizeCursor} {\n"
"$widgets(label$id) configure -cursor $resizeCursor\n"
"} elseif {!$resizable && $cursor == $resizeCursor} {\n"
"$widgets(label$id) configure -cursor $options(-cursor)\n"
"}\n"
"}\n"
"drag {\n"
"if {[info exists drag(x)]} {\n"
"set delta [expr {$X - $drag(x)}]\n"
"if {$delta >= $drag(maxDelta)} {\n"
"set delta $drag(maxDelta)\n"
"} elseif {$delta <= $drag(minDelta)} {\n"
"set delta $drag(minDelta)\n"
"}\n"
"set lwidth [expr {$drag(leftWidth) + $delta}]\n"
"set rwidth [expr {$drag(rightWidth) - $delta}]\n"
"$drag(leftFrame)   configure -width $lwidth\n"
"$drag(rightFrame)  configure -width $rwidth\n"
"}\n"
"}\n"
"buttonrelease {\n"
"set fillColumnID $options(-fillcolumn)\n"
"if {[info exists drag(x)] && $fillColumnID != {}} {\n"
"set fillColumnFrame $widgets(frame$fillColumnID)\n"
"if {[string compare $drag(leftFrame) $fillColumnFrame] == 0  "
"|| [string compare $drag(rightFrame) $fillColumnFrame] == 0} {\n"
"set width [$fillColumnFrame cget -width]\n"
"set misc(minFillColumnSize) $width\n"
"}\n"
"set misc(min-$drag(leftFrame))  [$drag(leftFrame) cget -width]\n"
"set misc(min-$drag(rightFrame)) [$drag(rightFrame) cget -width]\n"
"}\n"
"catch {unset drag}\n"
"$widgets(label$id) configure -cursor $options(-cursor)\n"
"}\n"
"}\n"
"}\n";

RexxFunctionHandler TkMCListbox              ;
RexxFunctionHandler TkMCListboxColumnAdd     ;
RexxFunctionHandler TkMCListboxColumnCget    ;
RexxFunctionHandler TkMCListboxColumnConfig  ;
RexxFunctionHandler TkMCListboxColumnDelete  ;
RexxFunctionHandler TkMCListboxColumnNames   ;
RexxFunctionHandler TkMCListboxColumnNearest ;
RexxFunctionHandler TkMCListboxLabelBind     ;
RexxFunctionHandler TkMCListboxLoadFuncs     ;
RexxFunctionHandler TkMCListboxDropFuncs     ;

/*-----------------------------------------------------------------------------
 * Table of TK Functions. Used to install/de-install functions.
 * If you change this table, don't forget to change the table at the end
 * of this file.
 *----------------------------------------------------------------------------*/
RexxFunction RxPackageFunctions[] = {
   { "TKMCLISTBOXDROPFUNCS"       ,TkMCListboxDropFuncs       ,"TkMCListboxDropFuncs"       , 1 },
   { "TKMCLISTBOXLOADFUNCS"       ,TkMCListboxLoadFuncs       ,"TkMCListboxLoadFuncs"       , 0 }, /* don't load this from a DLL */
   { "TKMCLISTBOX"                ,TkMCListbox                ,"TkMCListbox"                , 1 },
   { "TKMCLISTBOXCOLUMNADD"       ,TkMCListboxColumnAdd       ,"TkMCListboxColumnAdd"       , 1 },
   { "TKMCLISTBOXCOLUMNCGET"      ,TkMCListboxColumnCget      ,"TkMCListboxColumnCget"      , 1 },
   { "TKMCLISTBOXCOLUMNCONFIG"    ,TkMCListboxColumnConfig    ,"TkMCListboxColumnConfig"    , 1 },
   { "TKMCLISTBOXCOLUMNDELETE"    ,TkMCListboxColumnDelete    ,"TkMCListboxColumnDelete"    , 1 },
   { "TKMCLISTBOXCOLUMNNAMES"     ,TkMCListboxColumnNames     ,"TkMCListboxColumnNames"     , 1 },
   { "TKMCLISTBOXCOLUMNNEAREST"   ,TkMCListboxColumnNearest   ,"TkMCListboxColumnNearest"   , 1 },
   { "TKMCLISTBOXLABELBIND"       ,TkMCListboxLabelBind       ,"TkMCListboxLabelBind"       , 1 },
   { NULL, NULL, NULL, 0 }
};

static char czTclCommand[TCLCOMMANDLEN];
static REXXTKDATA *RexxTkData;
   
#ifdef WIN32
Tcl_Interp *RexxTk_TclCreateInterp(void)
{
   return RexxTkData->Dyn_TclCreateInterp();
}

int RexxTk_TclEval(Tcl_Interp *interp, char *string)
{
   return RexxTkData->Dyn_TclEval( interp, string );
}

int RexxTk_TclInit(Tcl_Interp *interp)
{
   return RexxTkData->Dyn_TclInit( interp );
}

int RexxTk_TkInit(Tcl_Interp *interp)
{
   return RexxTkData->Dyn_TkInit( interp );
}
#endif

/*
 * Rexx/Tk multi-column listbox functions start here...
 */

/*
 * mclistbox pathName ?options?
 * TkMCListbox(pathName [,options])
 */
RFH_RETURN_TYPE TkMCListbox
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   return rtk_TypeA(RexxTkData,czTclCommand,name,"mclistbox::mclistbox", argc, argv, retstr);
}

/*
 * pathName column add name ?options...?
 * TkMCListboxColumnAdd(pathName, name [,options...])
 */
RFH_RETURN_TYPE TkMCListboxColumnAdd
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;

   return rtk_TypeD(RexxTkData,czTclCommand,name,"column add", argc, argv, retstr);
}

/*
 * pathName column cget name option
 * TkMCListboxColumnCget(pathName, name ,option)
 */
RFH_RETURN_TYPE TkMCListboxColumnCget
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;

   return rtk_TypeC(RexxTkData,czTclCommand,name,"column cget", argc, argv, retstr);
}

/*
 * pathName column configure name ?options...?
 * TkMCListboxColumnConfig(pathName, name [,options...])
 */
RFH_RETURN_TYPE TkMCListboxColumnConfig
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 2, 0 ) )
      return 1;

   return rtk_TypeD(RexxTkData,czTclCommand,name,"column configure", argc, argv, retstr);
}

/*
 * pathName column delete name
 * TkMCListboxColumnDelete(pathName, name)
 */
RFH_RETURN_TYPE TkMCListboxColumnDelete
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 2, 2 ) )
      return 1;

   return rtk_TypeC(RexxTkData,czTclCommand,name,"column delete", argc, argv, retstr);
}

/*
 * pathName column names
 * TkMCListboxColumnNames(pathName)
 */
RFH_RETURN_TYPE TkMCListboxColumnNames
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 1, 1 ) )
      return 1;

   return rtk_TypeC(RexxTkData,czTclCommand,name,"column names", argc, argv, retstr);
}

/*
 * pathName column nearest x
 * TkMCListboxColumnNearest(pathName,x)
 */
RFH_RETURN_TYPE TkMCListboxColumnNearest
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 1, 1 ) )
      return 1;

   return rtk_TypeC(RexxTkData,czTclCommand,name,"column nearest", argc, argv, retstr);
}

/*
 * pathName label bind name sequence command
 * TkMCListboxLabelBind(pathName,name,sequence,[*|+]command)
 */
RFH_RETURN_TYPE TkMCListboxLabelBind
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   FunctionPrologue( (char *)name, argc, argv );

   if (RexxTkData->REXXTK_IntCode) ClearIntError( RexxTkData);

   if ( my_checkparam( name, argc, 4, 4 ) )
      return 1;

   czTclCommand[0] = '\0';

   strncat(czTclCommand, argv[0].strptr, argv[0].strlength);
   strcat(czTclCommand, " label bind");
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[1].strptr, argv[1].strlength);
   strcat(czTclCommand, " ");
   strncat(czTclCommand, argv[2].strptr, argv[2].strlength);
   if ( argv[3].strptr[0] == '*' )
   {
      strcat(czTclCommand, " {setRexxtk ");
      strncat(czTclCommand, argv[3].strptr+1, argv[3].strlength);
      strcat(czTclCommand, "} "); 
   }
   else
   {
      strcat(czTclCommand, " ");
      strncat(czTclCommand, argv[3].strptr, argv[3].strlength);
   }
   
   DEBUGDUMP(fprintf(stderr,"%s-%d: (TkMCListboxLabelBind) command: %s\n",__FILE__,__LINE__,czTclCommand);)

   if (Tcl_Eval(RexxTkData->RexxTkInterp, czTclCommand) != TCL_OK)
   {
      return ReturnError(RexxTkData, retstr, -1, RexxTkData->RexxTkInterp->result );
   }
   return RxReturnString( retstr, RexxTkData->RexxTkInterp->result ) ;
}




RFH_RETURN_TYPE TkMCListboxDropFuncs
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
 ULONG rc=0;
 int unload=0;

 if ( my_checkparam(name, argc, 0, 1 ) )
    return( 1 );
 if ( argv[0].strlength == 6
 &&   memcmpi( argv[0].strptr, "UNLOAD", 6 ) == 0 )
    unload = 1;
 rc = DeregisterRxFunctions( unload );
 return RxReturnNumber( retstr, rc );
}


RFH_RETURN_TYPE TkMCListboxLoadFuncs
   (RFH_ARG0_TYPE name, RFH_ARG1_TYPE argc, RFH_ARG2_TYPE argv, RFH_ARG3_TYPE stck, RFH_ARG4_TYPE retstr)
{
   ULONG rc = 0L;

#if defined(DYNAMIC_LIBRARY)
   if ( !QueryRxFunction( "TKWAIT" ) )
   {
      fprintf(stderr,"The base Rexx/Tk function package must be loaded before this one\n");
      return RxReturnNumber( retstr, 1 );
   }
   /*
    * get the pointer to the tcl Interpreter and the base data from base Rexx/Tk
    * library
    */
   if ( argc == 0 )
   {
      fprintf(stderr,"You must pass the return value from TkGetBaseData() as the one and only argument.\n");
      return RxReturnNumber( retstr, 1 );
   }
   RexxTkData = (REXXTKDATA *)atol(argv[0].strptr);
   rc = InitRxPackage( NULL );
   /* 
    * Register all external functions
    */
   if ( !rc )
   {
      rc = RegisterRxFunctions( );
   }
#endif
   return RxReturnNumber( retstr, rc );
}
   
/*
 * The following functions are used in rxpackage.c
 */

/*-----------------------------------------------------------------------------
 * Execute any initialisation
 *----------------------------------------------------------------------------*/
int InitialisePackage

#ifdef HAVE_PROTO
   ( void )
#else
   ( )
#endif

{
   InternalTrace( "InitialisePackage", NULL );

   /*
    * Install the MCListbox widget
    */
   if (Tcl_Eval( RexxTkData->RexxTkInterp,ExtensionSource ) !=TCL_OK) {
      fprintf(stderr, "Tk_Eval for MCListbox widget failed miserably at line %d: %s\n", RexxTkData->RexxTkInterp->errorLine, RexxTkData->RexxTkInterp->result);
      return 1;
   }
   if (Tcl_Eval( RexxTkData->RexxTkInterp,ExtensionSource1 ) !=TCL_OK) {
      fprintf(stderr, "Tk_Eval for MCListbox widget failed miserably at line %d: %s\n", RexxTkData->RexxTkInterp->errorLine, RexxTkData->RexxTkInterp->result);
      return 1;
   }
   DEBUGDUMP(fprintf(stderr,"%s-%d: After Tcl_Eval()\n",__FILE__,__LINE__);)
   return 0;
}

/*-----------------------------------------------------------------------------
 * Execute any termination
 *----------------------------------------------------------------------------*/
int TerminatePackage

#ifdef HAVE_PROTO
   ( void )
#else
   ( )
#endif

{
   return 0;
}


#if defined(USE_REXX6000)
/*
 * This function is used as the entry point for the REXX/6000
 * Rexx Interpreter
 * If you change this table, don't forget to change the table at the
 * start of this file.
 */
USHORT InitFunc( RXFUNCBLOCK **FuncBlock )
{
   static RXFUNCBLOCK funcarray[] =
   {
      { "TKMCLISTBOXDROPFUNCS"       ,TkMCListboxDropFuncs      ,NULL },
      { "TKMCLISTBOXLOADFUNCS"       ,TkMCListboxLoadFuncs      ,NULL },
      { "TKMCLISTBOX"                ,TkMCListbox               ,NULL },
      { "TKMCLISTBOXCOLUMNADD"       ,TkMCListboxColumnAdd      ,NULL },
      { "TKMCLISTBOXCOLUMNCGET"      ,TkMCListboxColumnCget     ,NULL },
      { "TKMCLISTBOXCOLUMNCONFIG"    ,TkMCListboxColumnConfig   ,NULL },
      { "TKMCLISTBOXCOLUMNDELETE"    ,TkMCListboxColumnDelete   ,NULL },
      { "TKMCLISTBOXCOLUMNNAMES"     ,TkMCListboxColumnNames    ,NULL },
      { "TKMCLISTBOXCOLUMNNEAREST"   ,TkMCListboxColumnNearest  ,NULL },
      { "TKMCLISTBOXLABELBIND"       ,TkMCListboxLabelBind      ,NULL },
      { NULL, NULL, NULL }
   } ;
   *FuncBlock = funcarray;
   return (USHORT)0;
}
#endif
