dnl ---------------------------------------------------------------------------
dnl Check if C compiler supports -c -o file.ooo
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CC_O],
[
AC_MSG_CHECKING(whether $CC understand -c and -o together)
set dummy $CC; ac_cc="`echo [$]2 |
changequote(, )dnl
		       sed -e 's/[^a-zA-Z0-9_]/_/g' -e 's/^[0-9]/_/'`"
changequote([, ])dnl
AC_CACHE_VAL(ac_cv_prog_cc_${ac_cc}_c_o,
[echo 'foo(){}' > conftest.c
# We do the test twice because some compilers refuse to overwrite an
# existing .o file with -o, though they will create one.
eval ac_cv_prog_cc_${ac_cc}_c_o=no
ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
then
  ac_try='${CC-cc} -c conftest.c -o conftest.ooo 1>&AC_FD_CC'
  if AC_TRY_EVAL(ac_try) && test -f conftest.ooo && AC_TRY_EVAL(ac_try);
  then
    eval ac_cv_prog_cc_${ac_cc}_c_o=yes
  fi
fi
rm -f conftest*
])dnl
if eval "test \"`echo '$ac_cv_prog_cc_'${ac_cc}_c_o`\" = yes"; then
	O2SHO=""
	O2SAVE=""
	SAVE2O=""
	CC2O="-o $"'@'
	AC_MSG_RESULT(yes)
else
	O2SHO="-mv \`basename "$'@'" .sho\`.o "$'@'
	O2SAVE="-mv \`basename "$'@'" .sho\`.o \`basename "$'@'" .sho\`.o.save"
	SAVE2O="-mv \`basename "$'@'" .sho\`.o.save \`basename "$'@'" .sho\`.o"
	CC2O=""
	AC_MSG_RESULT(no)
fi
])

dnl ---------------------------------------------------------------------------
dnl Check if __sighandler_t is defined
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK__SIGHANDLER_T],
[
AC_MSG_CHECKING(whether __sighandler_t is defined)

AC_CACHE_VAL(
[mh_cv__sighandler_t],
[
AC_TRY_COMPILE(
[#include <sys/types.h>]
[#include <signal.h>],
[__sighandler_t fred],
[mh_cv__sighandler_t=yes],
[mh_cv__sighandler_t=no]
)
])dnl
AC_MSG_RESULT($mh_cv__sighandler_t)
if test "$mh_cv__sighandler_t" = yes ; then
	AC_DEFINE(HAVE__SIGHANDLER_T)
fi
])

dnl ---------------------------------------------------------------------------
dnl Work out how to create a dynamically loaded module
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_HOWTO_DYN_LINK],
[
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.rxlib conftest.o -lc 1>&AC_FD_CC'
#	mh_dyn_link='${CC} -Wl,-shared -o conftest.rxlib conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
		LD_RXLIB1="ld -shared"
#		LD_RXLIB1="${CC} -Wl,-shared"
		LD_RXLIB2="-L. -l${LIBFILE}"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
	else
		mh_dyn_link='ld -G -o conftest.rxlib conftest.o 1>&AC_FD_CC'
#		mh_dyn_link='${CC} -Wl,-G -o conftest.rxlib conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.rxlib; then
			LD_RXLIB1="ld -G"
#			LD_RXLIB1="${CC} -Wl,-G"
			LD_RXLIB2="-L. -l${LIBFILE}"
			RXLIBPRE="lib"
			RXLIBPST=".so"
			RXLIBLEN="6"
		else
			LD_RXLIB1=""
			LD_RXLIB2=""
			RXLIBPRE=""
			RXLIBPST=""
			RXLIBLEN="0"
		fi
	fi
fi
rm -f conftest*
])dnl

dnl ---------------------------------------------------------------------------
dnl Work out how to create a shared library
dnl ---------------------------------------------------------------------------
AC_DEFUN(MH_HOWTO_SHARED_LIBRARY,
[
AC_MSG_CHECKING(how to create a shared library)
mh_compile='${CC-cc} -c $DYN_COMP conftest.$ac_ext 1>&AC_FD_CC'
cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int foo()
{
return(0);
}
EOF
if AC_TRY_EVAL(mh_compile) && test -s conftest.o; then
	mh_dyn_link='ld -shared -o conftest.so.1.0 conftest.o -lc 1>&AC_FD_CC'
#	mh_dyn_link='${CC} -Wl,-shared -o conftest.so.1.0 conftest.o -lc 1>&AC_FD_CC'
	if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
		SHL_LD="ld -shared -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'" -lc"
#		SHL_LD="${CC} -Wl,-shared -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'" -lc"
	else
		mh_dyn_link='ld -G -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
#		mh_dyn_link='${CC} -Wl,-G -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
		if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
			SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
#			SHL_LD="${CC} -Wl,-G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		else
			mh_dyn_link='ld -o conftest.so.1.0 -shared -no_archive conftest.o  -lc 1>&AC_FD_CC'
#			mh_dyn_link='${CC} -o conftest.so.1.0 -Wl,-shared,-no_archive conftest.o  -lc 1>&AC_FD_CC'
			if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
				SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL} -shared -no_archive "'$('SHOFILES')'" -lc"
#				SHL_LD="${CC} -o ${LIBPRE}${LIBFILE}.${SHL} -Wl,-shared,-no_archive "'$('SHOFILES')'" -lc"
			else
				mh_dyn_link='ld -b -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
#				mh_dyn_link='${CC} -Wl,-b -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
				if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
					SHL_LD="ld -b -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
#					SHL_LD="${CC} -Wl,-b -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
				else
					mh_dyn_link='ld -Bshareable -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
#					mh_dyn_link='${CC} -Wl,-Bshareable -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
					if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
						SHL_LD="ld -Bshareable -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
#						SHL_LD="${CC} -Wl,-Bshareable -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
					else
						mh_dyn_link='ld -assert pure-text -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
#						mh_dyn_link='${CC} -Wl,-assert pure-text -o conftest.so.1.0 conftest.o 1>&AC_FD_CC'
						if AC_TRY_EVAL(mh_dyn_link) && test -s conftest.so.1.0; then
							SHL_LD="ld -assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
#							SHL_LD="${CC} -Wl,-assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
						else
							SHL_LD=""
						fi
					fi
				fi
			fi
		fi
	fi
fi
if test "$SHL_LD" = ""; then
	AC_MSG_RESULT(unknown)
else
	AC_MSG_RESULT(found)
fi
rm -f conftest*
])

dnl ---------------------------------------------------------------------------
dnl Check for presence of various libraries
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_LIB],
[
MH_EXTRA_LIBS=''
for mh_lib in $1; do
	if test "$on_qnx" = yes; then
		AC_MSG_CHECKING(for library -l${mh_lib})
		if test -r /usr/lib/${mh_lib}3r.lib; then
			AC_MSG_RESULT(found)
			MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -l${mh_lib}"
		else
		AC_MSG_RESULT(not found)
		fi
	else
		AC_CHECK_LIB($mh_lib,main,mh_lib_found=yes,mh_lib_found=no)
		if test "$mh_lib_found" = yes; then
			MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -l${mh_lib}"
		fi
	fi
done
])dnl

dnl ---------------------------------------------------------------------------
dnl Check for presence of various libraries
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CRYPT],
[
mh_save_libs="$LIBS"

if test "$on_qnx" = no; then
	AC_CHECK_LIB(crypt,main,mh_crypt_found=yes,mh_crypt_found=no)
	if test "$mh_crypt_found" = yes; then
		LIBS="${LIBS} -lcrypt"
	fi
fi

AC_MSG_CHECKING(for crypt function)

AC_CACHE_VAL(
[mh_cv_func_crypt],
[
	AC_TRY_LINK(
[#include <unistd.h>],
[crypt("fred","aa")],
	[mh_cv_func_crypt=yes],
	[mh_cv_func_crypt=no]
	)
])dnl
AC_MSG_RESULT($mh_cv_func_crypt)
if test "$mh_cv_func_crypt" = yes ; then
	AC_DEFINE(HAVE_CRYPT)
	if test "$mh_crypt_found" = yes; then
		MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -lcrypt"
	fi
fi

LIBS="$mh_save_libs"

])dnl

dnl ---------------------------------------------------------------------------
dnl Determine how to build shared libraries etc..
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_SHARED_LIBRARY],
[
dnl
dnl If compiler is gcc, then flags should be the same for all platforms
dnl (just guessing on this)
dnl
SHL="so"
LIBPRE="lib"
LIBFILE="regina"
SHLFILE="regina"
OSAVE=".o.save"
OBJ="o"
EXE=""
LIBPST="a"
LIBEXE="ar"
GETOPT=""
OBJECTS='$('OFILES')'
STATIC_LDFLAGS=""
AIX_DYN="no"

AC_REQUIRE([AC_CANONICAL_SYSTEM])
case "$target" in
	*hp-hpux10*)
		SYS_DEFS="-D_HPUX_SOURCE"
		SHL="sl"
		;;
	*hp-hpux*) 
		SYS_DEFS="-D_HPUX_SOURCE"
		SHL="sl"
		;;
	*ibm-aix4.2*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
		DYN_COMP="-DDYNAMIC"
		SHL="a"
		;;
	*ibm-aix*)
		SYS_DEFS="-D_ALL_SOURCE -DAIX"
		SHL="a"
		;;
	*dec-osf*)
		if test "$ac_cv_prog_CC" = "gcc"; then
			SYS_DEFS="-D_POSIX_SOURCE -D_XOPEN_SOURCE"
		else
			SYS_DEFS="-D_POSIX_SOURCE -D_XOPEN_SOURCE -Olimit 800"
		fi
		;;
	*sequent-dynix*)
		;;
	*solaris*)
		;;
	*esix*)
		;;
	sparc*sunos*)
		SYS_DEFS="-DSUNOS -DSUNOS_STRTOD_BUG"
		;;
	*linux*)
		;;
	*qnx*)
		LIBPRE=""
		LIBPST="lib"
		;;
esac

dnl
dnl set variables for compiling if we don't already have it
dnl
if test "$DYN_COMP" = ""; then
AC_MSG_CHECKING(compiler flags for a dynamic object)

cat > conftest.$ac_ext <<EOF
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
int a=0
EOF

	DYN_COMP=""
	mh_cv_stop=no
	save_cflags="$CFLAGS"
	mh_cv_flags="-fPIC -KPIC +Z"
	for a in $mh_cv_flags; do
		CFLAGS="-c $a"

		mh_compile='${CC-cc} -c $CFLAGS conftest.$ac_ext > conftest.tmp 2>&1'
		if AC_TRY_EVAL(mh_compile); then
			DYN_COMP=""
		else
			slash="\\"
			mh_dyncomp="`egrep -c $slash$a conftest.tmp`"
			if test "$mh_dyncomp" = "0"; then
				DYN_COMP="$a -DDYNAMIC"
				AC_MSG_RESULT($a)
				break
			else
				DYN_COMP=""
			fi
		fi
	done
	if test "$DYN_COMP" = ""; then
		AC_MSG_RESULT(none of $mh_cv_flags supported)
	fi
	CFLAGS=$save_cflags
	rm -f conftest.*
fi

dnl
dnl set variables for linking
dnl
SHL_LD=""
TEST1EXPORTS=""
TEST2EXPORTS=""
TEST1EXP=""
TEST2EXP=""
REGINAEXP=""
case "$target" in
	*hp-hpux*) 
		EEXTRA="-Wl,-E"
		LD_RXLIB1="ld -b -q -n"
#		LD_RXLIB1="${CC} -Wl,-b,-q,-n"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS="-Wl,+s"
		RXLIBPRE="lib"
		RXLIBPST=".sl"
		RXLIBLEN="6"
		SHL_LD="ld -b -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
#		SHL_LD="${CC} -Wl,-b -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
#	*ibm-aix4.2*)
#		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
#		LD_RXLIB1="ld -G"
#		LD_RXLIB2=""
#		RXLIBPRE="lib"
#		RXLIBPST=".so"
#		RXLIBLEN="6"
#		SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL} -shared -no_archive "'$('SHOFILES')'" -lc"
#		;;
	*ibm-aix3*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld -bnoentry -bM:SRE -bT:512 -bH:512 -bI:regina.exp"
		LD_RXLIB2="${LIBPRE}${LIBFILE}.${SHL} -lc"
		RXLIBPRE="lib"
		RXLIBPST=".a"
		RXLIBLEN="5"
		TEST1EXPORTS="-bE:test1.exp"
		TEST2EXPORTS="-bE:test2.exp"
		TEST1EXP="test1.exp"
		TEST2EXP="test2.exp"
		REGINAEXP="regina.exp"
		if test "$ac_cv_header_dlfcn_h" = "yes" -o "$HAVE_DLFCN_H" = "1"; then
			AIX_DYN="yes"
			DYN_COMP="-DDYNAMIC"
			SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL} -bnoentry -bE:regina.exp -bM:SRE -bT:512 -bH:512 "'$('SHOFILES')'" -lc"
		else
			SHL_LD=" "'$('LIBEXE')'" "'$('LIBFLAGS')'" "'$('SHOFILES')'
			DYN_COMP=""
		fi
		;;
	*ibm-aix4*)
		STATIC_LDFLAGS="-bnso -bI:/lib/syscalls.exp"
		LD_RXLIB1="ld -bnoentry -bM:SRE"
		LD_RXLIB2="${LIBPRE}${LIBFILE}.${SHL} -lc"
		RXLIBPRE="lib"
		RXLIBPST=".a"
		RXLIBLEN="5"
		TEST1EXPORTS="-bE:test1.exp"
		TEST2EXPORTS="-bE:test2.exp"
		TEST1EXP="test1.exp"
		TEST2EXP="test2.exp"
		REGINAEXP="regina.exp"
		if test "$ac_cv_header_dlfcn_h" = "yes" -o "$HAVE_DLFCN_H" = "1"; then
			AIX_DYN="yes"
			DYN_COMP="-DDYNAMIC"
			SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL} -bnoentry -bE:regina.exp -bM:SRE "'$('SHOFILES')'" -lc "'$('SHLIBS')'
		else
			SHL_LD=" "'$('LIBEXE')'" "'$('LIBFLAGS')'" "'$('SHOFILES')'
			DYN_COMP=""
		fi
		;;
	*dec-osf*)
		LD_RXLIB1="ld -shared"
		LD_RXLIB2="-lc -L. -l${LIBFILE}"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -o ${LIBPRE}${LIBFILE}.${SHL} -shared -no_archive "'$('SHOFILES')'" -lc"
		;;
	*esix*)
		LD_RXLIB1="ld -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	*dgux*)
		LD_RXLIB1="ld -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	*pc-sco*)
		LD_RXLIB1="ld -dy -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -dy -G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	*solaris*)
		LD_RXLIB1="ld -G"
		LD_RXLIB2=""
		DYNAMIC_LDFLAGS=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -G -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	sparc*sunos*)
		LD_RXLIB1="ld"
		LD_RXLIB2=""
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -assert pure-text -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	*freebsd*)
		LD_RXLIB1="ld -Bdynamic -Bshareable"
		LD_RXLIB2="-lc -L. -l${LIBFILE}"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="ld -Bdynamic -Bshareable -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'
		;;
	*linux*)
		LD_RXLIB1="${CC} -Wl,-shared"
		LD_RXLIB2="-L. -l${LIBFILE}"
		RXLIBPRE="lib"
		RXLIBPST=".so"
		RXLIBLEN="6"
		SHL_LD="${CC} -Wl,-shared -o ${LIBPRE}${LIBFILE}.${SHL} "'$('SHOFILES')'" -lc"
		;;
	*qnx*)
		LD_RXLIB1=""
		LD_RXLIB2=""
		RXLIBPRE=""
		RXLIBPST=".lib"
		SHL_LD=""
		EEXTRA="-mf -N0x20000 -Q"
		LIBPRE=""
		LIBPST="lib"
		;;
	*)
		MH_HOWTO_SHARED_LIBRARY()
		MH_HOWTO_DYN_LINK()
		;;
esac

if test "$AIX_DYN" = "yes"; then
	STATICLIB=""
else
	STATICLIB="${LIBPRE}${LIBFILE}.${LIBPST}"
fi

LIBFLAGS="cr ${LIBPRE}${LIBFILE}.${LIBPST}"
LIBLINK="-L. -l${LIBFILE}"

#
# For HPUX, we must link the "regina" executable with -lregina
# otherwise you can't move the shared library anywhere other
# than where it was built. Fix by PJM
#
if test "$RXLIBPST" = ".sl"; then
	LINKSHL="$LIBLINK"
else
	LINKSHL="${LIBPRE}${SHLFILE}.${SHL}"
fi

if test "$ac_cv_header_dl_h" = "yes" -o "$ac_cv_header_dlfcn_h" = "yes" -o "$AIX_DYN" = "yes"; then
	SHL_TARGETS="regina${EXE} ${LIBPRE}${SHLFILE}.${SHL} ${RXLIBPRE}test1${RXLIBPST} ${RXLIBPRE}test2${RXLIBPST}"
	EXECISER_DEP="${LIBPRE}${SHLFILE}.${SHL}"
else
	SHL_TARGETS=""
	EXECISER_DEP="${STATICLIB}"
fi

AC_SUBST(SHL)
AC_SUBST(EEXTRA)
AC_SUBST(EXECISER_DEP)
AC_SUBST(CEXTRA)
AC_SUBST(LIBPRE)
AC_SUBST(LIBFILE)
AC_SUBST(SHLFILE)
AC_SUBST(STATICLIB)
AC_SUBST(OSAVE)
AC_SUBST(OBJ)
AC_SUBST(EXE)
AC_SUBST(LIBPST)
AC_SUBST(LIBEXE)
AC_SUBST(LIBFLAGS)
AC_SUBST(LIBLINK)
AC_SUBST(LINKSHL)
AC_SUBST(GETOPT)
AC_SUBST(OBJECTS)
AC_SUBST(DYN_COMP)
AC_SUBST(BOTHLIBS)
AC_SUBST(SHLIBS)
AC_SUBST(LD_RXLIB1)
AC_SUBST(LD_RXLIB2)
AC_SUBST(RXLIBPRE)
AC_SUBST(RXLIBPST)
AC_SUBST(RXLIBLEN)
AC_SUBST(DYNAMIC_LDFLAGS)
AC_SUBST(STATIC_LDFLAGS)
AC_SUBST(SHL_LD)
AC_SUBST(SHL_TARGETS)
AC_SUBST(O2SAVE)
AC_SUBST(O2SHO)
AC_SUBST(CC2O)
AC_SUBST(SAVE2O)
AC_SUBST(TEST1EXPORTS)
AC_SUBST(TEST2EXPORTS)
AC_SUBST(TEST1EXP)
AC_SUBST(TEST2EXP)
AC_SUBST(REGINAEXP)
])dnl
