/*	 recover.cpp
 *
 *	 Recover v1.3 
 *	 (C) 1999-2000 by Tom Pycke <Tom.Pycke@advalvas.be>
 *	 
 *	 Bugfixes:
 *		Matthias Andree
 *		Paul Casella
 *
 *	 Useful Bug reports:
 *		Ed Cogburn
 *
 *   Convertion into plain C:
 *      Harald Arnesen
 *
 *	 This utility automates some steps as described
 *	 in the Ext2fs-Undeletion howto by Aaron Crane 
 *	 (http://pobox.com/~aaronc/tech/e2-undel/howto.txt)
 *	 in order to recover a lost file.
 *	 There is absolutely NO WARRANTY. But there is no
 *	 huge risk losing any data (as far as i know).
 *	 This program is made using kernel version 2.2.6
 *	 and e2fsprogs v1.14 which should come with your
 *	 distribution.
 *	 Normally, it should also work with other versions.
 *	 Just let me know if there seems to be a problem.
 *
 */


////					  I N C L U D E S					 ////

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <sys/wait.h>
#include <signal.h>
#include "recover.h"


// These are the pointers to the questions
extern char *questions[17];

char months_list[13][4] =
{
	{"JAN"}, {"FEB"}, {"MAR"}, {"APR"}, {"MAY"}, {"JUN"}, {"JUL"},
	{"AUG"}, {"SEP"}, {"OCT"}, {"NOV"}, {"DEC"}, {"-1"}
};

char weeks_list[8][4] =
{
	{"MON"}, {"TUE"}, {"WED"}, {"THU"},
	{"FRI"}, {"SAT"}, {"SUN"}, {"-1"}
};

int lang_cmp[17] = { 11, 9, 10, 9, 10, 9, 9, 9, 12, 12, 10, 10, 9, 9, 7, 9, 9 };
char lang_str[17][14] =
{
	{"[ask_device\0 "}, {"[ask_year\0   "}, {"[ask_month\0  "},
	{"[month_eg\0   "}, {"[ask_weekd\0  "}, {"[weekd_eg\0   "},
	{"[ask_day1\0   "}, {"[ask_day2\0   "}, {"[ask_minsize\0"},
	{"[ask_maxsize\0"}, {"[ask_hour1\0  "}, {"[ask_hour2\0  "},
	{"[ask_min1\0   "}, {"[ask_min2\0   "}, {"[ask_id\0     "},
	{"[ask_dump\0   "}, {"[ask_refilter"}
};



////					 F U N C T I O N S					////

extern void prn_error (char *message);
extern int print_devices (void);
extern void print_uid ();
extern void start_it (char *device1, int all);


// This function converts a whole string to uppercase
void strtoupper (char *str)
{
	int x;
	for (x=0;str[x]!=0;x++)
		str[x]=toupper(str[x]);
}


int chcmp (char *a, char *b)
{
	if (a[0]==b[0] && a[1]==b[1] && a[2]==b[2])
		return 0;
	return 1;
}


FILE *
get_output (char *command)
{
	int fd[2], pid;

	pipe (fd);
	switch ((pid = fork ())) {
	case 0:
		close (fd[0]);
		dup2 (fd[1], 1);
		if (execl ("/bin/sh", "sh", "-c", command, NULL) == -1) {
			strcat (command, ": can't run it");
			prn_error (command);
			exit (0);
			return NULL;
		}
		break;
	case -1:
		perror(command);
		exit(1);
	default:
		break;
	}
	//	  waitpid (pid, NULL, 0);
	close (fd[1]);
	return fdopen (fd[0], "r");
}

// checks if the string is a day of the week
int 
check_week (char *day)
{
	int x;
	strtoupper (day);
	for (x = 0; x < 8; x++)
		if (!strcmp (day, &weeks_list[x][0]))
			return 1;
	return 0;
}

// checks if the string is a month
int 
check_month (char *month)
{
	int x;
	strtoupper (month);
	for (x = 0; x < 13; x++)
		if (!strcmp (month, &months_list[x][0]))
			return 1;
	return 0;
}


inode *
get_inodes (char *device)
{
	char temp[256], dummy[12];
	int num_del_inodes, x, pid, fd[2];
	int blocks;
	inode *cur_inode, *lastinode = NULL, *firstinode;
	FILE *list;
	printf ("Getting inodes (this can take some time)...\n");
#ifdef lsdel_file
// make sure there is an lsdel file in the current dir.
// debugfs -R lsdel > lsdel and delete the first line
// in the file (i think ;-)
	list = get_output ("cat lsdel");
#else
	sprintf (temp, "debugfs -R lsdel %s", device);
	list = get_output (temp);
#endif
	fgets (temp, 256, list);
	sscanf (temp, "%d", &num_del_inodes);
	fgets (temp, 256, list);

	for (x = 0; x </*=*/ num_del_inodes; x++) {
		cur_inode = (inode *)malloc (sizeof (inode));
		if (lastinode != NULL)
			lastinode->next_inode = cur_inode;
		else
			firstinode = cur_inode;
		fgets (temp, 256, list);
		sscanf (temp, "%d %d %d %d %[^/]/%d %s %s %d %d:%d:%d %d",
				&(cur_inode->number),
				&(cur_inode->UID),
				&(cur_inode->mode),
				&(cur_inode->size),
				&dummy,
				&blocks,
				&(cur_inode->weekd),
				&(cur_inode->month),
				&(cur_inode->day),
				&(cur_inode->hour),
				&(cur_inode->min),
				&(cur_inode->sec),
				&(cur_inode->year));
		strtoupper (cur_inode->weekd);
		strtoupper (cur_inode->month);
		
#ifdef DEBUG
		printf ("-> %d, %s,  %d\n", cur_inode->number,
					cur_inode->weekd, cur_inode->year);
#endif
		lastinode = cur_inode;
	}
	fclose (list);
	cur_inode->next_inode = NULL;
	return (firstinode);
}

int 
filter_inode (	inode * firstinode, 
		inode_list * inodestart,
		int userid,
		int minsize,
		int maxsize,
		char *month,
		char *weekd,
		int minday,
		int maxday,
		int minhour,
		int maxhour,
		int minmin,
		int maxmin,
		int minsec,
		int maxsec,
		int year )
{
	int	x,
		count = 0;
	inode *cur_inode;
	inode_list *nextstart = inodestart, *thisstart = inodestart;

	cur_inode = firstinode;
#ifdef DEBUG
	if (strlen (cur_inode->month)!=3) {
		printf ("memory error\n");
	}
#endif
	for (x = 0; cur_inode != NULL; x++) {
		if ((cur_inode->UID != userid && userid != -1) ||
			cur_inode->size < minsize ||
			cur_inode->size > maxsize ||
			(chcmp (cur_inode->month, month) != 0 &&
			 chcmp (month, "-1") != 0) ||
			(chcmp (cur_inode->weekd, weekd) != 0 &&
			 chcmp (weekd, "-1") != 0) ||
			cur_inode->day < minday ||
			cur_inode->day > maxday ||
			cur_inode->hour < minhour ||
			cur_inode->hour > maxhour ||
			cur_inode->min < minmin ||
			cur_inode->min > maxmin ||
			cur_inode->sec < minsec ||
			cur_inode->sec > maxsec ||
			(cur_inode->year != year && year != -1))
		{
		}
		else {
			printf ("=> %d %d %s %s %d %d:%d:%d %d\n", 
					cur_inode->number,
					cur_inode->size,
					cur_inode->month,
					cur_inode->weekd,
					cur_inode->day,
					cur_inode->hour,
					cur_inode->min,
					cur_inode->sec,
					cur_inode->year);
			thisstart->next_inode = nextstart;
			thisstart = nextstart;
			thisstart->number = cur_inode->number;
			thisstart->mem_location = cur_inode;
			thisstart->next_inode = NULL;
			nextstart = (inode_list *)malloc (sizeof (inode_list));
			count++;
		}
		cur_inode = cur_inode->next_inode;
	}
	return count;
}

// This function isn't used
int free_inodes (inode * firstinode)
{
	inode *curinode = firstinode, *tempinode;
	for (; curinode != NULL;) {
		tempinode = curinode->next_inode;
		free (curinode);
		curinode = tempinode;
	}
}

// erases the /n in the string. This function could 
// be way easier, but allows now other filtering.
void cleanstr (char *str)
{
	int x;
	for (x=0;str[x]!=0;x++)
		if (str[x]=='\n' || str[x]=='\0')
			break;
	str[x-1] = ' ';
	str[x] = '\0';
}

// This function reads recover_questions
int get_questions(char *lang)
{
	char	line[101],
		header[20],
		temp[20],
		temp2[20],
		temp3[20],
		*dest;
	FILE *txt;
	int	x,
		xx,
		langcount=1,
		tmp,
		place;
	
	txt = fopen (QUESTIONS_LOCATION, "r");
	if (txt == NULL) {
		txt = fopen("recover_questions", "r");
		if (txt == NULL) {
			printf ("cannot find %s", QUESTIONS_LOCATION);
			exit(1);
		}
	}
	for (; line!=NULL ;) {
		if (fgets (line, 80, txt) == 0)
			break;
		if (line[0]=='#')
			continue;
		if (line[0]=='[') {
			if (strncmp (line, "[language",9)==0) {
				for (x=1; temp[0]!='#';x++) {
					tmp = fscanf (txt, "%s%s%s", &temp, &temp2, &temp3);
					strtoupper (temp);
					strtoupper (temp2);
					strtoupper (temp3);
					if (strcmp (lang, temp)==0 ||
						strcmp (lang, temp2)==0 ||
						strcmp (lang, temp3)==0 )
					{
						langcount = x;
#ifdef DEBUG
						printf ("langcount = %d\n", langcount);
#endif
						break;
					}
				}
				
			}
			else
				for (x=0; x<17; x++) {
					if (strncmp (line, lang_str[x], lang_cmp[x]) == 0) {
						for (xx=0; xx < langcount; xx++)
							fgets (line, 100, txt);
						cleanstr (line);
						questions[x] = (char*) malloc (strlen (line)+1);
						strcpy (questions[x], line);
						//printf ("->%s\n", questions[x]);
						break;
					}
				}
		}
	}
	fclose (txt);
}

int 
main (int argc, char *argv[])
{
	char	lang[30],
		*tmp,
		*device = NULL;
	int	x,
		all = 0;
	printf ("%s\n\n", INIT_STR);

// get language
	for (x=0; argv[x]!=NULL; x++) {
		if (strcmp (argv[x], "-h") == 0 || strcmp (argv[x], "--help") == 0) {
			printf ("usage: recover [device]\n" \
			"  -a, --all		restores all deleted inodes on device\n");
			exit (0);
		}
		if (strncmp (argv[x], "/dev/", 5) == 0)
			device = argv[x];
		if (strcmp (argv[x], "-a") == 0 || strcmp (argv[x], "--all") == 0)
			all = 1;
	}

	if (geteuid()) {
		prn_error ("You must be root to debug the file system!");
		exit (1);
	}

	if (!argv[1]) {
		tmp = getenv ("LANG");
		if (tmp != NULL)
			strcpy (lang, tmp);
		else
			strcpy (lang, "EN");
		strtoupper (lang);
	}
	else {
		for (x=0; *(argv[1]+x) != 0; x++)
			lang[x] = toupper (*(argv[1]+x));
		lang[x] = '\0';
	}
	//printf ("--> %s\n", lang);

	get_questions (lang);
	start_it (device, all);
	exit (0);
}
