/******************************************************************************
*		       							      *
* engine/engine.h (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* Include this file for access to all rcalc's functions except debugging.
*/

#ifndef __RC_ENGINE_H__
#define __RC_ENGINE_H__

#ifndef RCALC_TEXT_ONLY
#include <gnome.h>
#else
#include <glib.h>
#endif

#include "imp_exp.h"

#include <stdio.h>

typedef struct _RcEngine RcEngine;
typedef struct _RcLastRes RcLastRes;
typedef void (*RcDisplayHelpFunc)( const char *file_name, const char *link_id,  GError **error);
typedef enum
{
	RC_ANGLE_DEGREES,
	RC_ANGLE_RADIANS,
	_RC_NUMBER_OF_ANGLE_UNITS
}
RcAngleUnit;


RcEngine*	rc_engine_new		( void );
void		rc_engine_delete	( RcEngine 		*engine );

void		rc_engine_set_streams	( RcEngine 		*engine, 
					  FILE 			*output,
					  FILE			*error );
void		rc_engine_set_help_func	( RcEngine 		*engine,
					  RcDisplayHelpFunc	func );

void		rc_engine_load_state	( RcEngine		*engine );
void		rc_engine_save_state	( const	RcEngine	*engine );

RcAngleUnit	rc_engine_get_angleunit	( const	RcEngine	*engine );
void		rc_engine_set_angleunit	( RcEngine		*engine,
					  RcAngleUnit		 unit );

gboolean	rc_engine_execute	( RcEngine 		*engine,
					  const gchar  		*command );
RcLastRes rc_import_lastres( void );
void rc_engine_clean_state (RcEngine *engine);

gboolean verifyFunction(gchar *formula);

int text_config_get_int(FILE *cfg_file, char *cfg_string);
double text_config_get_float(FILE *cfg_file, char *cfg_string);
gchar * text_config_get_string(FILE *cfg_file, char *cfg_string);

#endif /* __RC_ENGINE_H__ */
