/*
 * @LANG: c++
 */

/*
 * Test error actions.
 */

#include <iostream>
#include <stdio.h>

using namespace std;

#define DIGIT   0x01
#define PLUS    0x02
#define MINUS   0x04
#define DECIMAL 0x08

int expt = 0;

struct ErrAct
{
	int cs;

	// Initialize the machine. Invokes any init statement blocks. Returns 0
	// if the machine begins in a non-accepting state and 1 if the machine
	// begins in an accepting state.
	void init( );

	// Execute the machine on a block of data. Returns -1 if after processing
	// the data, the machine is in the error state and can never accept, 0 if
	// the machine is in a non-accepting state and 1 if the machine is in an
	// accepting state.
	void execute( const char *data, int len );

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( );
};

%%{
	machine ErrAct;

	action err_start { printf("err_start\n"); }
	action err_all { printf("err_all\n"); }
	action err_middle { printf("err_middle\n"); }
	action err_out { printf("err_out\n"); }

	action eof_start { printf("eof_start\n"); }
	action eof_all { printf("eof_all\n"); }
	action eof_middle { printf("eof_middle\n"); }
	action eof_out { printf("eof_out\n"); }

	main := ( 'hello' 
			>!err_start $!err_all <@!err_middle %!err_out
			>/eof_start $/eof_all <@/eof_middle %/eof_out
		) '\n';
}%%

%% write data;

void ErrAct::init( )
{
	%% write init;
}

void ErrAct::execute( const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;
	%% write exec;
}

int ErrAct::finish( )
{
	%% write eof;
	if ( cs == ErrAct_error )
		return -1;
	if ( cs >= ErrAct_first_final )
		return 1;
	return 0;
}

void test( char *buf )
{
	/* Take the first character to be the length. */
	int len = buf[0] - '0';
	ErrAct errAct;

	errAct.init();
	errAct.execute( buf+1, len );
	if ( errAct.finish() > 0 )
		cout << "ACCEPT" << endl;
	else
		cout << "FAIL" << endl;
}

int main()
{
	test( "0\n" );
	test( "1h\n" );
	test( "1x\n" );
	test( "2he\n" );
	test( "2hx\n" );
	test( "3hel\n" );
	test( "3hex\n" );
	test( "4hell\n" );
	test( "4helx\n" );
	test( "5hello\n" );
	test( "5hellx\n" );
	test( "6hello\n" );
	test( "6hellox\n" );

	return 0;
}

#ifdef _____OUTPUT_____
eof_start
eof_all
FAIL
eof_all
eof_middle
FAIL
err_start
err_all
FAIL
eof_all
eof_middle
FAIL
err_all
err_middle
FAIL
eof_all
eof_middle
FAIL
err_all
err_middle
FAIL
eof_all
eof_middle
FAIL
err_all
err_middle
FAIL
eof_all
eof_out
FAIL
err_all
err_middle
FAIL
ACCEPT
err_all
err_out
FAIL
#endif
