/* 
 * @LANG: java
 * @ALLOW_GENFLAGS: -T0
 */

class cond7
{
	%%{
		machine cond7;

		action c1 {i!=0}
		action c2 {j!=0}
		action c3 {k!=0}
		action one { System.out.println( "  one" ); }
		action two { System.out.println( "  two" ); }
		action three { System.out.println( "  three" ); }

		one = 'a' 'b' when c1 'c' @one;

		two = 'a'* 'b' when c2 'c' @two;
		
		three = 'a'+ 'b' when c3 'c' @three;

		main := ( one | two | three ) '\n' @{fbreak;};
		
	}%%

	%% write data noerror;

	static void test( int i, int j, int k, char str[] )
	{
		char data[] = str;
		int p = 0, pe = data.length;
		int cs = cond7_start;
		System.out.println( "run:" );
		%% write exec noend;
		if ( cs >= cond7_first_final )
			System.out.println( "  success" );
		else
			System.out.println( "  failure" );
		System.out.println( "" );
	}

	public static void main( String args[] )
	{
		test( 0, 0, 0, "abc\n".toCharArray() );
		test( 1, 0, 0, "abc\n".toCharArray() );
		test( 0, 1, 0, "abc\n".toCharArray() );
		test( 1, 1, 0, "abc\n".toCharArray() );
		test( 0, 0, 1, "abc\n".toCharArray() );
		test( 1, 0, 1, "abc\n".toCharArray() );
		test( 0, 1, 1, "abc\n".toCharArray() );
		test( 1, 1, 1, "abc\n".toCharArray() );
	}
}

/* _____OUTPUT_____
run:
  failure

run:
  one
  success

run:
  two
  success

run:
  one
  two
  success

run:
  three
  success

run:
  one
  three
  success

run:
  two
  three
  success

run:
  one
  two
  three
  success

*/
