#ifndef _game_h_
#define _game_h_

#include "allegro.h"
#include <vector>
#include <aldumb.h>

using namespace std;

class LevelCreator;
class SpaceObject;
class ExplosionClass;
class Section;

class GameRunnable{
public:

	GameRunnable( bool dl, DATAFILE * _snd, char * fl, SpaceObject * player );

	int RunGame( SpaceObject * player, int lev );

	~GameRunnable();

protected:
	
	void draw_land( int y1 );
	void drawAll( int Land_count, vector< SpaceObject * > * draws, SpaceObject * player );

	void LoadLand(RLE_SPRITE *& who);
	
	void HandleExplosion();

	void HandleSpace( vector< SpaceObject *> * mv, vector< SpaceObject * > * fight, vector< SpaceObject * > * Ammo, Section * onscreen );
	void DeleteSpace( vector< SpaceObject *> * objs, Section * sec, SpaceObject * _player );
	void DeleteAll( vector< SpaceObject *> * objs );
	//void CheckCollision( vector< SpaceObject * > good, vector< SpaceObject * > fight, SpaceObject * take, int sound, int vol );
	void CheckCollision( Section * good, Section * fight, SpaceObject * take, int sound, int vol );
	
	bool end_level( vector< SpaceObject * > * PlayerTemp, double Land_real, double Land_speed );

private:

	//void MakeExplosion( ExplosionClass ** expl, int M_EX, int x, int y );
	void clearCollide( vector< SpaceObject * > * contain );
	void vectorAdd( vector< SpaceObject * > * stable, vector< SpaceObject * > * state );
	DUH * load_music();

	int fsec;
	int fsec_keep;
	long int timex;
	int GAME_SPEED;

	int level_speech;
	int level_use;

	int f_count, f_total;
	double f_double;

	bool DRAW_LAND;

	int blend_trans;
	bool finished;

	LevelCreator * level;

	ExplosionClass ** expl;
	BITMAP * work;
	RLE_SPRITE * land;
	BITMAP * land2;
	BITMAP * radar;

	DATAFILE * data;
	DATAFILE * snd;

	int view_port;

	int * player_shade;
	int player_shade_color;
	
	DUH * dumb_file;
	AL_DUH_PLAYER * dumb_player;

	vector< SpaceObject * > delete_hold;

};

#endif
