% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_start_end.R
\name{str_start}
\alias{str_start}
\alias{str_end}
\title{Find start and end index of pattern in string}
\usage{
str_start(x, pattern, ignore.case = TRUE)

str_end(x, pattern, ignore.case = TRUE)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string to be matched in \code{x}. \code{pattern} might also
be a regular-expression object, as returned by \code{\link[stringr]{regex}},
or any of \pkg{stringr}'s supported \code{\link[stringr]{modifiers}}.}

\item{ignore.case}{Logical, whether matching should be case sensitive or not.}
}
\value{
A numeric vector with index of start/end position(s) of \code{pattern}
         found in \code{x}, or an empty vector, if \code{pattern} was not found
         in \code{x}.
}
\description{
\code{str_start()} finds the beginning position of \code{pattern}
  in each element of \code{x}, while \code{str_end()} finds the stopping position
  of \code{pattern} in each element of \code{x}.
}
\examples{
path <- "this/is/my/fileofinterest.csv"
str_start(path, "/")

path <- "this//is//my//fileofinterest.csv"
str_start(path, "//")
str_end(path, "//")

x <- c("my_friend_likes me", "your_friend likes_you")
str_start(x, "_")

# pattern "likes" starts at position 11 in first, and
# position 13 in second string
str_start(x, "likes")

# pattern "likes" ends at position 15 in first, and
# position 17 in second string
str_end(x, "likes")

x <- c("I like to move it, move it", "You like to move it")
str_start(x, "move")
str_end(x, "move")

}
