#########################################################################/**
# @RdocPackage R.cache
#
# \description{
#   @eval "getDescription(R.cache)"
# }
#
# \section{Installation and updates}{
#   To install this package and all of its dependent packages, do:
#   \code{install.packages("R.cache")}
# }
#
# \section{To get started}{
#   \itemize{
#    \item{\link{loadCache}, \link{saveCache}}{
#      Methods for loading and saving objects from and to the cache.
#    }
#    \item{\link{getCacheRootPath}, \link{setCacheRootPath}}{
#      Methods for getting and setting the directory where cache
#      files are stored.
#    }
#   }
# }
#
# \section{How to cite this package}{
#   Whenever using this package, please cite [1] as
#
#   @howtocite "R.oo"
# }
#
# \section{Wishlist}{
#  Here is a list of features that would be useful, but which I have
#  too little time to add myself. Contributions are appreciated.
#  \itemize{
#    \item Add a functionality to identify cache files that are
#       no longer of use.  For now, there is an extra header field
#       for arbitrary comments which can be used, but maybe more
#       formal fields are useful, e.g. keywords, user, etc?
#  }
#
#  If you consider implement some of the above, make sure it is not
#  already implemented by downloading the latest "devel" version!
# }
#
# \section{Related work}{
#  See also the \pkg{filehash} package, and the \code{cache()} function
#  in the \pkg{Biobase} package of Bioconductor.
# }
#
# @author
#
# \section{License}{
#   The releases of this package is licensed under
#   LGPL version 2.1 or newer.
#
#   The development code of the packages is under a private licence
#   (where applicable) and patches sent to the author fall under the
#   latter license, but will be, if incorporated, released under the
#   "release" license above.
# }
#
# \section{References}{
# [1] @include "../incl/BengtssonH_2003.bib.Rdoc" \cr
# }
#*/#########################################################################
