% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_data.R
\name{find_data}
\alias{find_data}
\alias{find_data.default}
\alias{find_data.data.frame}
\alias{find_data.crch}
\alias{find_data.glimML}
\alias{find_data.glm}
\alias{find_data.hxlr}
\alias{find_data.lm}
\alias{find_data.mca}
\alias{find_data.merMod}
\alias{find_data.svyglm}
\alias{find_data.train}
\alias{find_data.vgam}
\alias{find_data.vglm}
\title{Extract data from a model object}
\usage{
find_data(model, ...)

\method{find_data}{default}(model, env = parent.frame(), ...)

\method{find_data}{data.frame}(model, ...)

\method{find_data}{crch}(model, env = parent.frame(), ...)

\method{find_data}{glimML}(model, ...)

\method{find_data}{glm}(model, env = parent.frame(), ...)

\method{find_data}{hxlr}(model, env = parent.frame(), ...)

\method{find_data}{lm}(model, env = parent.frame(), ...)

\method{find_data}{mca}(model, env = parent.frame(), ...)

\method{find_data}{merMod}(model, env = parent.frame(), ...)

\method{find_data}{svyglm}(model, ...)

\method{find_data}{train}(model, ...)

\method{find_data}{vgam}(model, env = parent.frame(), ...)

\method{find_data}{vglm}(model, env = parent.frame(), ...)
}
\arguments{
\item{model}{The model object.}

\item{\dots}{Additional arguments passed to methods.}

\item{env}{An environment in which to look for the \code{data} argument to the modelling call.}
}
\value{
A data frame containing the original data used in a modelling call, modified according to the original model's `subset` and `na.action` arguments, if appropriate.
}
\description{
Attempt to reconstruct the data used to create a model object
}
\details{
This is a convenience function and, as such, carries no guarantees. To behave well, it typically requires that a model object be specified using a formula interface and an explicit \code{data} argument. Models that can be specified using variables from the \code{.GlobalEnv} or with a non-formula interface (e.g., a matrix of data) will tend to generate errors. \code{find_data} is an S3 generic so it is possible to expand it with new methods.
}
\examples{
require("datasets")
x <- lm(mpg ~ cyl * hp + wt, data = head(mtcars))
find_data(x)

}
\seealso{
\code{\link{prediction}}, \code{\link{build_datalist}}, \code{\link{mean_or_mode}}, \code{\link{seq_range}}
}
