% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm-tidiers.R
\name{glance.gmm}
\alias{glance.gmm}
\title{Glance at a(n) gmm object}
\usage{
\method{glance}{gmm}(x, ...)
}
\arguments{
\item{x}{A \code{gmm} object returned from \code{\link[gmm:gmm]{gmm::gmm()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:
\item{df}{Degrees of freedom}
\item{statistic}{Statistic from J-test for E(g)=0}
\item{p.value}{P-value from J-test}
\item{df.residual}{Residual degrees of freedom, if included in \code{x}.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[gmm:gmm]{gmm::gmm()}}

Other gmm tidiers: \code{\link{tidy.gmm}}
}
\concept{gmm tidiers}
