% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allData.R
\docType{data}
\name{data-GlobalPatterns}
\alias{GlobalPatterns}
\alias{data-GlobalPatterns}
\title{(Data) Global patterns of 16S rRNA diversity at a depth of millions of sequences per sample (2011)}
\description{
Published in PNAS in early 2011. This work compared the microbial 
communities from 25 environmental samples and three known ``mock communities''
-- a total of 9 sample types -- at a depth averaging 3.1 million reads per sample.
Authors were able to reproduce diversity patterns seen in many other 
published studies, while also invesitigating technical issues/bias by 
applying the same techniques to simulated microbial communities of known
composition.
}
\details{
abstract from research article (quoted):

The ongoing revolution in high-throughput sequencing continues to democratize the ability of small groups of investigators to map the microbial component of the biosphere. In particular, the coevolution of new sequencing platforms and new software tools allows data acquisition and analysis on an unprecedented scale. Here we report the next stage in this coevolutionary arms race, using the Illumina GAIIx platform to sequence a diverse array of 25 environmental samples and three known ``mock communities'' at a depth averaging 3.1 million reads per sample. We demonstrate excellent consistency in taxonomic recovery and recapture diversity patterns that were previously reported on the basis of metaanalysis of many studies from the literature (notably, the saline/nonsaline split in environmental samples and the split between host-associated and free-living communities). We also demonstrate that 2,000 Illumina single-end reads are sufficient to recapture the same relationships among samples that we observe with the full dataset. The results thus open up the possibility of conducting large-scale studies analyzing thousands of samples simultaneously to survey microbial communities at an unprecedented spatial and temporal resolution.

(end quote)

Many thanks to J. Gregory Caporaso for directly providing the OTU-clustered data files
for inclusion in this package.
}
\examples{
data(GlobalPatterns)
plot_richness(GlobalPatterns, x="SampleType", measures=c("Observed", "Chao1", "Shannon"))
}
\author{
Caporaso, J. G., et al.
}
\references{
Caporaso, J. G., et al. (2011). 
Global patterns of 16S rRNA diversity at a depth of millions of sequences per sample.
PNAS, 108, 4516-4522.
PMCID: PMC3063599

The primary article can be viewed/downloaded at:
\url{http://www.pnas.org/content/108/suppl.1/4516.short}
}
\seealso{
The examples on the phyloseq wiki page for \code{\link{plot_ordination}} show 
 many more examples:

\url{https://github.com/joey711/phyloseq/wiki/plot_ordination}
}
\keyword{data}

