% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{ts2MRexperiment}
\alias{ts2MRexperiment}
\title{With a list of fitTimeSeries results, generate
an MRexperiment that can be plotted with metavizr}
\usage{
ts2MRexperiment(obj, sampleNames = NULL, sampleDescription = "timepoints",
  taxonomyLevels = NULL, taxonomyHierarchyRoot = "bacteria",
  taxonomyDescription = "taxonomy", featuresOfInterest = NULL)
}
\arguments{
\item{obj}{Output of fitMultipleTimeSeries}

\item{sampleNames}{Sample names for plot}

\item{sampleDescription}{Description of samples for plot axis label}

\item{taxonomyLevels}{Feature names for plot}

\item{taxonomyHierarchyRoot}{Root of feature hierarchy for MRexperiment}

\item{taxonomyDescription}{Description of features for plot axis label}

\item{featuresOfInterest}{The features to select from the fitMultipleTimeSeries output}
}
\value{
MRexperiment that contains fitTimeSeries data, featureData, and phenoData
}
\description{
With a list of fitTimeSeries results, generate
an MRexperiment that can be plotted with metavizr
}
\examples{

data(mouseData)
res = fitMultipleTimeSeries(obj=mouseData,lvl='phylum',class="status",
          id="mouseID",time="relativeTime",B=1)
obj = ts2MRexperiment(res)
obj

}
\seealso{
\code{\link{fitTimeSeries}} \code{\link{fitMultipleTimeSeries}}
}

