# Copyright 2005 Joe Wreschnig
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# $Id: autorating.py 3644 2006-07-16 23:11:24Z piman $

from plugins.events import EventPlugin

class AutoRating(EventPlugin):
    PLUGIN_ID = "Automatic Rating"
    PLUGIN_NAME = _("Automatic Rating")
    PLUGIN_VERSION = "0.22"
    PLUGIN_DESC = ("Rate songs automatically when they are played or "
                   "skipped. This uses the 'accelerated' algorithm from "
                   "vux by Brian Nelson.")

    def plugin_on_song_ended(self, song, skipped):
        rating = song["~#rating"]
        invrating = 1.0 - rating
        delta = min(rating, invrating) / 2.0
        if skipped: rating -= delta
        else: rating += delta
        song["~#rating"] = rating
