/***************************************************************************
 *            dialog_initial.h
 *
 *  Fri Aug 25 14:43:10 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/** @file dialog_initial.h
	@brief  Application context handlers.
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999 Bob Lissner
	@author Copyright 1999 Jay MacDonald
	@author Copyright 1999 Sam Phillips
	@author Copyright 1999 Keith Wesolowski 
*/
#ifndef _DIALOG_INITIAL_H
#define _DIALOG_INITIAL_H

#include "main.h"
#include "field.h"

/** \brief Creates the main QuickList window.

Uses a notebook interface and remains open 
<b>and visible</b> for as long as the program 
is running, unlike the old version.
*/
void main_window (QlContext * qlc);

/** \brief Retrieve the QuickList Context

Given any widget within the parent window, retrieve
the context associated with the toplevel window widget 
and return it
*/
QlContext *
ql_get_context (GtkWidget * widget);

void
ql_free_context (QlContext *qlc);

QlFileData *
ql_get_filedata (QlContext * qlc);

QlViewData *
ql_get_viewdata (QlContext * qlc);

QlTabData *
ql_new_tabdata (QlContext * qlc);

QlTabData *
ql_get_tabdata (QlContext * qlc);

/** Get information about a specific field in the tab */
QlFieldInfo *
ql_get_fieldinfo (QlTabData * tab, gint field_index);

/** iterator type for field information. */
typedef void (*QlFieldInfoCB) (gpointer index, gpointer field, gpointer user_data);

/** \brief iterate over each field in the tab

 \param tab The notebook tab containing the GtkSheet
 \param cb  QlFieldInfoCB function to pass each field from the sheet.
 \param user_data Pointer to data to pass to the callback.
*/
void
ql_fieldinfo_foreach (QlTabData * tab, QlFieldInfoCB cb, gpointer user_data);

/** Add a new field to the sheet in the specified tab. */
gboolean
ql_add_fieldinfo (QlTabData * tab, QlFieldInfo * field);

/** \brief Set the field information for a specific field in a tab.

 \param tab Pointer to the notebook tab containing the GtkSheet
 \param field Pointer to the field information to set
 \param field_index Index value for the field to change.

 \return FALSE on error or if the field_index does not exist,
otherwise TRUE.
*/
gboolean
ql_set_fieldinfo (QlTabData * tab, QlFieldInfo * field, gint field_index);

/** \brief Remove a field from the sheet 

Despite the name, removes the entire field - once the fieldinfo has
been removed, the field itself no longer exists.
*/
void
ql_remove_fieldinfo (QlTabData * tab, gint field_index);

/** replace the last_field value */
gint
ql_get_last_field (QlTabData * tab);

#endif /* _DIALOG_INITIAL_H */
